/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SendMessageRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String queueUrl;
    private String messageBody;
    private Integer delaySeconds;
    private Map<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
    private String messageDeduplicationId;
    private String messageGroupId;

    public SendMessageRequest() {
    }

    public SendMessageRequest(String queueUrl, String messageBody) {
        this.setQueueUrl(queueUrl);
        this.setMessageBody(messageBody);
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public SendMessageRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public SendMessageRequest withMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Integer getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public SendMessageRequest withDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public SendMessageRequest withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
        return this;
    }

    public SendMessageRequest addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new HashMap<String, MessageAttributeValue>();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public SendMessageRequest clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public String getMessageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public void setMessageDeduplicationId(String messageDeduplicationId) {
        this.messageDeduplicationId = messageDeduplicationId;
    }

    public SendMessageRequest withMessageDeduplicationId(String messageDeduplicationId) {
        this.messageDeduplicationId = messageDeduplicationId;
        return this;
    }

    public String getMessageGroupId() {
        return this.messageGroupId;
    }

    public void setMessageGroupId(String messageGroupId) {
        this.messageGroupId = messageGroupId;
    }

    public SendMessageRequest withMessageGroupId(String messageGroupId) {
        this.messageGroupId = messageGroupId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getMessageBody() != null) {
            sb.append("MessageBody: " + this.getMessageBody() + ",");
        }
        if (this.getDelaySeconds() != null) {
            sb.append("DelaySeconds: " + this.getDelaySeconds() + ",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: " + this.getMessageAttributes() + ",");
        }
        if (this.getMessageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: " + this.getMessageDeduplicationId() + ",");
        }
        if (this.getMessageGroupId() != null) {
            sb.append("MessageGroupId: " + this.getMessageGroupId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getMessageBody() == null ? 0 : this.getMessageBody().hashCode());
        hashCode = 31 * hashCode + (this.getDelaySeconds() == null ? 0 : this.getDelaySeconds().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMessageDeduplicationId() == null ? 0 : this.getMessageDeduplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getMessageGroupId() == null ? 0 : this.getMessageGroupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getMessageBody() == null ^ this.getMessageBody() == null) {
            return false;
        }
        if (other.getMessageBody() != null && !other.getMessageBody().equals(this.getMessageBody())) {
            return false;
        }
        if (other.getDelaySeconds() == null ^ this.getDelaySeconds() == null) {
            return false;
        }
        if (other.getDelaySeconds() != null && !other.getDelaySeconds().equals(this.getDelaySeconds())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        if (other.getMessageAttributes() != null && !other.getMessageAttributes().equals(this.getMessageAttributes())) {
            return false;
        }
        if (other.getMessageDeduplicationId() == null ^ this.getMessageDeduplicationId() == null) {
            return false;
        }
        if (other.getMessageDeduplicationId() != null && !other.getMessageDeduplicationId().equals(this.getMessageDeduplicationId())) {
            return false;
        }
        if (other.getMessageGroupId() == null ^ this.getMessageGroupId() == null) {
            return false;
        }
        return other.getMessageGroupId() == null || other.getMessageGroupId().equals(this.getMessageGroupId());
    }
}

