/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchRequestEntryStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        String prefix;
        if (sendMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SendMessageBatchRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        if (sendMessageBatchRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = sendMessageBatchRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (sendMessageBatchRequest.getEntries() != null) {
            prefix = "SendMessageBatchRequestEntry";
            List<SendMessageBatchRequestEntry> entries = sendMessageBatchRequest.getEntries();
            int entriesIndex = 1;
            String entriesPrefix = prefix;
            for (SendMessageBatchRequestEntry entriesItem : entries) {
                prefix = entriesPrefix + "." + entriesIndex;
                if (entriesItem != null) {
                    SendMessageBatchRequestEntryStaxMarshaller.getInstance().marshall(entriesItem, (Request<?>)request, prefix + ".");
                }
                ++entriesIndex;
            }
            String string = entriesPrefix;
        }
        return request;
    }
}

