/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReceiveMessageRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String queueUrl;
    private List<String> attributeNames = new ArrayList<String>();
    private List<String> messageAttributeNames = new ArrayList<String>();
    private Integer maxNumberOfMessages;
    private Integer visibilityTimeout;
    private Integer waitTimeSeconds;
    private String receiveRequestAttemptId;

    public ReceiveMessageRequest() {
    }

    public ReceiveMessageRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public ReceiveMessageRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new ArrayList<String>(attributeNames);
    }

    public ReceiveMessageRequest withAttributeNames(String ... attributeNames) {
        if (this.getAttributeNames() == null) {
            this.attributeNames = new ArrayList<String>(attributeNames.length);
        }
        for (String value : attributeNames) {
            this.attributeNames.add(value);
        }
        return this;
    }

    public ReceiveMessageRequest withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public List<String> getMessageAttributeNames() {
        return this.messageAttributeNames;
    }

    public void setMessageAttributeNames(Collection<String> messageAttributeNames) {
        if (messageAttributeNames == null) {
            this.messageAttributeNames = null;
            return;
        }
        this.messageAttributeNames = new ArrayList<String>(messageAttributeNames);
    }

    public ReceiveMessageRequest withMessageAttributeNames(String ... messageAttributeNames) {
        if (this.getMessageAttributeNames() == null) {
            this.messageAttributeNames = new ArrayList<String>(messageAttributeNames.length);
        }
        for (String value : messageAttributeNames) {
            this.messageAttributeNames.add(value);
        }
        return this;
    }

    public ReceiveMessageRequest withMessageAttributeNames(Collection<String> messageAttributeNames) {
        this.setMessageAttributeNames(messageAttributeNames);
        return this;
    }

    public Integer getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }

    public ReceiveMessageRequest withMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
        return this;
    }

    public Integer getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public ReceiveMessageRequest withVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
        return this;
    }

    public Integer getWaitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public void setWaitTimeSeconds(Integer waitTimeSeconds) {
        this.waitTimeSeconds = waitTimeSeconds;
    }

    public ReceiveMessageRequest withWaitTimeSeconds(Integer waitTimeSeconds) {
        this.waitTimeSeconds = waitTimeSeconds;
        return this;
    }

    public String getReceiveRequestAttemptId() {
        return this.receiveRequestAttemptId;
    }

    public void setReceiveRequestAttemptId(String receiveRequestAttemptId) {
        this.receiveRequestAttemptId = receiveRequestAttemptId;
    }

    public ReceiveMessageRequest withReceiveRequestAttemptId(String receiveRequestAttemptId) {
        this.receiveRequestAttemptId = receiveRequestAttemptId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: " + this.getAttributeNames() + ",");
        }
        if (this.getMessageAttributeNames() != null) {
            sb.append("MessageAttributeNames: " + this.getMessageAttributeNames() + ",");
        }
        if (this.getMaxNumberOfMessages() != null) {
            sb.append("MaxNumberOfMessages: " + this.getMaxNumberOfMessages() + ",");
        }
        if (this.getVisibilityTimeout() != null) {
            sb.append("VisibilityTimeout: " + this.getVisibilityTimeout() + ",");
        }
        if (this.getWaitTimeSeconds() != null) {
            sb.append("WaitTimeSeconds: " + this.getWaitTimeSeconds() + ",");
        }
        if (this.getReceiveRequestAttemptId() != null) {
            sb.append("ReceiveRequestAttemptId: " + this.getReceiveRequestAttemptId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributeNames() == null ? 0 : this.getMessageAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getMaxNumberOfMessages() == null ? 0 : this.getMaxNumberOfMessages().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityTimeout() == null ? 0 : this.getVisibilityTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getWaitTimeSeconds() == null ? 0 : this.getWaitTimeSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getReceiveRequestAttemptId() == null ? 0 : this.getReceiveRequestAttemptId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        if (other.getAttributeNames() != null && !other.getAttributeNames().equals(this.getAttributeNames())) {
            return false;
        }
        if (other.getMessageAttributeNames() == null ^ this.getMessageAttributeNames() == null) {
            return false;
        }
        if (other.getMessageAttributeNames() != null && !other.getMessageAttributeNames().equals(this.getMessageAttributeNames())) {
            return false;
        }
        if (other.getMaxNumberOfMessages() == null ^ this.getMaxNumberOfMessages() == null) {
            return false;
        }
        if (other.getMaxNumberOfMessages() != null && !other.getMaxNumberOfMessages().equals(this.getMaxNumberOfMessages())) {
            return false;
        }
        if (other.getVisibilityTimeout() == null ^ this.getVisibilityTimeout() == null) {
            return false;
        }
        if (other.getVisibilityTimeout() != null && !other.getVisibilityTimeout().equals(this.getVisibilityTimeout())) {
            return false;
        }
        if (other.getWaitTimeSeconds() == null ^ this.getWaitTimeSeconds() == null) {
            return false;
        }
        if (other.getWaitTimeSeconds() != null && !other.getWaitTimeSeconds().equals(this.getWaitTimeSeconds())) {
            return false;
        }
        if (other.getReceiveRequestAttemptId() == null ^ this.getReceiveRequestAttemptId() == null) {
            return false;
        }
        return other.getReceiveRequestAttemptId() == null || other.getReceiveRequestAttemptId().equals(this.getReceiveRequestAttemptId());
    }
}

