/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.List;

class MessageAttributeValueStaxMarshaller {
    private static MessageAttributeValueStaxMarshaller instance;

    MessageAttributeValueStaxMarshaller() {
    }

    public void marshall(MessageAttributeValue _messageAttributeValue, Request<?> request, String _prefix) {
        String prefix;
        if (_messageAttributeValue.getStringValue() != null) {
            prefix = _prefix + "StringValue";
            String stringValue = _messageAttributeValue.getStringValue();
            request.addParameter(prefix, StringUtils.fromString((String)stringValue));
        }
        if (_messageAttributeValue.getBinaryValue() != null) {
            prefix = _prefix + "BinaryValue";
            ByteBuffer binaryValue = _messageAttributeValue.getBinaryValue();
            request.addParameter(prefix, StringUtils.fromByteBuffer((ByteBuffer)binaryValue));
        }
        if (_messageAttributeValue.getStringListValues() != null) {
            prefix = _prefix + "StringListValue";
            List<String> stringListValues = _messageAttributeValue.getStringListValues();
            int stringListValuesIndex = 1;
            String stringListValuesPrefix = prefix;
            for (String stringListValuesItem : stringListValues) {
                prefix = stringListValuesPrefix + "." + stringListValuesIndex;
                if (stringListValuesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)stringListValuesItem));
                }
                ++stringListValuesIndex;
            }
            prefix = stringListValuesPrefix;
        }
        if (_messageAttributeValue.getBinaryListValues() != null) {
            prefix = _prefix + "BinaryListValue";
            List<ByteBuffer> binaryListValues = _messageAttributeValue.getBinaryListValues();
            int binaryListValuesIndex = 1;
            String binaryListValuesPrefix = prefix;
            for (ByteBuffer binaryListValuesItem : binaryListValues) {
                prefix = binaryListValuesPrefix + "." + binaryListValuesIndex;
                if (binaryListValuesItem != null) {
                    request.addParameter(prefix, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesItem));
                }
                ++binaryListValuesIndex;
            }
            prefix = binaryListValuesPrefix;
        }
        if (_messageAttributeValue.getDataType() != null) {
            prefix = _prefix + "DataType";
            String dataType = _messageAttributeValue.getDataType();
            request.addParameter(prefix, StringUtils.fromString((String)dataType));
        }
    }

    public static MessageAttributeValueStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new MessageAttributeValueStaxMarshaller();
        }
        return instance;
    }
}

