/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchRequestEntryStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        String prefix;
        if (deleteMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteMessageBatchRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        if (deleteMessageBatchRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = deleteMessageBatchRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (deleteMessageBatchRequest.getEntries() != null) {
            prefix = "DeleteMessageBatchRequestEntry";
            List<DeleteMessageBatchRequestEntry> entries = deleteMessageBatchRequest.getEntries();
            int entriesIndex = 1;
            String entriesPrefix = prefix;
            for (DeleteMessageBatchRequestEntry entriesItem : entries) {
                prefix = entriesPrefix + "." + entriesIndex;
                if (entriesItem != null) {
                    DeleteMessageBatchRequestEntryStaxMarshaller.getInstance().marshall(entriesItem, (Request<?>)request, prefix + ".");
                }
                ++entriesIndex;
            }
            String string = entriesPrefix;
        }
        return request;
    }
}

