/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        String prefix;
        if (addPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AddPermissionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "AmazonSQS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        if (addPermissionRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = addPermissionRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (addPermissionRequest.getLabel() != null) {
            prefix = "Label";
            String label = addPermissionRequest.getLabel();
            request.addParameter(prefix, StringUtils.fromString((String)label));
        }
        if (addPermissionRequest.getAWSAccountIds() != null) {
            prefix = "AWSAccountId";
            List<String> aWSAccountIds = addPermissionRequest.getAWSAccountIds();
            int aWSAccountIdsIndex = 1;
            String aWSAccountIdsPrefix = prefix;
            for (String aWSAccountIdsItem : aWSAccountIds) {
                prefix = aWSAccountIdsPrefix + "." + aWSAccountIdsIndex;
                if (aWSAccountIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)aWSAccountIdsItem));
                }
                ++aWSAccountIdsIndex;
            }
            prefix = aWSAccountIdsPrefix;
        }
        if (addPermissionRequest.getActions() != null) {
            prefix = "ActionName";
            List<String> actions = addPermissionRequest.getActions();
            int actionsIndex = 1;
            String actionsPrefix = prefix;
            for (String actionsItem : actions) {
                prefix = actionsPrefix + "." + actionsIndex;
                if (actionsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)actionsItem));
                }
                ++actionsIndex;
            }
            String string = actionsPrefix;
        }
        return request;
    }
}

