/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListRestoreJobsByProtectedResourceRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     */
    private String byStatus;
    /**
     * <p>
     * Returns only restore jobs of recovery points that were created after the specified date.
     * </p>
     */
    private java.util.Date byRecoveryPointCreationDateAfter;
    /**
     * <p>
     * Returns only restore jobs of recovery points that were created before the specified date.
     * </p>
     */
    private java.util.Date byRecoveryPointCreationDateBefore;
    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request ismade to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @param resourceArn
     *        Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @param resourceArn
     *        Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRestoreJobsByProtectedResourceRequest withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * 
     * @param byStatus
     *        Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */

    public void setByStatus(String byStatus) {
        this.byStatus = byStatus;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * 
     * @return Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */

    public String getByStatus() {
        return this.byStatus;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * 
     * @param byStatus
     *        Returns only restore jobs associated with the specified job status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RestoreJobStatus
     */

    public ListRestoreJobsByProtectedResourceRequest withByStatus(String byStatus) {
        setByStatus(byStatus);
        return this;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * 
     * @param byStatus
     *        Returns only restore jobs associated with the specified job status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RestoreJobStatus
     */

    public ListRestoreJobsByProtectedResourceRequest withByStatus(RestoreJobStatus byStatus) {
        this.byStatus = byStatus.toString();
        return this;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created after the specified date.
     * </p>
     * 
     * @param byRecoveryPointCreationDateAfter
     *        Returns only restore jobs of recovery points that were created after the specified date.
     */

    public void setByRecoveryPointCreationDateAfter(java.util.Date byRecoveryPointCreationDateAfter) {
        this.byRecoveryPointCreationDateAfter = byRecoveryPointCreationDateAfter;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created after the specified date.
     * </p>
     * 
     * @return Returns only restore jobs of recovery points that were created after the specified date.
     */

    public java.util.Date getByRecoveryPointCreationDateAfter() {
        return this.byRecoveryPointCreationDateAfter;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created after the specified date.
     * </p>
     * 
     * @param byRecoveryPointCreationDateAfter
     *        Returns only restore jobs of recovery points that were created after the specified date.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRestoreJobsByProtectedResourceRequest withByRecoveryPointCreationDateAfter(java.util.Date byRecoveryPointCreationDateAfter) {
        setByRecoveryPointCreationDateAfter(byRecoveryPointCreationDateAfter);
        return this;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created before the specified date.
     * </p>
     * 
     * @param byRecoveryPointCreationDateBefore
     *        Returns only restore jobs of recovery points that were created before the specified date.
     */

    public void setByRecoveryPointCreationDateBefore(java.util.Date byRecoveryPointCreationDateBefore) {
        this.byRecoveryPointCreationDateBefore = byRecoveryPointCreationDateBefore;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created before the specified date.
     * </p>
     * 
     * @return Returns only restore jobs of recovery points that were created before the specified date.
     */

    public java.util.Date getByRecoveryPointCreationDateBefore() {
        return this.byRecoveryPointCreationDateBefore;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created before the specified date.
     * </p>
     * 
     * @param byRecoveryPointCreationDateBefore
     *        Returns only restore jobs of recovery points that were created before the specified date.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRestoreJobsByProtectedResourceRequest withByRecoveryPointCreationDateBefore(java.util.Date byRecoveryPointCreationDateBefore) {
        setByRecoveryPointCreationDateBefore(byRecoveryPointCreationDateBefore);
        return this;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request ismade to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @param nextToken
     *        The next item following a partial list of returned items. For example, if a request ismade to return
     *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *        list starting at the location pointed to by the next token.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request ismade to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request ismade to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request ismade to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @param nextToken
     *        The next item following a partial list of returned items. For example, if a request ismade to return
     *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *        list starting at the location pointed to by the next token.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRestoreJobsByProtectedResourceRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of items to be returned.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of items to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRestoreJobsByProtectedResourceRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getByStatus() != null)
            sb.append("ByStatus: ").append(getByStatus()).append(",");
        if (getByRecoveryPointCreationDateAfter() != null)
            sb.append("ByRecoveryPointCreationDateAfter: ").append(getByRecoveryPointCreationDateAfter()).append(",");
        if (getByRecoveryPointCreationDateBefore() != null)
            sb.append("ByRecoveryPointCreationDateBefore: ").append(getByRecoveryPointCreationDateBefore()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListRestoreJobsByProtectedResourceRequest == false)
            return false;
        ListRestoreJobsByProtectedResourceRequest other = (ListRestoreJobsByProtectedResourceRequest) obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getByStatus() == null ^ this.getByStatus() == null)
            return false;
        if (other.getByStatus() != null && other.getByStatus().equals(this.getByStatus()) == false)
            return false;
        if (other.getByRecoveryPointCreationDateAfter() == null ^ this.getByRecoveryPointCreationDateAfter() == null)
            return false;
        if (other.getByRecoveryPointCreationDateAfter() != null
                && other.getByRecoveryPointCreationDateAfter().equals(this.getByRecoveryPointCreationDateAfter()) == false)
            return false;
        if (other.getByRecoveryPointCreationDateBefore() == null ^ this.getByRecoveryPointCreationDateBefore() == null)
            return false;
        if (other.getByRecoveryPointCreationDateBefore() != null
                && other.getByRecoveryPointCreationDateBefore().equals(this.getByRecoveryPointCreationDateBefore()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getByStatus() == null) ? 0 : getByStatus().hashCode());
        hashCode = prime * hashCode + ((getByRecoveryPointCreationDateAfter() == null) ? 0 : getByRecoveryPointCreationDateAfter().hashCode());
        hashCode = prime * hashCode + ((getByRecoveryPointCreationDateBefore() == null) ? 0 : getByRecoveryPointCreationDateBefore().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListRestoreJobsByProtectedResourceRequest clone() {
        return (ListRestoreJobsByProtectedResourceRequest) super.clone();
    }

}
