/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.transform.ClassifierEvaluationMetricsMarshaller;
import java.io.Serializable;

public class ClassifierEvaluationMetrics
implements Serializable,
Cloneable,
StructuredPojo {
    private Double accuracy;
    private Double precision;
    private Double recall;
    private Double f1Score;

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public ClassifierEvaluationMetrics withAccuracy(Double accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public ClassifierEvaluationMetrics withPrecision(Double precision) {
        this.setPrecision(precision);
        return this;
    }

    public void setRecall(Double recall) {
        this.recall = recall;
    }

    public Double getRecall() {
        return this.recall;
    }

    public ClassifierEvaluationMetrics withRecall(Double recall) {
        this.setRecall(recall);
        return this;
    }

    public void setF1Score(Double f1Score) {
        this.f1Score = f1Score;
    }

    public Double getF1Score() {
        return this.f1Score;
    }

    public ClassifierEvaluationMetrics withF1Score(Double f1Score) {
        this.setF1Score(f1Score);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccuracy() != null) {
            sb.append("Accuracy: ").append(this.getAccuracy()).append(",");
        }
        if (this.getPrecision() != null) {
            sb.append("Precision: ").append(this.getPrecision()).append(",");
        }
        if (this.getRecall() != null) {
            sb.append("Recall: ").append(this.getRecall()).append(",");
        }
        if (this.getF1Score() != null) {
            sb.append("F1Score: ").append(this.getF1Score());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierEvaluationMetrics)) {
            return false;
        }
        ClassifierEvaluationMetrics other = (ClassifierEvaluationMetrics)obj;
        if (other.getAccuracy() == null ^ this.getAccuracy() == null) {
            return false;
        }
        if (other.getAccuracy() != null && !other.getAccuracy().equals(this.getAccuracy())) {
            return false;
        }
        if (other.getPrecision() == null ^ this.getPrecision() == null) {
            return false;
        }
        if (other.getPrecision() != null && !other.getPrecision().equals(this.getPrecision())) {
            return false;
        }
        if (other.getRecall() == null ^ this.getRecall() == null) {
            return false;
        }
        if (other.getRecall() != null && !other.getRecall().equals(this.getRecall())) {
            return false;
        }
        if (other.getF1Score() == null ^ this.getF1Score() == null) {
            return false;
        }
        return other.getF1Score() == null || other.getF1Score().equals(this.getF1Score());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccuracy() == null ? 0 : this.getAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getPrecision() == null ? 0 : this.getPrecision().hashCode());
        hashCode = 31 * hashCode + (this.getRecall() == null ? 0 : this.getRecall().hashCode());
        hashCode = 31 * hashCode + (this.getF1Score() == null ? 0 : this.getF1Score().hashCode());
        return hashCode;
    }

    public ClassifierEvaluationMetrics clone() {
        try {
            return (ClassifierEvaluationMetrics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClassifierEvaluationMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

