/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationSubnetGroupRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateReplicationSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateReplicationSubnetGroupRequest>, CreateReplicationSubnetGroupRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateReplicationSubnetGroupRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateReplicationSubnetGroupRequest> marshall(CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) {
        if (createReplicationSubnetGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationSubnetGroupRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateReplicationSubnetGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            List<String> subnetIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createReplicationSubnetGroupRequest.getReplicationSubnetGroupIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroupIdentifier").writeValue(createReplicationSubnetGroupRequest.getReplicationSubnetGroupIdentifier());
            }
            if (createReplicationSubnetGroupRequest.getReplicationSubnetGroupDescription() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroupDescription").writeValue(createReplicationSubnetGroupRequest.getReplicationSubnetGroupDescription());
            }
            if ((subnetIdsList = createReplicationSubnetGroupRequest.getSubnetIds()) != null) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((tagsList = createReplicationSubnetGroupRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

