/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.groundstation.AWSGroundStation;
import com.amazonaws.services.groundstation.AWSGroundStationClientBuilder;
import com.amazonaws.services.groundstation.model.AWSGroundStationException;
import com.amazonaws.services.groundstation.model.CancelContactRequest;
import com.amazonaws.services.groundstation.model.CancelContactResult;
import com.amazonaws.services.groundstation.model.CreateConfigRequest;
import com.amazonaws.services.groundstation.model.CreateConfigResult;
import com.amazonaws.services.groundstation.model.CreateDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.CreateDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.CreateMissionProfileRequest;
import com.amazonaws.services.groundstation.model.CreateMissionProfileResult;
import com.amazonaws.services.groundstation.model.DeleteConfigRequest;
import com.amazonaws.services.groundstation.model.DeleteConfigResult;
import com.amazonaws.services.groundstation.model.DeleteDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.DeleteDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.DeleteMissionProfileRequest;
import com.amazonaws.services.groundstation.model.DeleteMissionProfileResult;
import com.amazonaws.services.groundstation.model.DescribeContactRequest;
import com.amazonaws.services.groundstation.model.DescribeContactResult;
import com.amazonaws.services.groundstation.model.GetConfigRequest;
import com.amazonaws.services.groundstation.model.GetConfigResult;
import com.amazonaws.services.groundstation.model.GetDataflowEndpointGroupRequest;
import com.amazonaws.services.groundstation.model.GetDataflowEndpointGroupResult;
import com.amazonaws.services.groundstation.model.GetMinuteUsageRequest;
import com.amazonaws.services.groundstation.model.GetMinuteUsageResult;
import com.amazonaws.services.groundstation.model.GetMissionProfileRequest;
import com.amazonaws.services.groundstation.model.GetMissionProfileResult;
import com.amazonaws.services.groundstation.model.GetSatelliteRequest;
import com.amazonaws.services.groundstation.model.GetSatelliteResult;
import com.amazonaws.services.groundstation.model.ListConfigsRequest;
import com.amazonaws.services.groundstation.model.ListConfigsResult;
import com.amazonaws.services.groundstation.model.ListContactsRequest;
import com.amazonaws.services.groundstation.model.ListContactsResult;
import com.amazonaws.services.groundstation.model.ListDataflowEndpointGroupsRequest;
import com.amazonaws.services.groundstation.model.ListDataflowEndpointGroupsResult;
import com.amazonaws.services.groundstation.model.ListGroundStationsRequest;
import com.amazonaws.services.groundstation.model.ListGroundStationsResult;
import com.amazonaws.services.groundstation.model.ListMissionProfilesRequest;
import com.amazonaws.services.groundstation.model.ListMissionProfilesResult;
import com.amazonaws.services.groundstation.model.ListSatellitesRequest;
import com.amazonaws.services.groundstation.model.ListSatellitesResult;
import com.amazonaws.services.groundstation.model.ListTagsForResourceRequest;
import com.amazonaws.services.groundstation.model.ListTagsForResourceResult;
import com.amazonaws.services.groundstation.model.ReserveContactRequest;
import com.amazonaws.services.groundstation.model.ReserveContactResult;
import com.amazonaws.services.groundstation.model.TagResourceRequest;
import com.amazonaws.services.groundstation.model.TagResourceResult;
import com.amazonaws.services.groundstation.model.UntagResourceRequest;
import com.amazonaws.services.groundstation.model.UntagResourceResult;
import com.amazonaws.services.groundstation.model.UpdateConfigRequest;
import com.amazonaws.services.groundstation.model.UpdateConfigResult;
import com.amazonaws.services.groundstation.model.UpdateMissionProfileRequest;
import com.amazonaws.services.groundstation.model.UpdateMissionProfileResult;
import com.amazonaws.services.groundstation.model.transform.CancelContactRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.CancelContactResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateConfigRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateConfigResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateDataflowEndpointGroupRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateDataflowEndpointGroupResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateMissionProfileRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.CreateMissionProfileResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteConfigRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteConfigResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteDataflowEndpointGroupRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteDataflowEndpointGroupResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteMissionProfileRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.DeleteMissionProfileResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.DependencyExceptionUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.DescribeContactRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.DescribeContactResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.GetConfigRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.GetConfigResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.GetDataflowEndpointGroupRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.GetDataflowEndpointGroupResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.GetMinuteUsageRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.GetMinuteUsageResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.GetMissionProfileRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.GetMissionProfileResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.GetSatelliteRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.GetSatelliteResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListConfigsRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListConfigsResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListContactsRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListContactsResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListDataflowEndpointGroupsRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListDataflowEndpointGroupsResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListGroundStationsRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListGroundStationsResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListMissionProfilesRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListMissionProfilesResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListSatellitesRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListSatellitesResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ReserveContactRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.ReserveContactResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ResourceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.UpdateConfigRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.UpdateConfigResultJsonUnmarshaller;
import com.amazonaws.services.groundstation.model.transform.UpdateMissionProfileRequestProtocolMarshaller;
import com.amazonaws.services.groundstation.model.transform.UpdateMissionProfileResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSGroundStationClient
extends AmazonWebServiceClient
implements AWSGroundStation {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSGroundStation.class);
    private static final String DEFAULT_SIGNING_NAME = "groundstation";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DependencyExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSGroundStationException.class));

    public static AWSGroundStationClientBuilder builder() {
        return AWSGroundStationClientBuilder.standard();
    }

    AWSGroundStationClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSGroundStationClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("groundstation.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/groundstation/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/groundstation/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelContactResult cancelContact(CancelContactRequest request) {
        request = (CancelContactRequest)this.beforeClientExecution(request);
        return this.executeCancelContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelContactResult executeCancelContact(CancelContactRequest cancelContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelContactRequestProtocolMarshaller(protocolFactory).marshall((CancelContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelContactResult cancelContactResult = (CancelContactResult)response.getAwsResponse();
            return cancelContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateConfigResult createConfig(CreateConfigRequest request) {
        request = (CreateConfigRequest)this.beforeClientExecution(request);
        return this.executeCreateConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateConfigResult executeCreateConfig(CreateConfigRequest createConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConfigRequestProtocolMarshaller(protocolFactory).marshall((CreateConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)createConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConfigResult createConfigResult = (CreateConfigResult)response.getAwsResponse();
            return createConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataflowEndpointGroupResult createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest request) {
        request = (CreateDataflowEndpointGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateDataflowEndpointGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataflowEndpointGroupResult executeCreateDataflowEndpointGroup(CreateDataflowEndpointGroupRequest createDataflowEndpointGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataflowEndpointGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataflowEndpointGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataflowEndpointGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateDataflowEndpointGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataflowEndpointGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataflowEndpointGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataflowEndpointGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataflowEndpointGroupResult createDataflowEndpointGroupResult = (CreateDataflowEndpointGroupResult)response.getAwsResponse();
            return createDataflowEndpointGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMissionProfileResult createMissionProfile(CreateMissionProfileRequest request) {
        request = (CreateMissionProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateMissionProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMissionProfileResult executeCreateMissionProfile(CreateMissionProfileRequest createMissionProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMissionProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMissionProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMissionProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateMissionProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMissionProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMissionProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMissionProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMissionProfileResult createMissionProfileResult = (CreateMissionProfileResult)response.getAwsResponse();
            return createMissionProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteConfigResult deleteConfig(DeleteConfigRequest request) {
        request = (DeleteConfigRequest)this.beforeClientExecution(request);
        return this.executeDeleteConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteConfigResult executeDeleteConfig(DeleteConfigRequest deleteConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConfigRequestProtocolMarshaller(protocolFactory).marshall((DeleteConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConfigResult deleteConfigResult = (DeleteConfigResult)response.getAwsResponse();
            return deleteConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataflowEndpointGroupResult deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest request) {
        request = (DeleteDataflowEndpointGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataflowEndpointGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataflowEndpointGroupResult executeDeleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest deleteDataflowEndpointGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataflowEndpointGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataflowEndpointGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataflowEndpointGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataflowEndpointGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataflowEndpointGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataflowEndpointGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataflowEndpointGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataflowEndpointGroupResult deleteDataflowEndpointGroupResult = (DeleteDataflowEndpointGroupResult)response.getAwsResponse();
            return deleteDataflowEndpointGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMissionProfileResult deleteMissionProfile(DeleteMissionProfileRequest request) {
        request = (DeleteMissionProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteMissionProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMissionProfileResult executeDeleteMissionProfile(DeleteMissionProfileRequest deleteMissionProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMissionProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMissionProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMissionProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteMissionProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMissionProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMissionProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMissionProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMissionProfileResult deleteMissionProfileResult = (DeleteMissionProfileResult)response.getAwsResponse();
            return deleteMissionProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeContactResult describeContact(DescribeContactRequest request) {
        request = (DescribeContactRequest)this.beforeClientExecution(request);
        return this.executeDescribeContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeContactResult executeDescribeContact(DescribeContactRequest describeContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeContactRequestProtocolMarshaller(protocolFactory).marshall((DescribeContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeContactResult describeContactResult = (DescribeContactResult)response.getAwsResponse();
            return describeContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetConfigResult getConfig(GetConfigRequest request) {
        request = (GetConfigRequest)this.beforeClientExecution(request);
        return this.executeGetConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConfigResult executeGetConfig(GetConfigRequest getConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConfigRequestProtocolMarshaller(protocolFactory).marshall((GetConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConfigResult getConfigResult = (GetConfigResult)response.getAwsResponse();
            return getConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataflowEndpointGroupResult getDataflowEndpointGroup(GetDataflowEndpointGroupRequest request) {
        request = (GetDataflowEndpointGroupRequest)this.beforeClientExecution(request);
        return this.executeGetDataflowEndpointGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataflowEndpointGroupResult executeGetDataflowEndpointGroup(GetDataflowEndpointGroupRequest getDataflowEndpointGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataflowEndpointGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataflowEndpointGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataflowEndpointGroupRequestProtocolMarshaller(protocolFactory).marshall((GetDataflowEndpointGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataflowEndpointGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataflowEndpointGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataflowEndpointGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataflowEndpointGroupResult getDataflowEndpointGroupResult = (GetDataflowEndpointGroupResult)response.getAwsResponse();
            return getDataflowEndpointGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMinuteUsageResult getMinuteUsage(GetMinuteUsageRequest request) {
        request = (GetMinuteUsageRequest)this.beforeClientExecution(request);
        return this.executeGetMinuteUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMinuteUsageResult executeGetMinuteUsage(GetMinuteUsageRequest getMinuteUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMinuteUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMinuteUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMinuteUsageRequestProtocolMarshaller(protocolFactory).marshall((GetMinuteUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMinuteUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMinuteUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMinuteUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMinuteUsageResult getMinuteUsageResult = (GetMinuteUsageResult)response.getAwsResponse();
            return getMinuteUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMissionProfileResult getMissionProfile(GetMissionProfileRequest request) {
        request = (GetMissionProfileRequest)this.beforeClientExecution(request);
        return this.executeGetMissionProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMissionProfileResult executeGetMissionProfile(GetMissionProfileRequest getMissionProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMissionProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMissionProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMissionProfileRequestProtocolMarshaller(protocolFactory).marshall((GetMissionProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMissionProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMissionProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMissionProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMissionProfileResult getMissionProfileResult = (GetMissionProfileResult)response.getAwsResponse();
            return getMissionProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSatelliteResult getSatellite(GetSatelliteRequest request) {
        request = (GetSatelliteRequest)this.beforeClientExecution(request);
        return this.executeGetSatellite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSatelliteResult executeGetSatellite(GetSatelliteRequest getSatelliteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSatelliteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSatelliteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSatelliteRequestProtocolMarshaller(protocolFactory).marshall((GetSatelliteRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSatelliteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSatellite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSatelliteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSatelliteResult getSatelliteResult = (GetSatelliteResult)response.getAwsResponse();
            return getSatelliteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListConfigsResult listConfigs(ListConfigsRequest request) {
        request = (ListConfigsRequest)this.beforeClientExecution(request);
        return this.executeListConfigs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListConfigsResult executeListConfigs(ListConfigsRequest listConfigsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listConfigsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListConfigsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListConfigsRequestProtocolMarshaller(protocolFactory).marshall((ListConfigsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listConfigsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListConfigs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConfigsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListConfigsResult listConfigsResult = (ListConfigsResult)response.getAwsResponse();
            return listConfigsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContactsResult listContacts(ListContactsRequest request) {
        request = (ListContactsRequest)this.beforeClientExecution(request);
        return this.executeListContacts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContactsResult executeListContacts(ListContactsRequest listContactsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContactsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContactsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContactsRequestProtocolMarshaller(protocolFactory).marshall((ListContactsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContactsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContacts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContactsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContactsResult listContactsResult = (ListContactsResult)response.getAwsResponse();
            return listContactsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataflowEndpointGroupsResult listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest request) {
        request = (ListDataflowEndpointGroupsRequest)this.beforeClientExecution(request);
        return this.executeListDataflowEndpointGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataflowEndpointGroupsResult executeListDataflowEndpointGroups(ListDataflowEndpointGroupsRequest listDataflowEndpointGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataflowEndpointGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataflowEndpointGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataflowEndpointGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListDataflowEndpointGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataflowEndpointGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataflowEndpointGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataflowEndpointGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataflowEndpointGroupsResult listDataflowEndpointGroupsResult = (ListDataflowEndpointGroupsResult)response.getAwsResponse();
            return listDataflowEndpointGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGroundStationsResult listGroundStations(ListGroundStationsRequest request) {
        request = (ListGroundStationsRequest)this.beforeClientExecution(request);
        return this.executeListGroundStations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGroundStationsResult executeListGroundStations(ListGroundStationsRequest listGroundStationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGroundStationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGroundStationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGroundStationsRequestProtocolMarshaller(protocolFactory).marshall((ListGroundStationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGroundStationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGroundStations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroundStationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGroundStationsResult listGroundStationsResult = (ListGroundStationsResult)response.getAwsResponse();
            return listGroundStationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMissionProfilesResult listMissionProfiles(ListMissionProfilesRequest request) {
        request = (ListMissionProfilesRequest)this.beforeClientExecution(request);
        return this.executeListMissionProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMissionProfilesResult executeListMissionProfiles(ListMissionProfilesRequest listMissionProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMissionProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMissionProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMissionProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListMissionProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMissionProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMissionProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMissionProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMissionProfilesResult listMissionProfilesResult = (ListMissionProfilesResult)response.getAwsResponse();
            return listMissionProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSatellitesResult listSatellites(ListSatellitesRequest request) {
        request = (ListSatellitesRequest)this.beforeClientExecution(request);
        return this.executeListSatellites(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSatellitesResult executeListSatellites(ListSatellitesRequest listSatellitesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSatellitesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSatellitesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSatellitesRequestProtocolMarshaller(protocolFactory).marshall((ListSatellitesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSatellitesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSatellites");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSatellitesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSatellitesResult listSatellitesResult = (ListSatellitesResult)response.getAwsResponse();
            return listSatellitesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReserveContactResult reserveContact(ReserveContactRequest request) {
        request = (ReserveContactRequest)this.beforeClientExecution(request);
        return this.executeReserveContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReserveContactResult executeReserveContact(ReserveContactRequest reserveContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reserveContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReserveContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReserveContactRequestProtocolMarshaller(protocolFactory).marshall((ReserveContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)reserveContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReserveContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReserveContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ReserveContactResult reserveContactResult = (ReserveContactResult)response.getAwsResponse();
            return reserveContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateConfigResult updateConfig(UpdateConfigRequest request) {
        request = (UpdateConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateConfigResult executeUpdateConfig(UpdateConfigRequest updateConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConfigResult updateConfigResult = (UpdateConfigResult)response.getAwsResponse();
            return updateConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMissionProfileResult updateMissionProfile(UpdateMissionProfileRequest request) {
        request = (UpdateMissionProfileRequest)this.beforeClientExecution(request);
        return this.executeUpdateMissionProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMissionProfileResult executeUpdateMissionProfile(UpdateMissionProfileRequest updateMissionProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMissionProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMissionProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMissionProfileRequestProtocolMarshaller(protocolFactory).marshall((UpdateMissionProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMissionProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GroundStation");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMissionProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMissionProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMissionProfileResult updateMissionProfileResult = (UpdateMissionProfileResult)response.getAwsResponse();
            return updateMissionProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

