/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.SlotShape;
import com.amazonaws.services.lexmodelsv2.model.SlotValue;
import com.amazonaws.services.lexmodelsv2.model.transform.SlotValueOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SlotValueOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String shape;
    private SlotValue value;
    private List<SlotValueOverride> values;

    public void setShape(String shape) {
        this.shape = shape;
    }

    public String getShape() {
        return this.shape;
    }

    public SlotValueOverride withShape(String shape) {
        this.setShape(shape);
        return this;
    }

    public SlotValueOverride withShape(SlotShape shape) {
        this.shape = shape.toString();
        return this;
    }

    public void setValue(SlotValue value) {
        this.value = value;
    }

    public SlotValue getValue() {
        return this.value;
    }

    public SlotValueOverride withValue(SlotValue value) {
        this.setValue(value);
        return this;
    }

    public List<SlotValueOverride> getValues() {
        return this.values;
    }

    public void setValues(Collection<SlotValueOverride> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<SlotValueOverride>(values);
    }

    public SlotValueOverride withValues(SlotValueOverride ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<SlotValueOverride>(values.length));
        }
        for (SlotValueOverride ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public SlotValueOverride withValues(Collection<SlotValueOverride> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getShape() != null) {
            sb.append("Shape: ").append(this.getShape()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueOverride)) {
            return false;
        }
        SlotValueOverride other = (SlotValueOverride)obj;
        if (other.getShape() == null ^ this.getShape() == null) {
            return false;
        }
        if (other.getShape() != null && !other.getShape().equals(this.getShape())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getShape() == null ? 0 : this.getShape().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public SlotValueOverride clone() {
        try {
            return (SlotValueOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotValueOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

