/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.BucketPublicAccess;
import com.amazonaws.services.macie2.model.KeyValuePair;
import com.amazonaws.services.macie2.model.S3BucketOwner;
import com.amazonaws.services.macie2.model.ServerSideEncryption;
import com.amazonaws.services.macie2.model.transform.S3BucketMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class S3Bucket
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdAt;
    private ServerSideEncryption defaultServerSideEncryption;
    private String name;
    private S3BucketOwner owner;
    private BucketPublicAccess publicAccess;
    private List<KeyValuePair> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public S3Bucket withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public S3Bucket withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setDefaultServerSideEncryption(ServerSideEncryption defaultServerSideEncryption) {
        this.defaultServerSideEncryption = defaultServerSideEncryption;
    }

    public ServerSideEncryption getDefaultServerSideEncryption() {
        return this.defaultServerSideEncryption;
    }

    public S3Bucket withDefaultServerSideEncryption(ServerSideEncryption defaultServerSideEncryption) {
        this.setDefaultServerSideEncryption(defaultServerSideEncryption);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3Bucket withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwner(S3BucketOwner owner) {
        this.owner = owner;
    }

    public S3BucketOwner getOwner() {
        return this.owner;
    }

    public S3Bucket withOwner(S3BucketOwner owner) {
        this.setOwner(owner);
        return this;
    }

    public void setPublicAccess(BucketPublicAccess publicAccess) {
        this.publicAccess = publicAccess;
    }

    public BucketPublicAccess getPublicAccess() {
        return this.publicAccess;
    }

    public S3Bucket withPublicAccess(BucketPublicAccess publicAccess) {
        this.setPublicAccess(publicAccess);
        return this;
    }

    public List<KeyValuePair> getTags() {
        return this.tags;
    }

    public void setTags(Collection<KeyValuePair> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<KeyValuePair>(tags);
    }

    public S3Bucket withTags(KeyValuePair ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<KeyValuePair>(tags.length));
        }
        for (KeyValuePair ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public S3Bucket withTags(Collection<KeyValuePair> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getDefaultServerSideEncryption() != null) {
            sb.append("DefaultServerSideEncryption: ").append(this.getDefaultServerSideEncryption()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getPublicAccess() != null) {
            sb.append("PublicAccess: ").append(this.getPublicAccess()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getDefaultServerSideEncryption() == null ^ this.getDefaultServerSideEncryption() == null) {
            return false;
        }
        if (other.getDefaultServerSideEncryption() != null && !other.getDefaultServerSideEncryption().equals(this.getDefaultServerSideEncryption())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getPublicAccess() == null ^ this.getPublicAccess() == null) {
            return false;
        }
        if (other.getPublicAccess() != null && !other.getPublicAccess().equals(this.getPublicAccess())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultServerSideEncryption() == null ? 0 : this.getDefaultServerSideEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPublicAccess() == null ? 0 : this.getPublicAccess().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public S3Bucket clone() {
        try {
            return (S3Bucket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3BucketMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

