/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.Member;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class MemberMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("email").build();
    private static final MarshallingInfo<Date> INVITEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("invitedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> MASTERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("masterAccountId").build();
    private static final MarshallingInfo<String> RELATIONSHIPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationshipStatus").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("iso8601").build();
    private static final MemberMarshaller instance = new MemberMarshaller();

    public static MemberMarshaller getInstance() {
        return instance;
    }

    public void marshall(Member member, ProtocolMarshaller protocolMarshaller) {
        if (member == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)member.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)member.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)member.getEmail(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)member.getInvitedAt(), INVITEDAT_BINDING);
            protocolMarshaller.marshall((Object)member.getMasterAccountId(), MASTERACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)member.getRelationshipStatus(), RELATIONSHIPSTATUS_BINDING);
            protocolMarshaller.marshall(member.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)member.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

