/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.macie2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TestCustomDataIdentifierResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The number of occurrences of sample text that matched the criteria specified by the custom data identifier.
     * </p>
     */
    private Integer matchCount;

    /**
     * <p>
     * The number of occurrences of sample text that matched the criteria specified by the custom data identifier.
     * </p>
     * 
     * @param matchCount
     *        The number of occurrences of sample text that matched the criteria specified by the custom data
     *        identifier.
     */

    public void setMatchCount(Integer matchCount) {
        this.matchCount = matchCount;
    }

    /**
     * <p>
     * The number of occurrences of sample text that matched the criteria specified by the custom data identifier.
     * </p>
     * 
     * @return The number of occurrences of sample text that matched the criteria specified by the custom data
     *         identifier.
     */

    public Integer getMatchCount() {
        return this.matchCount;
    }

    /**
     * <p>
     * The number of occurrences of sample text that matched the criteria specified by the custom data identifier.
     * </p>
     * 
     * @param matchCount
     *        The number of occurrences of sample text that matched the criteria specified by the custom data
     *        identifier.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TestCustomDataIdentifierResult withMatchCount(Integer matchCount) {
        setMatchCount(matchCount);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMatchCount() != null)
            sb.append("MatchCount: ").append(getMatchCount());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TestCustomDataIdentifierResult == false)
            return false;
        TestCustomDataIdentifierResult other = (TestCustomDataIdentifierResult) obj;
        if (other.getMatchCount() == null ^ this.getMatchCount() == null)
            return false;
        if (other.getMatchCount() != null && other.getMatchCount().equals(this.getMatchCount()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMatchCount() == null) ? 0 : getMatchCount().hashCode());
        return hashCode;
    }

    @Override
    public TestCustomDataIdentifierResult clone() {
        try {
            return (TestCustomDataIdentifierResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
