/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.S3Object;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class S3ObjectMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketArn").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eTag").build();
    private static final MarshallingInfo<String> EXTENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extension").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModified").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<Boolean> PUBLICACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicAccess").build();
    private static final MarshallingInfo<StructuredPojo> SERVERSIDEENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverSideEncryption").build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("size").build();
    private static final MarshallingInfo<String> STORAGECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageClass").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionId").build();
    private static final S3ObjectMarshaller instance = new S3ObjectMarshaller();

    public static S3ObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Object s3Object, ProtocolMarshaller protocolMarshaller) {
        if (s3Object == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Object.getBucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getETag(), ETAG_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getExtension(), EXTENSION_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getPublicAccess(), PUBLICACCESS_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getServerSideEncryption(), SERVERSIDEENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getStorageClass(), STORAGECLASS_BINDING);
            protocolMarshaller.marshall(s3Object.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)s3Object.getVersionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

