/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pricing;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pricing.AWSPricingAsync;
import com.amazonaws.services.pricing.AWSPricingAsyncClientBuilder;
import com.amazonaws.services.pricing.AWSPricingClient;
import com.amazonaws.services.pricing.model.DescribeServicesRequest;
import com.amazonaws.services.pricing.model.DescribeServicesResult;
import com.amazonaws.services.pricing.model.GetAttributeValuesRequest;
import com.amazonaws.services.pricing.model.GetAttributeValuesResult;
import com.amazonaws.services.pricing.model.GetPriceListFileUrlRequest;
import com.amazonaws.services.pricing.model.GetPriceListFileUrlResult;
import com.amazonaws.services.pricing.model.GetProductsRequest;
import com.amazonaws.services.pricing.model.GetProductsResult;
import com.amazonaws.services.pricing.model.ListPriceListsRequest;
import com.amazonaws.services.pricing.model.ListPriceListsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPricingAsyncClient
extends AWSPricingClient
implements AWSPricingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPricingAsyncClientBuilder asyncBuilder() {
        return AWSPricingAsyncClientBuilder.standard();
    }

    AWSPricingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPricingAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request) {
        return this.describeServicesAsync(request, null);
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        final DescribeServicesRequest finalRequest = (DescribeServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeDescribeServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAttributeValuesResult> getAttributeValuesAsync(GetAttributeValuesRequest request) {
        return this.getAttributeValuesAsync(request, null);
    }

    @Override
    public Future<GetAttributeValuesResult> getAttributeValuesAsync(GetAttributeValuesRequest request, final AsyncHandler<GetAttributeValuesRequest, GetAttributeValuesResult> asyncHandler) {
        final GetAttributeValuesRequest finalRequest = (GetAttributeValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAttributeValuesResult>(){

            @Override
            public GetAttributeValuesResult call() throws Exception {
                GetAttributeValuesResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeGetAttributeValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPriceListFileUrlResult> getPriceListFileUrlAsync(GetPriceListFileUrlRequest request) {
        return this.getPriceListFileUrlAsync(request, null);
    }

    @Override
    public Future<GetPriceListFileUrlResult> getPriceListFileUrlAsync(GetPriceListFileUrlRequest request, final AsyncHandler<GetPriceListFileUrlRequest, GetPriceListFileUrlResult> asyncHandler) {
        final GetPriceListFileUrlRequest finalRequest = (GetPriceListFileUrlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPriceListFileUrlResult>(){

            @Override
            public GetPriceListFileUrlResult call() throws Exception {
                GetPriceListFileUrlResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeGetPriceListFileUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProductsResult> getProductsAsync(GetProductsRequest request) {
        return this.getProductsAsync(request, null);
    }

    @Override
    public Future<GetProductsResult> getProductsAsync(GetProductsRequest request, final AsyncHandler<GetProductsRequest, GetProductsResult> asyncHandler) {
        final GetProductsRequest finalRequest = (GetProductsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProductsResult>(){

            @Override
            public GetProductsResult call() throws Exception {
                GetProductsResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeGetProducts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPriceListsResult> listPriceListsAsync(ListPriceListsRequest request) {
        return this.listPriceListsAsync(request, null);
    }

    @Override
    public Future<ListPriceListsResult> listPriceListsAsync(ListPriceListsRequest request, final AsyncHandler<ListPriceListsRequest, ListPriceListsResult> asyncHandler) {
        final ListPriceListsRequest finalRequest = (ListPriceListsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPriceListsResult>(){

            @Override
            public ListPriceListsResult call() throws Exception {
                ListPriceListsResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeListPriceLists(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

