/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CopyOptionGroupRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyOptionGroupRequestMarshaller
implements Marshaller<Request<CopyOptionGroupRequest>, CopyOptionGroupRequest> {
    public Request<CopyOptionGroupRequest> marshall(CopyOptionGroupRequest copyOptionGroupRequest) {
        if (copyOptionGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyOptionGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CopyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyOptionGroupRequest.getSourceOptionGroupIdentifier() != null) {
            request.addParameter("SourceOptionGroupIdentifier", StringUtils.fromString((String)copyOptionGroupRequest.getSourceOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.getTargetOptionGroupIdentifier() != null) {
            request.addParameter("TargetOptionGroupIdentifier", StringUtils.fromString((String)copyOptionGroupRequest.getTargetOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.getTargetOptionGroupDescription() != null) {
            request.addParameter("TargetOptionGroupDescription", StringUtils.fromString((String)copyOptionGroupRequest.getTargetOptionGroupDescription()));
        }
        if (!copyOptionGroupRequest.getTags().isEmpty() || !((SdkInternalList)copyOptionGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)copyOptionGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

