/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.codesamples.CodeSample;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesWriter {
    static final String ROOT_ELEMENT = "codeSamples";
    static final String SAMPLE_ELEMENT = "sample";
    static final String CONTENT_ELEMENT = "content";
    static final String ID_ATTRIBUTE = "id";
    static final String TITLE_ATTRIBUTE = "title";
    static final String DESC_ATTRIBUTE = "description";

    public static void writeSamples(List<CodeSample> samples, String outputDir) throws Exception {
        Map<String, Document> serviceDocMap = SamplesWriter.generateSampleDocuments(samples);
        new File(outputDir).mkdirs();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        for (Map.Entry<String, Document> entry : serviceDocMap.entrySet()) {
            DOMSource source = new DOMSource(entry.getValue());
            File outputFile = new File(String.format("%s/%s.xml", outputDir, entry.getKey()));
            StreamResult result = new StreamResult(outputFile);
            transformer.transform(source, result);
        }
    }

    static Map<String, Document> generateSampleDocuments(List<CodeSample> samples) throws Exception {
        HashMap<String, Document> serviceDocMap = new HashMap<String, Document>();
        for (CodeSample sample : samples) {
            String sampleServiceName = sample.getServiceName();
            if (!serviceDocMap.containsKey(sampleServiceName)) {
                serviceDocMap.put(sampleServiceName, SamplesWriter.createSampleDoc());
            }
            Document doc = (Document)serviceDocMap.get(sampleServiceName);
            SamplesWriter.appendSampleToDoc(sample, doc);
        }
        return serviceDocMap;
    }

    private static Document createSampleDoc() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement(ROOT_ELEMENT);
        doc.appendChild(rootElement);
        return doc;
    }

    private static void appendSampleToDoc(CodeSample sample, Document doc) {
        Element sampleElement = doc.createElement(SAMPLE_ELEMENT);
        sampleElement.setAttribute(DESC_ATTRIBUTE, sample.getDescription());
        sampleElement.setAttribute(TITLE_ATTRIBUTE, sample.getTitle());
        sampleElement.setAttribute(ID_ATTRIBUTE, sample.getId());
        Element codeElement = doc.createElement(CONTENT_ELEMENT);
        codeElement.appendChild(doc.createTextNode(sample.getFormattedCode()));
        sampleElement.appendChild(codeElement);
        Element rootElement = (Element)doc.getElementsByTagName(ROOT_ELEMENT).item(0);
        rootElement.appendChild(sampleElement);
    }
}

