/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.codesamples.CodeSample;
import com.amazonaws.codesamples.SamplesParser;
import com.amazonaws.codesamples.SamplesWriter;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="ExtractSamples")
public class SampleCodeExtractor
extends AbstractMojo {
    @Parameter(property="sampleSubDir")
    private String sampleSubDir;
    @Parameter(property="sourceExtension")
    private String sourceExtension;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private String projectSourceDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String projectOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.projectSourceDir == null || this.projectSourceDir.isEmpty()) {
            throw new MojoFailureException("Unable to determine project source dir!");
        }
        if (this.projectOutputDir == null || this.projectOutputDir.isEmpty()) {
            throw new MojoFailureException("Unable to determine project output dir!");
        }
        if (this.sampleSubDir == null || this.sampleSubDir.isEmpty()) {
            throw new MojoFailureException("Sample sub directory was not provided!");
        }
        File[] sourceFiles = new File(this.projectSourceDir).listFiles();
        String samplesOutputDir = this.projectOutputDir + this.sampleSubDir;
        try {
            List<CodeSample> samples = SamplesParser.getSamples(sourceFiles, this.sourceExtension);
            SamplesWriter.writeSamples(samples, samplesOutputDir);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to extract samples", (Throwable)e);
        }
    }
}

