/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamwrite.model.BatchLoadDataFormat;
import com.amazonaws.services.timestreamwrite.model.CsvConfiguration;
import com.amazonaws.services.timestreamwrite.model.DataSourceS3Configuration;
import com.amazonaws.services.timestreamwrite.model.transform.DataSourceConfigurationMarshaller;
import java.io.Serializable;

public class DataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private DataSourceS3Configuration dataSourceS3Configuration;
    private CsvConfiguration csvConfiguration;
    private String dataFormat;

    public void setDataSourceS3Configuration(DataSourceS3Configuration dataSourceS3Configuration) {
        this.dataSourceS3Configuration = dataSourceS3Configuration;
    }

    public DataSourceS3Configuration getDataSourceS3Configuration() {
        return this.dataSourceS3Configuration;
    }

    public DataSourceConfiguration withDataSourceS3Configuration(DataSourceS3Configuration dataSourceS3Configuration) {
        this.setDataSourceS3Configuration(dataSourceS3Configuration);
        return this;
    }

    public void setCsvConfiguration(CsvConfiguration csvConfiguration) {
        this.csvConfiguration = csvConfiguration;
    }

    public CsvConfiguration getCsvConfiguration() {
        return this.csvConfiguration;
    }

    public DataSourceConfiguration withCsvConfiguration(CsvConfiguration csvConfiguration) {
        this.setCsvConfiguration(csvConfiguration);
        return this;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public DataSourceConfiguration withDataFormat(String dataFormat) {
        this.setDataFormat(dataFormat);
        return this;
    }

    public DataSourceConfiguration withDataFormat(BatchLoadDataFormat dataFormat) {
        this.dataFormat = dataFormat.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceS3Configuration() != null) {
            sb.append("DataSourceS3Configuration: ").append(this.getDataSourceS3Configuration()).append(",");
        }
        if (this.getCsvConfiguration() != null) {
            sb.append("CsvConfiguration: ").append(this.getCsvConfiguration()).append(",");
        }
        if (this.getDataFormat() != null) {
            sb.append("DataFormat: ").append(this.getDataFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        if (other.getDataSourceS3Configuration() == null ^ this.getDataSourceS3Configuration() == null) {
            return false;
        }
        if (other.getDataSourceS3Configuration() != null && !other.getDataSourceS3Configuration().equals(this.getDataSourceS3Configuration())) {
            return false;
        }
        if (other.getCsvConfiguration() == null ^ this.getCsvConfiguration() == null) {
            return false;
        }
        if (other.getCsvConfiguration() != null && !other.getCsvConfiguration().equals(this.getCsvConfiguration())) {
            return false;
        }
        if (other.getDataFormat() == null ^ this.getDataFormat() == null) {
            return false;
        }
        return other.getDataFormat() == null || other.getDataFormat().equals(this.getDataFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceS3Configuration() == null ? 0 : this.getDataSourceS3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.getCsvConfiguration() == null ? 0 : this.getCsvConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDataFormat() == null ? 0 : this.getDataFormat().hashCode());
        return hashCode;
    }

    public DataSourceConfiguration clone() {
        try {
            return (DataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

