/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.SizeConstraintSetUpdate;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.transform.SizeConstraintSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateSizeConstraintSetRequestMarshaller
implements Marshaller<Request<UpdateSizeConstraintSetRequest>, UpdateSizeConstraintSetRequest> {
    public Request<UpdateSizeConstraintSetRequest> marshall(UpdateSizeConstraintSetRequest updateSizeConstraintSetRequest) {
        if (updateSizeConstraintSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSizeConstraintSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateSizeConstraintSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<SizeConstraintSetUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (updateSizeConstraintSetRequest.getSizeConstraintSetId() != null) {
                jsonGenerator.writeFieldName("SizeConstraintSetId").writeValue(updateSizeConstraintSetRequest.getSizeConstraintSetId());
            }
            if (updateSizeConstraintSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateSizeConstraintSetRequest.getChangeToken());
            }
            if ((updatesList = updateSizeConstraintSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (SizeConstraintSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    SizeConstraintSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

