/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.ActivatedRule;
import com.amazonaws.services.waf.model.WebACL;
import com.amazonaws.services.waf.model.transform.ActivatedRuleJsonMarshaller;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class WebACLJsonMarshaller {
    private static WebACLJsonMarshaller instance;

    public void marshall(WebACL webACL, StructuredJsonGenerator jsonGenerator) {
        if (webACL == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActivatedRule> rulesList;
            jsonGenerator.writeStartObject();
            if (webACL.getWebACLId() != null) {
                jsonGenerator.writeFieldName("WebACLId").writeValue(webACL.getWebACLId());
            }
            if (webACL.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(webACL.getName());
            }
            if (webACL.getMetricName() != null) {
                jsonGenerator.writeFieldName("MetricName").writeValue(webACL.getMetricName());
            }
            if (webACL.getDefaultAction() != null) {
                jsonGenerator.writeFieldName("DefaultAction");
                WafActionJsonMarshaller.getInstance().marshall(webACL.getDefaultAction(), jsonGenerator);
            }
            if ((rulesList = webACL.getRules()) != null) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartArray();
                for (ActivatedRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    ActivatedRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WebACLJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WebACLJsonMarshaller();
        }
        return instance;
    }
}

