/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.profiler;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

enum Arch {
    x64("x86_64", "amd64", "k8"),
    x86("x86", "i386", "i486", "i586", "i686"),
    arm("ARM", "aarch32"),
    arm64("arm64", "aarch64"),
    unknown(new String[0]);

    private final Set<String> identifiers;

    private Arch(String ... identifiers) {
        this.identifiers = new HashSet<String>(Arrays.asList(identifiers));
    }

    public static Arch of(String identifier) {
        for (Arch arch : EnumSet.allOf(Arch.class)) {
            if (!arch.identifiers.contains(identifier)) continue;
            return arch;
        }
        return unknown;
    }

    public static Arch current() {
        return Arch.of(System.getProperty("os.arch"));
    }
}

