/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.profiler;

import com.datadoghq.profiler.Arch;
import com.datadoghq.profiler.OperatingSystem;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;

public final class JavaProfiler {
    private static final String NATIVE_LIBS = "/META-INF/native-libs";
    private static final String LIBRARY_NAME = "libjavaProfiler." + (OperatingSystem.current() == OperatingSystem.macos ? "dylib" : "so");
    private static final Unsafe UNSAFE;
    private static JavaProfiler instance;
    private static final int CONTEXT_SIZE = 64;
    private static final int PAGE_SIZE = 1024;
    private static final int SPAN_OFFSET = 0;
    private static final int ROOT_SPAN_OFFSET = 8;
    private static final int CHECKSUM_OFFSET = 16;
    private static final int DYNAMIC_TAGS_OFFSET = 24;
    private static final ThreadLocal<Integer> TID;
    private ByteBuffer[] contextStorage;
    private long[] contextBaseOffsets;

    private JavaProfiler() {
    }

    public static JavaProfiler getInstance() throws IOException {
        return JavaProfiler.getInstance(null, null);
    }

    public static JavaProfiler getInstance(String scratchDir) throws IOException {
        return JavaProfiler.getInstance(null, scratchDir);
    }

    public static synchronized JavaProfiler getInstance(String libLocation, String scratchDir) throws IOException {
        if (instance != null) {
            return instance;
        }
        JavaProfiler profiler = new JavaProfiler();
        Path libraryPath = null;
        if (libLocation == null) {
            OperatingSystem os = OperatingSystem.current();
            String qualifier = os == OperatingSystem.linux && JavaProfiler.isMusl() ? "musl" : null;
            libraryPath = JavaProfiler.libraryFromClasspath(os, Arch.current(), qualifier, Paths.get(scratchDir != null ? scratchDir : System.getProperty("java.io.tmpdir"), new String[0]));
            libLocation = libraryPath.toString();
        }
        System.load(libLocation);
        profiler.initializeContextStorage();
        instance = profiler;
        return profiler;
    }

    private static Path libraryFromClasspath(OperatingSystem os, Arch arch, String qualifier, Path tempDir) throws IOException {
        String resourcePath = "/META-INF/native-libs/" + os.name().toLowerCase() + "-" + arch.name().toLowerCase() + (qualifier != null && !qualifier.isEmpty() ? "-" + qualifier : "") + "/" + LIBRARY_NAME;
        InputStream libraryData = JavaProfiler.class.getResourceAsStream(resourcePath);
        if (libraryData != null) {
            Path libFile = Files.createTempFile(tempDir, "libjavaProfiler", ".so", new FileAttribute[0]);
            Files.copy(libraryData, libFile, StandardCopyOption.REPLACE_EXISTING);
            libFile.toFile().deleteOnExit();
            return libFile;
        }
        throw new IllegalStateException(resourcePath + " not found on classpath");
    }

    private void initializeContextStorage() {
        int maxPages;
        if (this.contextStorage == null && (maxPages = JavaProfiler.getMaxContextPages0()) > 0) {
            if (UNSAFE != null) {
                this.contextBaseOffsets = new long[maxPages];
                Arrays.fill(this.contextBaseOffsets, Long.MIN_VALUE);
            } else {
                this.contextStorage = new ByteBuffer[maxPages];
            }
        }
    }

    public void stop() throws IllegalStateException {
        this.stop0();
    }

    public native long getSamples();

    public String getVersion() {
        try {
            return this.execute0("version");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String execute(String command) throws IllegalArgumentException, IllegalStateException, IOException {
        if (command == null) {
            throw new NullPointerException();
        }
        return this.execute0(command);
    }

    public boolean recordTraceRoot(long rootSpanId, String endpoint, String operation, int sizeLimit) {
        return JavaProfiler.recordTrace0(rootSpanId, endpoint, operation, sizeLimit);
    }

    @Deprecated
    public boolean recordTraceRoot(long rootSpanId, String endpoint, int sizeLimit) {
        return JavaProfiler.recordTrace0(rootSpanId, endpoint, null, sizeLimit);
    }

    public void addThread() {
        this.filterThread0(true);
    }

    public void removeThread() {
        this.filterThread0(false);
    }

    public void setContext(long spanId, long rootSpanId) {
        int tid = TID.get();
        if (UNSAFE != null) {
            this.setContextJDK8(tid, spanId, rootSpanId);
        } else {
            this.setContextByteBuffer(tid, spanId, rootSpanId);
        }
    }

    private void setContextJDK8(int tid, long spanId, long rootSpanId) {
        if (this.contextBaseOffsets == null) {
            return;
        }
        long pageOffset = this.getPageUnsafe(tid);
        int index = tid % 1024 * 64;
        long base = pageOffset + (long)index;
        UNSAFE.putLong(base + 0L, spanId);
        UNSAFE.putLong(base + 8L, rootSpanId);
        UNSAFE.putLong(base + 16L, spanId ^ rootSpanId);
    }

    private void setContextByteBuffer(int tid, long spanId, long rootSpanId) {
        if (this.contextStorage == null) {
            return;
        }
        ByteBuffer page = this.getPage(tid);
        int index = tid % 1024 * 64;
        page.putLong(index + 0, spanId);
        page.putLong(index + 8, rootSpanId);
        page.putLong(index + 16, spanId ^ rootSpanId);
    }

    private ByteBuffer getPage(int tid) {
        int pageIndex = tid / 1024;
        ByteBuffer page = this.contextStorage[pageIndex];
        if (page == null) {
            this.contextStorage[pageIndex] = page = JavaProfiler.getContextPage0(tid).order(ByteOrder.LITTLE_ENDIAN);
        }
        return page;
    }

    private long getPageUnsafe(int tid) {
        int pageIndex = tid / 1024;
        long offset = this.contextBaseOffsets[pageIndex];
        if (offset == Long.MIN_VALUE) {
            this.contextBaseOffsets[pageIndex] = offset = JavaProfiler.getContextPageOffset0(tid);
        }
        return offset;
    }

    public void clearContext() {
        this.setContext(0L, 0L);
    }

    public void setContextValue(int offset, int value) {
        int tid = TID.get();
        if (UNSAFE != null) {
            this.setContextJDK8(tid, offset, value);
        } else {
            this.setContextByteBuffer(tid, offset, value);
        }
    }

    private void setContextJDK8(int tid, int offset, int value) {
        if (this.contextBaseOffsets == null) {
            return;
        }
        long pageOffset = this.getPageUnsafe(tid);
        UNSAFE.putInt(pageOffset + (long)JavaProfiler.addressOf(tid, offset), value);
    }

    public void setContextByteBuffer(int tid, int offset, int value) {
        if (this.contextStorage == null) {
            return;
        }
        ByteBuffer page = this.getPage(tid);
        page.putInt(JavaProfiler.addressOf(tid, offset), value);
    }

    void copyTags(int[] snapshot) {
        int tid = TID.get();
        if (UNSAFE != null) {
            this.copyTagsJDK8(tid, snapshot);
        } else {
            this.copyTagsByteBuffer(tid, snapshot);
        }
    }

    void copyTagsJDK8(int tid, int[] snapshot) {
        if (this.contextBaseOffsets == null) {
            return;
        }
        long pageOffset = this.getPageUnsafe(tid);
        long address = pageOffset + (long)JavaProfiler.addressOf(tid, 0);
        for (int i = 0; i < snapshot.length; ++i) {
            snapshot[i] = UNSAFE.getInt(address);
            address += 4L;
        }
    }

    void copyTagsByteBuffer(int tid, int[] snapshot) {
        if (this.contextStorage == null) {
            return;
        }
        ByteBuffer page = this.getPage(tid);
        int address = JavaProfiler.addressOf(tid, 0);
        for (int i = 0; i < snapshot.length; ++i) {
            snapshot[i] = page.getInt(address + i * 4);
        }
    }

    private static int addressOf(int tid, int offset) {
        return tid % 1024 * 64 + 24 + offset * 4;
    }

    int registerConstant(String key) {
        return JavaProfiler.registerConstant0(key);
    }

    public void dump(Path recording) {
        JavaProfiler.dump0(recording.toAbsolutePath().toString());
    }

    public void recordSetting(String name, String value) {
        this.recordSetting(name, value, "");
    }

    public void recordSetting(String name, String value, String unit) {
        JavaProfiler.recordSettingEvent0(name, value, unit);
    }

    public boolean isThresholdExceeded(long thresholdMillis, long startTicks, long endTicks) {
        return endTicks - startTicks > thresholdMillis * TSCFrequencyHolder.FREQUENCY / 1000L;
    }

    public void recordQueueTime(long startTicks, long endTicks, Class<?> task, Class<?> scheduler, Thread origin) {
        JavaProfiler.recordQueueEnd0(startTicks, endTicks, task.getName(), scheduler.getName(), origin);
    }

    public long getCurrentTicks() {
        return JavaProfiler.currentTicks0();
    }

    public Map<String, Long> getDebugCounters() {
        HashMap<String, Long> counters = new HashMap<String, Long>();
        ByteBuffer buffer = JavaProfiler.getDebugCounters0().order(ByteOrder.LITTLE_ENDIAN);
        if (buffer.hasRemaining()) {
            String[] names = JavaProfiler.describeDebugCounters0();
            for (int i = 0; i < names.length && i * 128 < buffer.capacity(); ++i) {
                counters.put(names[i], buffer.getLong(i * 128));
            }
        }
        return counters;
    }

    private static boolean isMusl() throws IOException {
        byte[] magic = new byte[]{127, 69, 76, 70};
        byte[] prefix = new byte[]{47, 108, 100, 45};
        byte[] musl = new byte[]{109, 117, 115, 108};
        Path binary = Paths.get(System.getProperty("java.home"), "bin", "java");
        byte[] buffer = new byte[4096];
        try (InputStream is = Files.newInputStream(binary, new OpenOption[0]);){
            int read = is.read(buffer, 0, 4);
            if (read != 4 || !JavaProfiler.containsArray(buffer, 0, magic)) {
                throw new IOException(Arrays.toString(buffer));
            }
            read = is.read(buffer);
            if (read <= 0) {
                throw new IOException();
            }
            int prefixPos = 0;
            for (int i = 0; i < read; ++i) {
                if (buffer[i] == prefix[prefixPos]) {
                    if (++prefixPos != prefix.length) continue;
                    boolean bl = JavaProfiler.containsArray(buffer, i + 1, musl);
                    return bl;
                }
                prefixPos = 0;
            }
        }
        return false;
    }

    private static boolean containsArray(byte[] container, int offset, byte[] contained) {
        for (int i = 0; i < contained.length; ++i) {
            int leftPos = offset + i;
            if (leftPos >= container.length) {
                return false;
            }
            if (container[leftPos] == contained[i]) continue;
            return false;
        }
        return true;
    }

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native void filterThread0(boolean var1);

    private static native int getTid0();

    private static native ByteBuffer getContextPage0(int var0);

    private static native long getContextPageOffset0(int var0);

    private static native int getMaxContextPages0();

    private static native boolean recordTrace0(long var0, String var2, String var3, int var4);

    private static native int registerConstant0(String var0);

    private static native void dump0(String var0);

    private static native ByteBuffer getDebugCounters0();

    private static native String[] describeDebugCounters0();

    private static native void recordSettingEvent0(String var0, String var1, String var2);

    private static native void recordQueueEnd0(long var0, long var2, String var4, String var5, Thread var6);

    private static native long currentTicks0();

    private static native long tscFrequency0();

    static /* synthetic */ long access$000() {
        return JavaProfiler.tscFrequency0();
    }

    static {
        Unsafe unsafe = null;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.8")) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                unsafe = (Unsafe)f.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UNSAFE = unsafe;
        TID = ThreadLocal.withInitial(JavaProfiler::getTid0);
    }

    static final class TSCFrequencyHolder {
        static final long FREQUENCY = JavaProfiler.access$000();

        TSCFrequencyHolder() {
        }
    }
}

