/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    private static final long CONNECTION_TIMEOUT = 10000L;
    private JMXConnector connector;
    protected MBeanServerConnection mbs;
    protected Map<String, Object> env;
    protected JMXServiceURL address;

    public MBeanInfo getMBeanInfo(ObjectName beanName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.mbs.getMBeanInfo(beanName);
    }

    public Set<ObjectName> queryNames(ObjectName name) throws IOException {
        String scope = name != null ? name.toString() : "*:*";
        log.debug("Querying bean names on scope: " + scope);
        return this.mbs.queryNames(name, null);
    }

    protected void createConnection() throws IOException {
        this.env.put("attribute.remote.x.request.waiting.timeout", 10000L);
        this.closeConnector();
        log.info("Connecting to: " + this.address);
        this.connector = JMXConnectorFactory.connect(this.address, this.env);
        this.mbs = this.connector.getMBeanServerConnection();
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object attr = this.mbs.getAttribute(objectName, attributeName);
        if (attr instanceof Attribute) {
            return ((Attribute)attr).getValue();
        }
        return attr;
    }

    public void closeConnector() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isAlive() {
        if (this.connector == null) {
            return false;
        }
        try {
            this.connector.getConnectionId();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

