/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class JsonParser {
    private Map<String, Object> parsedJson;

    public JsonParser(byte[] utf8) throws JsonException {
        Parser parser = new Parser(utf8);
        Object value = parser.parse();
        if (!(value instanceof Map)) {
            throw new JsonException(parser, "expected json object at the top level");
        }
        this.parsedJson = (Map)value;
    }

    public JsonParser(JsonParser other) {
        this.parsedJson = new HashMap<String, Object>((Map)other.getParsedJson());
    }

    public Object getJsonConfigs() {
        return this.parsedJson.get("configs");
    }

    public Object getJsonTimestamp() {
        return this.parsedJson.get("timestamp");
    }

    public Object getJsonInstances(String key) {
        Map config = (Map)((Map)this.parsedJson.get("configs")).get(key);
        return config.get("instances");
    }

    public Object getInitConfig(String key) {
        Map config = (Map)((Map)this.parsedJson.get("configs")).get(key);
        return config.get("init_config");
    }

    public Object getParsedJson() {
        return this.parsedJson;
    }

    static class Parser {
        byte[] buf;
        int beg = 0;
        int pos = 0;
        int depth = 0;
        static final int max_object_keys = 100000;
        static final int max_array_items = 100000;
        static final int max_string_length = 100000;
        static final int max_number_length = 100;
        static final int max_depth = 1000;
        ByteVector str = new ByteVector();
        private static final AsciiSet WS = AsciiSet.of('\t', '\n', '\r', ' ');
        private static final AsciiSet DIGITS = AsciiSet.of('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
        private static final AsciiSet PLUS_MINUS = AsciiSet.of('+', '-');
        private static final AsciiSet EXP = AsciiSet.of('e', 'E');
        private static final AsciiSet HEX = AsciiSet.of(DIGITS, 'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F');

        Parser(byte[] buf) {
            this.buf = buf;
        }

        private String take(int skipEnd) {
            String res = new String(this.buf, this.beg, this.pos - this.beg - skipEnd, StandardCharsets.UTF_8);
            this.skip();
            return res;
        }

        private void take(ByteVector dst, int skipEnd) {
            dst.put(this.buf, this.beg, this.pos - this.beg - skipEnd);
            this.skip();
        }

        private void skip() {
            this.beg = this.pos;
        }

        private void back() {
            --this.pos;
        }

        private byte next_byte() throws JsonException {
            if (this.done()) {
                throw new JsonException(this, "unexpected end of stream");
            }
            byte bv = this.buf[this.pos];
            ++this.pos;
            return bv;
        }

        private char next() throws JsonException {
            return (char)this.next_byte();
        }

        private boolean accept(AsciiSet set) throws JsonException {
            if (set.get(this.next_byte())) {
                return true;
            }
            this.back();
            return false;
        }

        private boolean accept(char ch) throws JsonException {
            if (this.next() == ch) {
                return true;
            }
            this.back();
            return false;
        }

        private void accept_run(AsciiSet set) throws JsonException {
            while (!this.done() && this.accept(set)) {
            }
        }

        private boolean done() {
            return this.pos >= this.buf.length;
        }

        private int length() {
            return this.pos - this.beg;
        }

        private void skip_ws() throws JsonException {
            this.accept_run(WS);
            this.skip();
        }

        Object parse() throws JsonException {
            Object res = this.parse_value();
            this.skip_ws();
            if (!this.done()) {
                throw new JsonException(this, "unused data after the top-level value");
            }
            return res;
        }

        private Object parse_value() throws JsonException {
            if (++this.depth > 1000) {
                throw new JsonException(this, "too much nesting");
            }
            try {
                this.skip_ws();
                switch (this.next()) {
                    case '{': {
                        HashMap<String, Object> hashMap = this.parse_object();
                        return hashMap;
                    }
                    case '[': {
                        ArrayList<Object> arrayList = this.parse_array();
                        return arrayList;
                    }
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        Number number = this.parse_number();
                        return number;
                    }
                    case '\"': {
                        String string = this.parse_string();
                        return string;
                    }
                    case 't': {
                        Object object = this.parse_true();
                        return object;
                    }
                    case 'f': {
                        Object object = this.parse_false();
                        return object;
                    }
                    case 'n': {
                        Object object = this.parse_null();
                        return object;
                    }
                }
                throw new JsonException(this, "unexpected character");
            }
            finally {
                --this.depth;
            }
        }

        private HashMap<String, Object> parse_object() throws JsonException {
            int limit = 100000;
            HashMap<String, Object> res = new HashMap<String, Object>();
            this.skip_ws();
            if (this.accept('}')) {
                return res;
            }
            block4: while (limit-- > 0) {
                this.skip_ws();
                if (!this.accept('\"')) {
                    throw new JsonException(this, "object key must be a string");
                }
                String key = this.parse_string();
                this.skip_ws();
                if (!this.accept(':')) {
                    throw new JsonException(this, "object key must be followed by a semicolon");
                }
                Object val = this.parse_value();
                res.put(key, val);
                this.skip_ws();
                switch (this.next()) {
                    case ',': {
                        continue block4;
                    }
                    case '}': {
                        this.skip();
                        return res;
                    }
                }
                throw new JsonException(this, "unexpected character after object value");
            }
            throw new JsonException(this, "exceed number of allowed keys in an object");
        }

        private ArrayList<Object> parse_array() throws JsonException {
            ArrayList<Object> res = new ArrayList<Object>();
            int limit = 100000;
            this.skip_ws();
            if (this.accept(']')) {
                return res;
            }
            block4: while (limit-- > 0) {
                this.skip_ws();
                res.add(this.parse_value());
                this.skip_ws();
                switch (this.next()) {
                    case ',': {
                        continue block4;
                    }
                    case ']': {
                        return res;
                    }
                }
                throw new JsonException(this, "unexpected character after array item");
            }
            throw new JsonException(this, "too many items in an array");
        }

        private Number parse_number() throws JsonException {
            this.back();
            this.accept('-');
            switch (this.next()) {
                case '0': {
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.accept_run(DIGITS);
                    break;
                }
                default: {
                    throw new JsonException(this, "unexpected character at start of a number");
                }
            }
            boolean integer = true;
            if (!this.done() && this.accept('.')) {
                integer = false;
                this.accept_run(DIGITS);
            }
            if (!this.done() && this.accept(EXP)) {
                integer = false;
                this.accept(PLUS_MINUS);
                this.accept_run(DIGITS);
            }
            if (this.length() > 100) {
                throw new JsonException(this, "number literal is too long");
            }
            String token = this.take(0);
            if (integer && !"-0".equals(token)) {
                try {
                    long val = Long.valueOf(token);
                    if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                        return (int)val;
                    }
                    return val;
                }
                catch (NumberFormatException val) {
                    // empty catch block
                }
            }
            try {
                return Double.valueOf(token);
            }
            catch (NumberFormatException ex) {
                throw new JsonException(this, "unable to parse number literal", ex);
            }
        }

        private String parse_string() throws JsonException {
            this.skip();
            this.str.reset();
            block4: while (this.str.length() + this.length() < 100000) {
                switch (this.next()) {
                    case '\"': {
                        if (this.str.empty()) {
                            return this.take(1);
                        }
                        this.take(this.str, 1);
                        return this.str.to_string();
                    }
                    case '\\': {
                        this.take(this.str, 1);
                        this.parse_string_escape();
                        continue block4;
                    }
                }
            }
            throw new JsonException(this, "string is too long");
        }

        private void parse_string_escape() throws JsonException {
            switch (this.next()) {
                case '\"': {
                    this.str.put((byte)34);
                    break;
                }
                case '\\': {
                    this.str.put((byte)92);
                    break;
                }
                case '/': {
                    this.str.put((byte)47);
                    break;
                }
                case 'b': {
                    this.str.put((byte)8);
                    break;
                }
                case 'f': {
                    this.str.put((byte)12);
                    break;
                }
                case 'n': {
                    this.str.put((byte)10);
                    break;
                }
                case 'r': {
                    this.str.put((byte)13);
                    break;
                }
                case 't': {
                    this.str.put((byte)9);
                    break;
                }
                case 'u': {
                    this.parse_unicode_escape_maybe_surrogate();
                    break;
                }
                default: {
                    throw new JsonException(this, "invalid escape sequence");
                }
            }
            this.skip();
        }

        private void parse_unicode_escape_maybe_surrogate() throws JsonException {
            int ch = this.parse_unicode_escape();
            if (ch >= 55296 && ch < 56320) {
                if (!this.accept('\\') || !this.accept('u')) {
                    throw new JsonException(this, "escaped unicode surrogate pair must be followed by another one");
                }
                int low = this.parse_unicode_escape();
                if (low < 56320 || low >= 57344) {
                    throw new JsonException(this, "invalid escaped unicode surrogate pair");
                }
                ch = (ch & 0x3FF) << 10 | low & 0x3FF | 0x10000;
            }
            if (ch < 128) {
                this.str.put((byte)ch);
            } else if (ch < 2048) {
                this.str.put((byte)(0xC0 | ch >> 6));
                this.str.put((byte)(0x80 | ch & 0x3F));
            } else if (ch < 65536) {
                this.str.put((byte)(0xE0 | ch >> 12));
                this.str.put((byte)(0x80 | ch >> 6 & 0x3F));
                this.str.put((byte)(0x80 | ch & 0x3F));
            } else {
                this.str.put((byte)(0xF0 | ch >> 18));
                this.str.put((byte)(0x80 | ch >> 12 & 0x3F));
                this.str.put((byte)(0x80 | ch >> 6 & 0x3F));
                this.str.put((byte)(0x80 | ch & 0x3F));
            }
        }

        private int parse_unicode_escape() throws JsonException {
            this.skip();
            if (!(this.accept(HEX) && this.accept(HEX) && this.accept(HEX) && this.accept(HEX))) {
                throw new JsonException(this, "invalid unicode escape sequence");
            }
            return Integer.parseInt(this.take(0), 16);
        }

        private Object parse_null() throws JsonException {
            if (this.accept('u') && this.accept('l') && this.accept('l')) {
                return null;
            }
            throw new JsonException(this, "invalid keyword");
        }

        private Object parse_true() throws JsonException {
            if (this.accept('r') && this.accept('u') && this.accept('e')) {
                return true;
            }
            throw new JsonException(this, "invalid keyword");
        }

        private Object parse_false() throws JsonException {
            if (this.accept('a') && this.accept('l') && this.accept('s') && this.accept('e')) {
                return false;
            }
            throw new JsonException(this, "invalid keyword");
        }
    }

    static class ByteVector {
        byte[] buf;
        int cap;
        int len;

        ByteVector() {
        }

        void reserve(int needed) {
            if (this.cap < needed || this.len >= this.cap - needed) {
                this.grow(needed);
            }
        }

        void grow(int needed) {
            int capreq;
            int newcap = this.cap * 2;
            if (newcap == 0) {
                newcap = 1024;
            }
            if ((capreq = this.len + needed) > newcap) {
                newcap = capreq;
            }
            byte[] next = new byte[newcap];
            if (this.len > 0) {
                System.arraycopy(this.buf, 0, next, 0, this.len);
            }
            this.buf = next;
            this.cap = newcap;
        }

        void put(byte bv) {
            this.reserve(1);
            this.buf[this.len++] = bv;
        }

        void put(byte[] bytes, int offset, int count) {
            this.reserve(count);
            System.arraycopy(bytes, offset, this.buf, this.len, count);
            this.len += count;
        }

        String to_string() {
            return new String(this.buf, 0, this.len, StandardCharsets.UTF_8);
        }

        boolean empty() {
            return this.len == 0;
        }

        int length() {
            return this.len;
        }

        void reset() {
            this.len = 0;
        }
    }

    private static class AsciiSet {
        boolean[] map = new boolean[128];

        AsciiSet(char ... chars) {
            for (char c : chars) {
                if (c < '\u0000' || c >= '\u0080') {
                    throw new RuntimeException("char out of range");
                }
                this.map[c] = true;
            }
        }

        boolean get(byte bv) {
            if (bv < 0) {
                return false;
            }
            return this.map[bv];
        }

        static AsciiSet of(char ... chars) {
            return new AsciiSet(chars);
        }

        static AsciiSet of(AsciiSet base, char ... chars) {
            AsciiSet bs = new AsciiSet(chars);
            for (int i = 0; i < base.map.length; ++i) {
                int n = i;
                bs.map[n] = bs.map[n] | base.map[i];
            }
            return bs;
        }
    }

    public static final class JsonException
    extends Exception {
        Parser parser;

        public JsonException(String message) {
            super(message);
        }

        public JsonException(Parser parser, String message, Throwable cause) {
            super(message, cause);
            this.parser = parser;
        }

        public JsonException(Parser parser, String message) {
            super(message);
            this.parser = parser;
        }

        @Override
        public String toString() {
            String ch = "n/a";
            int pos = this.parser.pos - 1;
            if (pos >= 0) {
                byte bv = this.parser.buf[pos];
                ch = bv > 32 && bv < 127 ? String.format("'%c'", bv) : String.format("0x%02x", bv);
            }
            return String.format("at pos %d char %s: %s", pos, ch, this.getMessage());
        }
    }
}

