/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datadog.jmxfetch.service.ServiceNameProvider;

public class ConfigServiceNameProvider
implements ServiceNameProvider {
    private List<String> serviceNames;
    private ServiceNameProvider additionalServiceNames;

    public ConfigServiceNameProvider(Map<String, Object> instanceMap, Map<String, Object> initConfig, ServiceNameProvider additionalServiceNames) {
        List<String> services = ConfigServiceNameProvider.compileServiceList(instanceMap);
        if (services.size() == 0) {
            services = ConfigServiceNameProvider.compileServiceList(initConfig);
        }
        this.serviceNames = services;
        this.additionalServiceNames = additionalServiceNames;
    }

    @Override
    public Iterable<String> getServiceNames() {
        if (this.additionalServiceNames == null) {
            return this.serviceNames;
        }
        ArrayList<String> names = new ArrayList<String>(this.serviceNames);
        for (String service : this.additionalServiceNames.getServiceNames()) {
            names.add(service);
        }
        return names;
    }

    private static List<String> compileServiceList(Map<String, Object> config) {
        List<String> services = new ArrayList<String>();
        if (config == null || !config.containsKey("service")) {
            return services;
        }
        try {
            String svc = (String)config.get("service");
            if (svc != null && !svc.isEmpty()) {
                services.add(svc);
            }
        }
        catch (ClassCastException e) {
            services = (List)config.get("service");
        }
        return services;
    }
}

