/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.persistence.impl;

import com.liferay.depot.exception.NoSuchEntryException;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryTable;
import com.liferay.depot.model.impl.DepotEntryImpl;
import com.liferay.depot.model.impl.DepotEntryModelImpl;
import com.liferay.depot.service.persistence.DepotEntryPersistence;
import com.liferay.depot.service.persistence.DepotEntryUtil;
import com.liferay.depot.service.persistence.impl.DepotEntryModelArgumentsResolver;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DepotEntryPersistence.class, BasePersistence.class})
public class DepotEntryPersistenceImpl
extends BasePersistenceImpl<DepotEntry>
implements DepotEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DepotEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "depotEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(depotEntry.uuid IS NULL OR depotEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "depotEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "depotEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "depotEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "depotEntry.companyId = ?";
    private FinderPath _finderPathFetchByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "depotEntry.groupId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DEPOTENTRY = "SELECT depotEntry FROM DepotEntry depotEntry";
    private static final String _SQL_SELECT_DEPOTENTRY_WHERE = "SELECT depotEntry FROM DepotEntry depotEntry WHERE ";
    private static final String _SQL_COUNT_DEPOTENTRY = "SELECT COUNT(depotEntry) FROM DepotEntry depotEntry";
    private static final String _SQL_COUNT_DEPOTENTRY_WHERE = "SELECT COUNT(depotEntry) FROM DepotEntry depotEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "depotEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DepotEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DepotEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DepotEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    @Reference
    private DepotEntryModelArgumentsResolver _depotEntryModelArgumentsResolver;

    public List<DepotEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<DepotEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<DepotEntry> findByUuid(String uuid, int start, int end, OrderByComparator<DepotEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<DepotEntry> findByUuid(String uuid, int start, int end, OrderByComparator<DepotEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DepotEntry depotEntry : list) {
                if (uuid.equals(depotEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY depotEntry.depotEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DepotEntry findByUuid_First(String uuid, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (depotEntry != null) {
            return depotEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public DepotEntry fetchByUuid_First(String uuid, OrderByComparator<DepotEntry> orderByComparator) {
        List<DepotEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotEntry findByUuid_Last(String uuid, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (depotEntry != null) {
            return depotEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public DepotEntry fetchByUuid_Last(String uuid, OrderByComparator<DepotEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<DepotEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotEntry[] findByUuid_PrevAndNext(long depotEntryId, String uuid, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        DepotEntry depotEntry = this.findByPrimaryKey(depotEntryId);
        Session session = null;
        try {
            session = this.openSession();
            DepotEntry[] array = new DepotEntryImpl[]{this.getByUuid_PrevAndNext(session, depotEntry, uuid, orderByComparator, true), depotEntry, this.getByUuid_PrevAndNext(session, depotEntry, uuid, orderByComparator, false)};
            DepotEntry[] depotEntryArray = array;
            return depotEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DepotEntry getByUuid_PrevAndNext(Session session, DepotEntry depotEntry, String uuid, OrderByComparator<DepotEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY depotEntry.depotEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)depotEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DepotEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (DepotEntry depotEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)depotEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DepotEntry findByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByUUID_G(uuid, groupId);
        if (depotEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return depotEntry;
    }

    public DepotEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public DepotEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        DepotEntry depotEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs);
        }
        if (result instanceof DepotEntry && (!Objects.equals(uuid, (depotEntry = (DepotEntry)result).getUuid()) || groupId != depotEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("depotEntry.uuid = ? AND ");
            }
            sb.append("depotEntry.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    DepotEntry depotEntry2 = (DepotEntry)list.get(0);
                    result = depotEntry2;
                    this.cacheResult(depotEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DepotEntry)result;
    }

    public DepotEntry removeByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        DepotEntry depotEntry = this.findByUUID_G(uuid, groupId);
        return (DepotEntry)this.remove((BaseModel)depotEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("depotEntry.uuid = ? AND ");
            }
            sb.append("depotEntry.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DepotEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<DepotEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<DepotEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DepotEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<DepotEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DepotEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DepotEntry depotEntry : list) {
                if (uuid.equals(depotEntry.getUuid()) && companyId == depotEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("depotEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY depotEntry.depotEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DepotEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (depotEntry != null) {
            return depotEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public DepotEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator) {
        List<DepotEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (depotEntry != null) {
            return depotEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public DepotEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<DepotEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotEntry[] findByUuid_C_PrevAndNext(long depotEntryId, String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        DepotEntry depotEntry = this.findByPrimaryKey(depotEntryId);
        Session session = null;
        try {
            session = this.openSession();
            DepotEntry[] array = new DepotEntryImpl[]{this.getByUuid_C_PrevAndNext(session, depotEntry, uuid, companyId, orderByComparator, true), depotEntry, this.getByUuid_C_PrevAndNext(session, depotEntry, uuid, companyId, orderByComparator, false)};
            DepotEntry[] depotEntryArray = array;
            return depotEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DepotEntry getByUuid_C_PrevAndNext(Session session, DepotEntry depotEntry, String uuid, long companyId, OrderByComparator<DepotEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("depotEntry.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY depotEntry.depotEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)depotEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DepotEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (DepotEntry depotEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)depotEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DEPOTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(depotEntry.uuid IS NULL OR depotEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("depotEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DepotEntry findByGroupId(long groupId) throws NoSuchEntryException {
        DepotEntry depotEntry = this.fetchByGroupId(groupId);
        if (depotEntry == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return depotEntry;
    }

    public DepotEntry fetchByGroupId(long groupId) {
        return this.fetchByGroupId(groupId, true);
    }

    public DepotEntry fetchByGroupId(long groupId, boolean useFinderCache) {
        DepotEntry depotEntry;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByGroupId, finderArgs);
        }
        if (result instanceof DepotEntry && groupId != (depotEntry = (DepotEntry)result).getGroupId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_DEPOTENTRY_WHERE);
            sb.append("depotEntry.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByGroupId, finderArgs, (Object)list);
                    }
                } else {
                    DepotEntry depotEntry2 = (DepotEntry)list.get(0);
                    result = depotEntry2;
                    this.cacheResult(depotEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DepotEntry)result;
    }

    public DepotEntry removeByGroupId(long groupId) throws NoSuchEntryException {
        DepotEntry depotEntry = this.findByGroupId(groupId);
        return (DepotEntry)this.remove((BaseModel)depotEntry);
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DEPOTENTRY_WHERE);
            sb.append("depotEntry.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DepotEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(DepotEntry.class);
        this.setModelImplClass(DepotEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DepotEntryTable.INSTANCE);
    }

    public void cacheResult(DepotEntry depotEntry) {
        this.entityCache.putResult(DepotEntryImpl.class, (Serializable)Long.valueOf(depotEntry.getPrimaryKey()), (Serializable)depotEntry);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{depotEntry.getUuid(), depotEntry.getGroupId()}, (Object)depotEntry);
        this.finderCache.putResult(this._finderPathFetchByGroupId, new Object[]{depotEntry.getGroupId()}, (Object)depotEntry);
    }

    public void cacheResult(List<DepotEntry> depotEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && depotEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (DepotEntry depotEntry : depotEntries) {
            if (this.entityCache.getResult(DepotEntryImpl.class, (Serializable)Long.valueOf(depotEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(depotEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DepotEntryImpl.class);
        this.finderCache.clearCache(DepotEntryImpl.class);
    }

    public void clearCache(DepotEntry depotEntry) {
        this.entityCache.removeResult(DepotEntryImpl.class, (BaseModel)depotEntry);
    }

    public void clearCache(List<DepotEntry> depotEntries) {
        for (DepotEntry depotEntry : depotEntries) {
            this.entityCache.removeResult(DepotEntryImpl.class, (BaseModel)depotEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DepotEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DepotEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DepotEntryModelImpl depotEntryModelImpl) {
        Object[] args = new Object[]{depotEntryModelImpl.getUuid(), depotEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)depotEntryModelImpl);
        args = new Object[]{depotEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByGroupId, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByGroupId, args, (Object)depotEntryModelImpl);
    }

    public DepotEntry create(long depotEntryId) {
        DepotEntryImpl depotEntry = new DepotEntryImpl();
        depotEntry.setNew(true);
        depotEntry.setPrimaryKey(depotEntryId);
        String uuid = PortalUUIDUtil.generate();
        depotEntry.setUuid(uuid);
        depotEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return depotEntry;
    }

    public DepotEntry remove(long depotEntryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(depotEntryId));
    }

    public DepotEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            DepotEntry depotEntry = (DepotEntry)session.get(DepotEntryImpl.class, primaryKey);
            if (depotEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DepotEntry depotEntry2 = (DepotEntry)this.remove((BaseModel)depotEntry);
            return depotEntry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DepotEntry removeImpl(DepotEntry depotEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)depotEntry)) {
                depotEntry = (DepotEntry)session.get(DepotEntryImpl.class, depotEntry.getPrimaryKeyObj());
            }
            if (depotEntry != null) {
                session.delete((Object)depotEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (depotEntry != null) {
            this.clearCache(depotEntry);
        }
        return depotEntry;
    }

    public DepotEntry updateImpl(DepotEntry depotEntry) {
        boolean isNew = depotEntry.isNew();
        if (!(depotEntry instanceof DepotEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(depotEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)depotEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in depotEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DepotEntry implementation " + depotEntry.getClass());
        }
        DepotEntryModelImpl depotEntryModelImpl = (DepotEntryModelImpl)depotEntry;
        if (Validator.isNull((String)depotEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            depotEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && depotEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                depotEntry.setCreateDate(date);
            } else {
                depotEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!depotEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                depotEntry.setModifiedDate(date);
            } else {
                depotEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)depotEntry);
            } else {
                depotEntry = (DepotEntry)session.merge((Object)depotEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(DepotEntryImpl.class, (BaseModel)depotEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(depotEntryModelImpl);
        if (isNew) {
            depotEntry.setNew(false);
        }
        depotEntry.resetOriginalValues();
        return depotEntry;
    }

    public DepotEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        DepotEntry depotEntry = (DepotEntry)this.fetchByPrimaryKey(primaryKey);
        if (depotEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return depotEntry;
    }

    public DepotEntry findByPrimaryKey(long depotEntryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(depotEntryId));
    }

    public DepotEntry fetchByPrimaryKey(long depotEntryId) {
        return (DepotEntry)this.fetchByPrimaryKey(Long.valueOf(depotEntryId));
    }

    public List<DepotEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DepotEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DepotEntry> findAll(int start, int end, OrderByComparator<DepotEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DepotEntry> findAll(int start, int end, OrderByComparator<DepotEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DEPOTENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DEPOTENTRY;
                sql = sql.concat(" ORDER BY depotEntry.depotEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DepotEntry depotEntry : this.findAll()) {
            this.remove((BaseModel)depotEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DEPOTENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "depotEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DEPOTENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DepotEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathFetchByGroupId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._setDepotEntryUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setDepotEntryUtilPersistence(null);
        this.entityCache.removeCache(DepotEntryImpl.class.getName());
    }

    private void _setDepotEntryUtilPersistence(DepotEntryPersistence depotEntryPersistence) {
        try {
            Field field = DepotEntryUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, depotEntryPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.depot.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.depot.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.depot.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

