/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.messaging;

import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorRegistry;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/dispatch/executor"}, service={MessageListener.class})
public class DispatchMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(DispatchMessageListener.class);
    @Reference
    private DispatchLogLocalService _dispatchLogLocalService;
    @Reference
    private DispatchTaskExecutorRegistry _dispatchTaskExecutorRegistry;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public void doReceive(Message message) throws Exception {
        DispatchLog dispatchLog;
        String payload = (String)message.getPayload();
        JSONObject jsonObject = this._jsonFactory.createJSONObject(payload);
        long dispatchTriggerId = jsonObject.getLong("dispatchTriggerId");
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId);
        if (!dispatchTrigger.isOverlapAllowed() && (dispatchLog = this._dispatchLogLocalService.fetchLatestDispatchLog(dispatchTriggerId, DispatchTaskStatus.IN_PROGRESS)) != null) {
            Date date = new Date();
            this._dispatchLogLocalService.addDispatchLog(dispatchTrigger.getUserId(), dispatchTrigger.getDispatchTriggerId(), date, "Only one instance in progress is allowed", null, date, DispatchTaskStatus.CANCELED);
            return;
        }
        this._execute(dispatchTrigger);
    }

    private void _execute(DispatchTrigger dispatchTrigger) throws Exception {
        DispatchTaskExecutor dispatchTaskExecutor = this._dispatchTaskExecutorRegistry.fetchDispatchTaskExecutor(dispatchTrigger.getDispatchTaskExecutorType());
        if (dispatchTaskExecutor != null) {
            dispatchTaskExecutor.execute(dispatchTrigger.getDispatchTriggerId());
            return;
        }
        String message = "Unable to find dispatch task executor of type " + dispatchTrigger.getDispatchTaskExecutorType();
        if (_log.isWarnEnabled()) {
            _log.warn((Object)message);
        }
        Date date = new Date();
        this._dispatchLogLocalService.addDispatchLog(dispatchTrigger.getUserId(), dispatchTrigger.getDispatchTriggerId(), date, message, null, date, DispatchTaskStatus.CANCELED);
    }
}

