/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchLogServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=dispatch", "json.web.service.context.path=DispatchLog"}, service={AopService.class})
public class DispatchLogServiceImpl
extends DispatchLogServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dispatch.model.DispatchTrigger)")
    private ModelResourcePermission<DispatchTrigger> _dispatchTriggerModelResourcePermission;

    public void deleteDispatchLog(long dispatchLogId) throws PortalException {
        DispatchLog dispatchLog = this.dispatchLogLocalService.getDispatchLog(dispatchLogId);
        this._dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchLog.getDispatchTriggerId(), "UPDATE");
        this.dispatchLogLocalService.deleteDispatchLog(dispatchLogId);
    }

    public DispatchLog getDispatchLog(long dispatchLogId) throws PortalException {
        DispatchLog dispatchLog = this.dispatchLogLocalService.getDispatchLog(dispatchLogId);
        this._dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchLog.getDispatchTriggerId(), "VIEW");
        return dispatchLog;
    }

    public List<DispatchLog> getDispatchLogs(long dispatchTriggerId, int start, int end) throws PortalException {
        this._dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "VIEW");
        return this.dispatchLogLocalService.getDispatchLogs(dispatchTriggerId, start, end);
    }

    public List<DispatchLog> getDispatchLogs(long dispatchTriggerId, int start, int end, OrderByComparator<DispatchLog> orderByComparator) throws PortalException {
        this._dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "VIEW");
        return this.dispatchLogPersistence.findByDispatchTriggerId(dispatchTriggerId, start, end, orderByComparator);
    }

    public int getDispatchLogsCount(long dispatchTriggerId) throws PortalException {
        this._dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "VIEW");
        return this.dispatchLogLocalService.getDispatchLogsCount(dispatchTriggerId);
    }
}

