/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.http;

import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.service.OAuthApplicationServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.InputStream;

public class OAuthApplicationServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OAuthApplicationServiceHttp.class);
    private static final Class<?>[] _addOAuthApplicationParameterTypes0 = new Class[]{String.class, String.class, Integer.TYPE, Boolean.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteLogoParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteOAuthApplicationParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateLogoParameterTypes3 = new Class[]{Long.TYPE, InputStream.class};
    private static final Class<?>[] _updateOAuthApplicationParameterTypes4 = new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE, String.class, String.class, ServiceContext.class};

    public static OAuthApplication addOAuthApplication(HttpPrincipal httpPrincipal, String name, String description, int accessLevel, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthApplicationServiceUtil.class, "addOAuthApplication", (Class[])_addOAuthApplicationParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, accessLevel, shareableAccessToken, callbackURI, websiteURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthApplication)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long oAuthApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthApplicationServiceUtil.class, "deleteLogo", (Class[])_deleteLogoParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthApplicationId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthApplication deleteOAuthApplication(HttpPrincipal httpPrincipal, long oAuthApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthApplicationServiceUtil.class, "deleteOAuthApplication", (Class[])_deleteOAuthApplicationParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthApplicationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthApplication)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthApplication updateLogo(HttpPrincipal httpPrincipal, long oAuthApplicationId, InputStream inputStream) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthApplicationServiceUtil.class, "updateLogo", (Class[])_updateLogoParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthApplicationId, inputStream});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthApplication)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthApplication updateOAuthApplication(HttpPrincipal httpPrincipal, long oAuthApplicationId, String name, String description, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthApplicationServiceUtil.class, "updateOAuthApplication", (Class[])_updateOAuthApplicationParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthApplicationId, name, description, shareableAccessToken, callbackURI, websiteURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthApplication)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

