/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.impl;

import com.liferay.oauth.exception.OAuthApplicationCallbackURIException;
import com.liferay.oauth.exception.OAuthApplicationNameException;
import com.liferay.oauth.exception.OAuthApplicationWebsiteURLException;
import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.service.base.OAuthApplicationLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth.model.OAuthApplication"}, service={AopService.class})
public class OAuthApplicationLocalServiceImpl
extends OAuthApplicationLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;

    @Deprecated
    public OAuthApplication addOAuthApplication(long userId, String name, String description, int accessLevel, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        String consumerKey = serviceContext.getUuid();
        if (Validator.isNull((String)consumerKey)) {
            consumerKey = PortalUUIDUtil.generate();
        }
        return this.oAuthApplicationLocalService.addOAuthApplication(userId, name, description, DigesterUtil.digestHex((String)"MD5", (String[])new String[]{consumerKey, PwdGenerator.getPassword()}), accessLevel, shareableAccessToken, callbackURI, websiteURL, serviceContext);
    }

    public OAuthApplication addOAuthApplication(long userId, String name, String description, String token, int accessLevel, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        this.validate(name, callbackURI, websiteURL);
        long oAuthApplicationId = this.counterLocalService.increment();
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.create(oAuthApplicationId);
        oAuthApplication.setCompanyId(user.getCompanyId());
        oAuthApplication.setUserId(user.getUserId());
        oAuthApplication.setUserName(user.getFullName());
        oAuthApplication.setCreateDate(serviceContext.getCreateDate(now));
        oAuthApplication.setModifiedDate(serviceContext.getModifiedDate(now));
        oAuthApplication.setName(name);
        oAuthApplication.setDescription(description);
        String consumerKey = serviceContext.getUuid();
        if (Validator.isNull((String)consumerKey)) {
            consumerKey = PortalUUIDUtil.generate();
        }
        oAuthApplication.setConsumerKey(consumerKey);
        oAuthApplication.setConsumerSecret(token);
        oAuthApplication.setAccessLevel(accessLevel);
        oAuthApplication.setShareableAccessToken(shareableAccessToken);
        oAuthApplication.setCallbackURI(callbackURI);
        oAuthApplication.setWebsiteURL(websiteURL);
        oAuthApplication = (OAuthApplication)this.oAuthApplicationPersistence.update((BaseModel)oAuthApplication);
        this.resourceLocalService.addModelResources((AuditedModel)oAuthApplication, serviceContext);
        return oAuthApplication;
    }

    public void deleteLogo(long oAuthApplicationId) throws PortalException {
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
        long logoId = oAuthApplication.getLogoId();
        if (logoId > 0L) {
            oAuthApplication.setLogoId(0L);
            this.oAuthApplicationPersistence.update((BaseModel)oAuthApplication);
            this.imageLocalService.deleteImage(logoId);
        }
    }

    @Override
    public OAuthApplication deleteOAuthApplication(long oAuthApplicationId) throws PortalException {
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
        return this.deleteOAuthApplication(oAuthApplication);
    }

    @Override
    public OAuthApplication deleteOAuthApplication(OAuthApplication oAuthApplication) throws PortalException {
        this.oAuthApplicationPersistence.remove((BaseModel)oAuthApplication);
        List oAuthUsers = this.oAuthUserPersistence.findByOAuthApplicationId(oAuthApplication.getOAuthApplicationId());
        for (OAuthUser oAuthUser : oAuthUsers) {
            this.oAuthUserPersistence.remove((BaseModel)oAuthUser);
        }
        this.resourceLocalService.deleteResource((AuditedModel)oAuthApplication, 4);
        this.imageLocalService.deleteImage(oAuthApplication.getLogoId());
        return oAuthApplication;
    }

    public OAuthApplication fetchOAuthApplication(String consumerKey) {
        return this.oAuthApplicationPersistence.fetchByConsumerKey(consumerKey);
    }

    public OAuthApplication getOAuthApplication(String consumerKey) throws PortalException {
        return this.oAuthApplicationPersistence.findByConsumerKey(consumerKey);
    }

    public List<OAuthApplication> getOAuthApplications(long companyId, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.oAuthApplicationPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getOAuthApplicationsCount(long companyId) {
        return this.oAuthApplicationPersistence.countByCompanyId(companyId);
    }

    public List<OAuthApplication> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        keywords = this._customSQL.keywords(keywords)[0];
        if (params != null && params.containsKey("userId")) {
            long userId = (Long)params.get("userId");
            if (Validator.isNotNull((String)keywords)) {
                return this.oAuthApplicationPersistence.findByU_N(userId, keywords, start, end, orderByComparator);
            }
            return this.oAuthApplicationPersistence.findByUserId(userId, start, end, orderByComparator);
        }
        if (Validator.isNotNull((String)keywords)) {
            return this.oAuthApplicationPersistence.findByC_N(companyId, keywords, start, end, orderByComparator);
        }
        return this.oAuthApplicationPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        keywords = this._customSQL.keywords(keywords)[0];
        if (params != null && params.containsKey("userId")) {
            long userId = (Long)params.get("userId");
            if (Validator.isNotNull((String)keywords)) {
                return this.oAuthApplicationPersistence.countByU_N(userId, keywords);
            }
            return this.oAuthApplicationPersistence.countByUserId(userId);
        }
        if (Validator.isNotNull((String)keywords)) {
            return this.oAuthApplicationPersistence.countByC_N(companyId, keywords);
        }
        return this.oAuthApplicationPersistence.countByCompanyId(companyId);
    }

    public OAuthApplication updateLogo(long oAuthApplicationId, InputStream inputStream) throws PortalException {
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
        long logoId = oAuthApplication.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            oAuthApplication.setLogoId(logoId);
            oAuthApplication = (OAuthApplication)this.oAuthApplicationPersistence.update((BaseModel)oAuthApplication);
        }
        this.imageLocalService.updateImage(logoId, inputStream);
        return oAuthApplication;
    }

    public OAuthApplication updateOAuthApplication(long oAuthApplicationId, String name, String description, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        this.validate(name, callbackURI, websiteURL);
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
        oAuthApplication.setModifiedDate(serviceContext.getModifiedDate(null));
        oAuthApplication.setName(name);
        oAuthApplication.setDescription(description);
        oAuthApplication.setShareableAccessToken(shareableAccessToken);
        oAuthApplication.setCallbackURI(callbackURI);
        oAuthApplication.setWebsiteURL(websiteURL);
        return (OAuthApplication)this.oAuthApplicationPersistence.update((BaseModel)oAuthApplication);
    }

    protected void validate(String name, String callbackURI, String websiteURL) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new OAuthApplicationNameException();
        }
        if (!Validator.isUri((String)callbackURI)) {
            throw new OAuthApplicationCallbackURIException();
        }
        if (!Validator.isUrl((String)websiteURL)) {
            throw new OAuthApplicationWebsiteURLException();
        }
    }
}

