/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.service.base.ShoppingCategoryServiceBaseImpl;
import com.liferay.shopping.service.permission.ShoppingCategoryPermission;
import java.util.List;

public class ShoppingCategoryServiceImpl
extends ShoppingCategoryServiceBaseImpl {
    @ServiceReference(type=ShoppingCategoryPermission.class)
    protected ShoppingCategoryPermission shoppingCategoryPermission;

    public ShoppingCategory addCategory(long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.shoppingCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, serviceContext);
    }

    public void deleteCategory(long categoryId) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "DELETE");
        this.shoppingCategoryLocalService.deleteCategory(categoryId);
    }

    public List<ShoppingCategory> getCategories(long groupId) {
        return this.shoppingCategoryPersistence.filterFindByGroupId(groupId);
    }

    public List<ShoppingCategory> getCategories(long groupId, long parentCategoryId, int start, int end) {
        return this.shoppingCategoryPersistence.filterFindByG_P(groupId, parentCategoryId, start, end);
    }

    public List<Object> getCategoriesAndItems(long groupId, long categoryId, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, obc);
        return this.shoppingCategoryFinder.filterFindC_I_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndItemsCount(long groupId, long categoryId) {
        return this.shoppingCategoryFinder.countC_I_ByG_C(groupId, categoryId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) {
        return this.shoppingCategoryPersistence.filterCountByG_P(groupId, parentCategoryId);
    }

    public ShoppingCategory getCategory(long categoryId) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        return category;
    }

    public void getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) {
        List categories = this.shoppingCategoryPersistence.filterFindByG_P(groupId, categoryId);
        for (ShoppingCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
    }

    public ShoppingCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.shoppingCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext);
    }
}

