/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchOrderItemException;
import com.liferay.shopping.model.ShoppingOrderItem;
import com.liferay.shopping.model.impl.ShoppingOrderItemImpl;
import com.liferay.shopping.model.impl.ShoppingOrderItemModelImpl;
import com.liferay.shopping.service.persistence.ShoppingOrderItemPersistence;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class ShoppingOrderItemPersistenceImpl
extends BasePersistenceImpl<ShoppingOrderItem>
implements ShoppingOrderItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOrderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOrderId", new String[]{Long.class.getName()}, 7L);
    public static final FinderPath FINDER_PATH_COUNT_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOrderId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_ORDERID_ORDERID_2 = "shoppingOrderItem.orderId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGORDERITEM = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_SELECT_SHOPPINGORDERITEM_WHERE_PKS_IN = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem WHERE orderItemId IN (";
    private static final String _SQL_SELECT_SHOPPINGORDERITEM_WHERE = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM_WHERE = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrderItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrderItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrderItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingOrderItemPersistenceImpl.class);
    private static final ShoppingOrderItem _nullShoppingOrderItem = new ShoppingOrderItemImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<ShoppingOrderItem> toCacheModel() {
            return _nullShoppingOrderItemCacheModel;
        }
    };
    private static final CacheModel<ShoppingOrderItem> _nullShoppingOrderItemCacheModel = new CacheModel<ShoppingOrderItem>(){

        public ShoppingOrderItem toEntityModel() {
            return _nullShoppingOrderItem;
        }
    };

    public List<ShoppingOrderItem> findByOrderId(long orderId) {
        return this.findByOrderId(orderId, -1, -1, null);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end) {
        return this.findByOrderId(orderId, start, end, null);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end, OrderByComparator<ShoppingOrderItem> orderByComparator) {
        return this.findByOrderId(orderId, start, end, orderByComparator, true);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end, OrderByComparator<ShoppingOrderItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID;
            finderArgs = new Object[]{orderId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ORDERID;
            finderArgs = new Object[]{orderId, start, end, orderByComparator};
        }
        List<ShoppingOrderItem> list = null;
        if (retrieveFromCache && (list = (List<ShoppingOrderItem>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingOrderItem shoppingOrderItem : list) {
                if (orderId == shoppingOrderItem.getOrderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(orderId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrderItem findByOrderId_First(long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator) throws NoSuchOrderItemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByOrderId_First(orderId, orderByComparator);
        if (shoppingOrderItem != null) {
            return shoppingOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("orderId=");
        msg.append(orderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public ShoppingOrderItem fetchByOrderId_First(long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator) {
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrderItem findByOrderId_Last(long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator) throws NoSuchOrderItemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByOrderId_Last(orderId, orderByComparator);
        if (shoppingOrderItem != null) {
            return shoppingOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("orderId=");
        msg.append(orderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public ShoppingOrderItem fetchByOrderId_Last(long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator) {
        int count = this.countByOrderId(orderId);
        if (count == 0) {
            return null;
        }
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrderItem[] findByOrderId_PrevAndNext(long orderItemId, long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator) throws NoSuchOrderItemException {
        ShoppingOrderItem shoppingOrderItem = this.findByPrimaryKey(orderItemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrderItem[] array = new ShoppingOrderItemImpl[]{this.getByOrderId_PrevAndNext(session, shoppingOrderItem, orderId, orderByComparator, true), shoppingOrderItem, this.getByOrderId_PrevAndNext(session, shoppingOrderItem, orderId, orderByComparator, false)};
            ShoppingOrderItem[] shoppingOrderItemArray = array;
            return shoppingOrderItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrderItem getByOrderId_PrevAndNext(Session session, ShoppingOrderItem shoppingOrderItem, long orderId, OrderByComparator<ShoppingOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
        query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(orderId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)shoppingOrderItem)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByOrderId(long orderId) {
        for (ShoppingOrderItem shoppingOrderItem : this.findByOrderId(orderId, -1, -1, null)) {
            this.remove((BaseModel)shoppingOrderItem);
        }
    }

    public int countByOrderId(long orderId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ORDERID;
        Object[] finderArgs = new Object[]{orderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(orderId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingOrderItemPersistenceImpl() {
        this.setModelClass(ShoppingOrderItem.class);
    }

    public void cacheResult(ShoppingOrderItem shoppingOrderItem) {
        this.entityCache.putResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Serializable)shoppingOrderItem);
        shoppingOrderItem.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingOrderItem> shoppingOrderItems) {
        for (ShoppingOrderItem shoppingOrderItem : shoppingOrderItems) {
            if (this.entityCache.getResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey())) == null) {
                this.cacheResult(shoppingOrderItem);
                continue;
            }
            shoppingOrderItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingOrderItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingOrderItem shoppingOrderItem) {
        this.entityCache.removeResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<ShoppingOrderItem> shoppingOrderItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingOrderItem shoppingOrderItem : shoppingOrderItems) {
            this.entityCache.removeResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()));
        }
    }

    public ShoppingOrderItem create(long orderItemId) {
        ShoppingOrderItemImpl shoppingOrderItem = new ShoppingOrderItemImpl();
        shoppingOrderItem.setNew(true);
        shoppingOrderItem.setPrimaryKey(orderItemId);
        shoppingOrderItem.setCompanyId(this.companyProvider.getCompanyId());
        return shoppingOrderItem;
    }

    public ShoppingOrderItem remove(long orderItemId) throws NoSuchOrderItemException {
        return this.remove(Long.valueOf(orderItemId));
    }

    public ShoppingOrderItem remove(Serializable primaryKey) throws NoSuchOrderItemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, primaryKey);
            if (shoppingOrderItem == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingOrderItem shoppingOrderItem2 = (ShoppingOrderItem)this.remove((BaseModel)shoppingOrderItem);
            return shoppingOrderItem2;
        }
        catch (NoSuchOrderItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrderItem removeImpl(ShoppingOrderItem shoppingOrderItem) {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingOrderItem)) {
                shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, shoppingOrderItem.getPrimaryKeyObj());
            }
            if (shoppingOrderItem != null) {
                session.delete((Object)shoppingOrderItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingOrderItem != null) {
            this.clearCache(shoppingOrderItem);
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem updateImpl(ShoppingOrderItem shoppingOrderItem) {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        boolean isNew = shoppingOrderItem.isNew();
        ShoppingOrderItemModelImpl shoppingOrderItemModelImpl = (ShoppingOrderItemModelImpl)shoppingOrderItem;
        Session session = null;
        try {
            session = this.openSession();
            if (shoppingOrderItem.isNew()) {
                session.save((Object)shoppingOrderItem);
                shoppingOrderItem.setNew(false);
            } else {
                shoppingOrderItem = (ShoppingOrderItem)session.merge((Object)shoppingOrderItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ShoppingOrderItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((shoppingOrderItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{shoppingOrderItemModelImpl.getOriginalOrderId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ORDERID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID, args);
            args = new Object[]{shoppingOrderItemModelImpl.getOrderId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ORDERID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID, args);
        }
        this.entityCache.putResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Serializable)shoppingOrderItem, false);
        shoppingOrderItem.resetOriginalValues();
        return shoppingOrderItem;
    }

    protected ShoppingOrderItem toUnwrappedModel(ShoppingOrderItem shoppingOrderItem) {
        if (shoppingOrderItem instanceof ShoppingOrderItemImpl) {
            return shoppingOrderItem;
        }
        ShoppingOrderItemImpl shoppingOrderItemImpl = new ShoppingOrderItemImpl();
        shoppingOrderItemImpl.setNew(shoppingOrderItem.isNew());
        shoppingOrderItemImpl.setPrimaryKey(shoppingOrderItem.getPrimaryKey());
        shoppingOrderItemImpl.setOrderItemId(shoppingOrderItem.getOrderItemId());
        shoppingOrderItemImpl.setCompanyId(shoppingOrderItem.getCompanyId());
        shoppingOrderItemImpl.setOrderId(shoppingOrderItem.getOrderId());
        shoppingOrderItemImpl.setItemId(shoppingOrderItem.getItemId());
        shoppingOrderItemImpl.setSku(shoppingOrderItem.getSku());
        shoppingOrderItemImpl.setName(shoppingOrderItem.getName());
        shoppingOrderItemImpl.setDescription(shoppingOrderItem.getDescription());
        shoppingOrderItemImpl.setProperties(shoppingOrderItem.getProperties());
        shoppingOrderItemImpl.setPrice(shoppingOrderItem.getPrice());
        shoppingOrderItemImpl.setQuantity(shoppingOrderItem.getQuantity());
        shoppingOrderItemImpl.setShippedDate(shoppingOrderItem.getShippedDate());
        return shoppingOrderItemImpl;
    }

    public ShoppingOrderItem findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderItemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByPrimaryKey(primaryKey);
        if (shoppingOrderItem == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem findByPrimaryKey(long orderItemId) throws NoSuchOrderItemException {
        return this.findByPrimaryKey(Long.valueOf(orderItemId));
    }

    public ShoppingOrderItem fetchByPrimaryKey(Serializable primaryKey) {
        ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)this.entityCache.getResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, primaryKey);
        if (shoppingOrderItem == _nullShoppingOrderItem) {
            return null;
        }
        if (shoppingOrderItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, primaryKey);
                if (shoppingOrderItem != null) {
                    this.cacheResult(shoppingOrderItem);
                } else {
                    this.entityCache.putResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, primaryKey, (Serializable)_nullShoppingOrderItem);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem fetchByPrimaryKey(long orderItemId) {
        return this.fetchByPrimaryKey(Long.valueOf(orderItemId));
    }

    public Map<Serializable, ShoppingOrderItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingOrderItem> map = new HashMap<Serializable, ShoppingOrderItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingOrderItem shoppingOrderItem = this.fetchByPrimaryKey(primaryKey);
            if (shoppingOrderItem != null) {
                map.put(primaryKey, shoppingOrderItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)this.entityCache.getResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, primaryKey);
            if (shoppingOrderItem == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, shoppingOrderItem);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE_PKS_IN);
        for (Serializable primaryKey : uncachedPrimaryKeys) {
            query.append(String.valueOf(primaryKey));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            for (ShoppingOrderItem shoppingOrderItem : q.list()) {
                map.put(shoppingOrderItem.getPrimaryKeyObj(), shoppingOrderItem);
                this.cacheResult(shoppingOrderItem);
                uncachedPrimaryKeys.remove(shoppingOrderItem.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, primaryKey, (Serializable)_nullShoppingOrderItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<ShoppingOrderItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end, OrderByComparator<ShoppingOrderItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingOrderItem> findAll(int start, int end, OrderByComparator<ShoppingOrderItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_SHOPPINGORDERITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGORDERITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingOrderItem shoppingOrderItem : this.findAll()) {
            this.remove((BaseModel)shoppingOrderItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDERITEM);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingOrderItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(ShoppingOrderItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

