/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.ShoppingItemPrice;
import com.liferay.shopping.model.impl.ShoppingCategoryImpl;
import com.liferay.shopping.model.impl.ShoppingItemBaseImpl;
import com.liferay.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.shopping.service.ShoppingItemPriceLocalServiceUtil;
import com.liferay.shopping.util.comparator.ItemNameComparator;
import java.util.List;

public class ShoppingItemImpl
extends ShoppingItemBaseImpl {
    public static final int STOCK_QUANTITY_INFINITE_STOCK = -1;
    private static final Log _log = LogFactoryUtil.getLog(ShoppingItemImpl.class);
    private String[] _fieldsQuantitiesArray;

    @Override
    public int compareTo(ShoppingItem item) {
        return new ItemNameComparator(true).compare((ShoppingItem)this, item);
    }

    public ShoppingCategory getCategory() {
        ShoppingCategoryImpl category = null;
        if (this.getCategoryId() > 0L) {
            try {
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)this.getCategoryId());
            }
            catch (Exception e) {
                category = new ShoppingCategoryImpl();
                category.setGroupId(this.getGroupId());
                _log.error((Object)"Unable to get category", (Throwable)e);
            }
        } else {
            category = new ShoppingCategoryImpl();
            category.setGroupId(this.getGroupId());
        }
        return category;
    }

    public String[] getFieldsQuantitiesArray() {
        return this._fieldsQuantitiesArray;
    }

    public List<ShoppingItemPrice> getItemPrices() throws PortalException {
        return ShoppingItemPriceLocalServiceUtil.getItemPrices((long)this.getItemId());
    }

    public String getShoppingItemImageURL(ThemeDisplay themeDisplay) {
        if (!this.isSmallImage()) {
            return null;
        }
        if (Validator.isNotNull((String)this.getSmallImageURL())) {
            return this.getSmallImageURL();
        }
        return StringBundler.concat((String[])new String[]{themeDisplay.getPathImage(), "/shopping/item?img_id=", String.valueOf(this.getSmallImageId()), "&t=", WebServerServletTokenUtil.getToken((long)this.getSmallImageId())});
    }

    public boolean isInfiniteStock() {
        return this.getStockQuantity() == -1;
    }

    @Override
    public void setFieldsQuantities(String fieldsQuantities) {
        this._fieldsQuantitiesArray = StringUtil.split((String)fieldsQuantities);
        super.setFieldsQuantities(fieldsQuantities);
    }

    public void setFieldsQuantitiesArray(String[] fieldsQuantitiesArray) {
        this._fieldsQuantitiesArray = fieldsQuantitiesArray;
        super.setFieldsQuantities(StringUtil.merge((Object[])fieldsQuantitiesArray));
    }
}

