/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.shopping.exception.CouponCodeException;
import com.liferay.shopping.exception.CouponDateException;
import com.liferay.shopping.exception.CouponDescriptionException;
import com.liferay.shopping.exception.CouponDiscountException;
import com.liferay.shopping.exception.CouponEndDateException;
import com.liferay.shopping.exception.CouponLimitCategoriesException;
import com.liferay.shopping.exception.CouponLimitSKUsException;
import com.liferay.shopping.exception.CouponMinimumOrderException;
import com.liferay.shopping.exception.CouponNameException;
import com.liferay.shopping.exception.CouponStartDateException;
import com.liferay.shopping.exception.DuplicateCouponCodeException;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingCoupon;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.service.base.ShoppingCouponLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class ShoppingCouponLocalServiceImpl
extends ShoppingCouponLocalServiceBaseImpl {
    public ShoppingCoupon addCoupon(long userId, String code, boolean autoCode, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        code = StringUtil.toUpperCase((String)StringUtil.trim((String)code));
        if (autoCode) {
            code = this.getCode();
        }
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)user.getTimeZone(), CouponStartDateException.class);
        Date endDate = null;
        if (!neverExpire) {
            endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)user.getTimeZone(), CouponEndDateException.class);
        }
        if (endDate != null && startDate.after(endDate)) {
            throw new CouponDateException();
        }
        this.validate(user.getCompanyId(), groupId, code, autoCode, name, description, limitCategories, limitSkus, minOrder, discount);
        long couponId = this.counterLocalService.increment();
        ShoppingCoupon coupon = this.shoppingCouponPersistence.create(couponId);
        coupon.setGroupId(groupId);
        coupon.setCompanyId(user.getCompanyId());
        coupon.setUserId(user.getUserId());
        coupon.setUserName(user.getFullName());
        coupon.setCode(code);
        coupon.setName(name);
        coupon.setDescription(description);
        coupon.setStartDate(startDate);
        coupon.setEndDate(endDate);
        coupon.setActive(active);
        coupon.setLimitCategories(limitCategories);
        coupon.setLimitSkus(limitSkus);
        coupon.setMinOrder(minOrder);
        coupon.setDiscount(discount);
        coupon.setDiscountType(discountType);
        this.shoppingCouponPersistence.update((BaseModel)coupon);
        return coupon;
    }

    public void deleteCoupon(long couponId) throws PortalException {
        ShoppingCoupon coupon = this.shoppingCouponPersistence.findByPrimaryKey(couponId);
        this.deleteCoupon(coupon);
    }

    public void deleteCoupon(ShoppingCoupon coupon) {
        this.shoppingCouponPersistence.remove((BaseModel)coupon);
    }

    public void deleteCoupons(long groupId) {
        List coupons = this.shoppingCouponPersistence.findByGroupId(groupId);
        for (ShoppingCoupon coupon : coupons) {
            this.deleteCoupon(coupon);
        }
    }

    public ShoppingCoupon getCoupon(long couponId) throws PortalException {
        return this.shoppingCouponPersistence.findByPrimaryKey(couponId);
    }

    public ShoppingCoupon getCoupon(String code) throws PortalException {
        code = StringUtil.toUpperCase((String)StringUtil.trim((String)code));
        return this.shoppingCouponPersistence.findByCode(code);
    }

    public List<ShoppingCoupon> search(long groupId, long companyId, String code, boolean active, String discountType, boolean andOperator, int start, int end) {
        return this.shoppingCouponFinder.findByG_C_C_A_DT(groupId, companyId, code, active, discountType, andOperator, start, end);
    }

    public int searchCount(long groupId, long companyId, String code, boolean active, String discountType, boolean andOperator) {
        return this.shoppingCouponFinder.countByG_C_C_A_DT(groupId, companyId, code, active, discountType, andOperator);
    }

    public ShoppingCoupon updateCoupon(long userId, long couponId, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        ShoppingCoupon coupon = this.shoppingCouponPersistence.findByPrimaryKey(couponId);
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)user.getTimeZone(), CouponStartDateException.class);
        Date endDate = null;
        if (!neverExpire) {
            endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)user.getTimeZone(), CouponEndDateException.class);
        }
        if (endDate != null && startDate.after(endDate)) {
            throw new CouponDateException();
        }
        this.validate(coupon.getCompanyId(), coupon.getGroupId(), name, description, limitCategories, limitSkus, minOrder, discount);
        coupon.setName(name);
        coupon.setDescription(description);
        coupon.setStartDate(startDate);
        coupon.setEndDate(endDate);
        coupon.setActive(active);
        coupon.setLimitCategories(limitCategories);
        coupon.setLimitSkus(limitSkus);
        coupon.setMinOrder(minOrder);
        coupon.setDiscount(discount);
        coupon.setDiscountType(discountType);
        this.shoppingCouponPersistence.update((BaseModel)coupon);
        return coupon;
    }

    protected String getCode() {
        String code = PwdGenerator.getPassword((int)8, (String[])new String[]{"0123456789", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"});
        ShoppingCoupon coupon = this.shoppingCouponPersistence.fetchByCode(code);
        if (coupon != null) {
            return coupon.getCode();
        }
        return code;
    }

    protected void validate(long companyId, long groupId, String code, boolean autoCode, String name, String description, String limitCategories, String limitSkus, double minOrder, double discount) throws PortalException {
        if (!autoCode) {
            if (Validator.isNull((String)code) || Validator.isNumber((String)code) || code.indexOf(44) != -1 || code.indexOf(32) != -1) {
                throw new CouponCodeException();
            }
            if (this.shoppingCouponPersistence.fetchByCode(code) != null) {
                throw new DuplicateCouponCodeException("{code=" + code + "}");
            }
        }
        this.validate(companyId, groupId, name, description, limitCategories, limitSkus, minOrder, discount);
    }

    protected void validate(long companyId, long groupId, String name, String description, String limitCategories, String limitSkus, double minOrder, double discount) throws PortalException {
        ShoppingCategory category;
        String[] categoryNames;
        if (Validator.isNull((String)name)) {
            throw new CouponNameException();
        }
        if (Validator.isNull((String)description)) {
            throw new CouponDescriptionException();
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        for (String string : categoryNames = StringUtil.split((String)limitCategories)) {
            category = this.shoppingCategoryPersistence.fetchByG_N(groupId, string);
            categoryIds.add(category.getCategoryId());
        }
        ArrayList<Long> invalidCategoryIds = new ArrayList<Long>();
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            long categoryId = (Long)iterator.next();
            category = this.shoppingCategoryPersistence.fetchByPrimaryKey(categoryId);
            if (category != null && category.getGroupId() == groupId) continue;
            invalidCategoryIds.add(categoryId);
        }
        if (!invalidCategoryIds.isEmpty()) {
            CouponLimitCategoriesException clce = new CouponLimitCategoriesException();
            clce.setCategoryIds(invalidCategoryIds);
            throw clce;
        }
        String[] skus = StringUtil.split((String)limitSkus);
        ArrayList<String> invalidSkus = new ArrayList<String>();
        for (String sku : skus) {
            ShoppingItem item = this.shoppingItemPersistence.fetchByC_S(companyId, sku);
            if (item != null) {
                ShoppingCategory category2 = item.getCategory();
                if (category2.getGroupId() == groupId) continue;
                invalidSkus.add(sku);
                continue;
            }
            invalidSkus.add(sku);
        }
        if (!invalidSkus.isEmpty()) {
            CouponLimitSKUsException couponLimitSKUsException = new CouponLimitSKUsException();
            couponLimitSKUsException.setSkus(invalidSkus);
            throw couponLimitSKUsException;
        }
        if (minOrder < 0.0) {
            throw new CouponMinimumOrderException();
        }
        if (discount < 0.0) {
            throw new CouponDiscountException();
        }
    }
}

