/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.service.ShoppingItemLocalServiceUtil;
import com.liferay.shopping.service.permission.ShoppingCategoryPermission;
import com.liferay.shopping.service.permission.ShoppingPermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.shopping.model.ShoppingItem"}, service={ShoppingItemPermission.class})
public class ShoppingItemPermission
implements BaseModelPermissionChecker {
    private static ShoppingCategoryPermission _shoppingCategoryPermission;

    public static void check(PermissionChecker permissionChecker, long itemId, String actionId) throws PortalException {
        if (!ShoppingItemPermission.contains(permissionChecker, itemId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingItem.class.getName(), itemId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, ShoppingItem item, String actionId) throws PortalException {
        if (!ShoppingItemPermission.contains(permissionChecker, item, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingItem.class.getName(), item.getItemId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long itemId, String actionId) throws PortalException {
        ShoppingItem item = ShoppingItemLocalServiceUtil.getItem((long)itemId);
        return ShoppingItemPermission.contains(permissionChecker, item, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, ShoppingItem item, String actionId) throws PortalException {
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            if (item.getCategoryId() == 0L) {
                if (!ShoppingPermission.contains(permissionChecker, item.getGroupId(), actionId)) {
                    return false;
                }
            } else {
                ShoppingCategory category = item.getCategory();
                if (!ShoppingCategoryPermission.contains(permissionChecker, category, actionId)) {
                    return false;
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(item.getCompanyId(), ShoppingItem.class.getName(), item.getItemId(), item.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(item.getGroupId(), ShoppingItem.class.getName(), item.getItemId(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        ShoppingItemPermission.check(permissionChecker, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setShoppingCategoryPermission(ShoppingCategoryPermission shoppingCategoryPermission) {
        _shoppingCategoryPermission = shoppingCategoryPermission;
    }
}

