/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"resource.name=com.liferay.shopping"}, service={ShoppingPermission.class})
public class ShoppingPermission {
    public static final String RESOURCE_NAME = "com.liferay.shopping";

    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!ShoppingPermission.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RESOURCE_NAME, groupId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        return permissionChecker.hasPermission(groupId, RESOURCE_NAME, groupId, actionId);
    }
}

