/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchItemException;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.impl.ShoppingItemImpl;
import com.liferay.shopping.model.impl.ShoppingItemModelImpl;
import com.liferay.shopping.service.persistence.ShoppingItemPersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class ShoppingItemPersistenceImpl
extends BasePersistenceImpl<ShoppingItem>
implements ShoppingItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchBySmallImageId", new String[]{Long.class.getName()}, 64L);
    public static final FinderPath FINDER_PATH_COUNT_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySmallImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2 = "shoppingItem.smallImageId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByMediumImageId", new String[]{Long.class.getName()}, 16L);
    public static final FinderPath FINDER_PATH_COUNT_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMediumImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2 = "shoppingItem.mediumImageId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByLargeImageId", new String[]{Long.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLargeImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2 = "shoppingItem.largeImageId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, 5L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "shoppingItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_CATEGORYID_2 = "shoppingItem.categoryId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_S", new String[]{Long.class.getName(), String.class.getName()}, 34L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "shoppingItem.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SKU_1 = "shoppingItem.sku IS NULL";
    private static final String _FINDER_COLUMN_C_S_SKU_2 = "shoppingItem.sku = ?";
    private static final String _FINDER_COLUMN_C_S_SKU_3 = "(shoppingItem.sku IS NULL OR shoppingItem.sku = '')";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGITEM = "SELECT shoppingItem FROM ShoppingItem shoppingItem";
    private static final String _SQL_SELECT_SHOPPINGITEM_WHERE_PKS_IN = "SELECT shoppingItem FROM ShoppingItem shoppingItem WHERE itemId IN (";
    private static final String _SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT shoppingItem FROM ShoppingItem shoppingItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGITEM = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem";
    private static final String _SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "shoppingItem.itemId";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT DISTINCT {shoppingItem.*} FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingItem.*} FROM (SELECT DISTINCT shoppingItem.itemId FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingItem ON TEMP_TABLE.itemId = ShoppingItem.itemId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(DISTINCT shoppingItem.itemId) AS COUNT_VALUE FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingItem";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingItem";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingItem.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingItemPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"fields", "featured", "sale"});

    public ShoppingItem findBySmallImageId(long smallImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchBySmallImageId(smallImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("smallImageId=");
            msg.append(smallImageId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId) {
        return this.fetchBySmallImageId(smallImageId, true);
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId, boolean retrieveFromCache) {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{smallImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingItem && smallImageId != (shoppingItem = (ShoppingItem)result).getSmallImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(smallImageId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchBySmallImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                    result = shoppingItem2;
                    this.cacheResult(shoppingItem2);
                    if (shoppingItem2.getSmallImageId() != smallImageId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, finderArgs, (Object)shoppingItem2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeBySmallImageId(long smallImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.findBySmallImageId(smallImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countBySmallImageId(long smallImageId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SMALLIMAGEID;
        Object[] finderArgs = new Object[]{smallImageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(smallImageId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItem findByMediumImageId(long mediumImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByMediumImageId(mediumImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mediumImageId=");
            msg.append(mediumImageId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId) {
        return this.fetchByMediumImageId(mediumImageId, true);
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId, boolean retrieveFromCache) {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{mediumImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingItem && mediumImageId != (shoppingItem = (ShoppingItem)result).getMediumImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(mediumImageId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchByMediumImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                    result = shoppingItem2;
                    this.cacheResult(shoppingItem2);
                    if (shoppingItem2.getMediumImageId() != mediumImageId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, finderArgs, (Object)shoppingItem2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByMediumImageId(long mediumImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.findByMediumImageId(mediumImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByMediumImageId(long mediumImageId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_MEDIUMIMAGEID;
        Object[] finderArgs = new Object[]{mediumImageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(mediumImageId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItem findByLargeImageId(long largeImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByLargeImageId(largeImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("largeImageId=");
            msg.append(largeImageId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId) {
        return this.fetchByLargeImageId(largeImageId, true);
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId, boolean retrieveFromCache) {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{largeImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingItem && largeImageId != (shoppingItem = (ShoppingItem)result).getLargeImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(largeImageId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchByLargeImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                    result = shoppingItem2;
                    this.cacheResult(shoppingItem2);
                    if (shoppingItem2.getLargeImageId() != largeImageId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, finderArgs, (Object)shoppingItem2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByLargeImageId(long largeImageId) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.findByLargeImageId(largeImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByLargeImageId(long largeImageId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LARGEIMAGEID;
        Object[] finderArgs = new Object[]{largeImageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(largeImageId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId) {
        return this.findByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end) {
        return this.findByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end, OrderByComparator<ShoppingItem> orderByComparator) {
        return this.findByG_C(groupId, categoryId, start, end, orderByComparator, true);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end, OrderByComparator<ShoppingItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C;
            finderArgs = new Object[]{groupId, categoryId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_G_C;
            finderArgs = new Object[]{groupId, categoryId, start, end, orderByComparator};
        }
        List<ShoppingItem> list = null;
        if (retrieveFromCache && (list = (List<ShoppingItem>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingItem shoppingItem : list) {
                if (groupId == shoppingItem.getGroupId() && categoryId == shoppingItem.getCategoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingItem.itemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(categoryId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingItem findByG_C_First(long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByG_C_First(groupId, categoryId, orderByComparator);
        if (shoppingItem != null) {
            return shoppingItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", categoryId=");
        msg.append(categoryId);
        msg.append("}");
        throw new NoSuchItemException(msg.toString());
    }

    public ShoppingItem fetchByG_C_First(long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) {
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingItem findByG_C_Last(long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByG_C_Last(groupId, categoryId, orderByComparator);
        if (shoppingItem != null) {
            return shoppingItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", categoryId=");
        msg.append(categoryId);
        msg.append("}");
        throw new NoSuchItemException(msg.toString());
    }

    public ShoppingItem fetchByG_C_Last(long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) {
        int count = this.countByG_C(groupId, categoryId);
        if (count == 0) {
            return null;
        }
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingItem[] findByG_C_PrevAndNext(long itemId, long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.findByPrimaryKey(itemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem[] array = new ShoppingItemImpl[]{this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, true), shoppingItem, this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, false)};
            ShoppingItem[] shoppingItemArray = array;
            return shoppingItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem getByG_C_PrevAndNext(Session session, ShoppingItem shoppingItem, long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(categoryId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)shoppingItem)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingItem)list.get(1);
        }
        return null;
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId) {
        return this.filterFindByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end) {
        return this.filterFindByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end, OrderByComparator<ShoppingItem> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_C(groupId, categoryId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        } else {
            query.append(" ORDER BY ShoppingItem.itemId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingItemImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingItemImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingItem[] filterFindByG_C_PrevAndNext(long itemId, long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator) throws NoSuchItemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_C_PrevAndNext(itemId, groupId, categoryId, orderByComparator);
        }
        ShoppingItem shoppingItem = this.findByPrimaryKey(itemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem[] array = new ShoppingItemImpl[]{this.filterGetByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, true), shoppingItem, this.filterGetByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, false)};
            ShoppingItem[] shoppingItemArray = array;
            return shoppingItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem filterGetByG_C_PrevAndNext(Session session, ShoppingItem shoppingItem, long groupId, long categoryId, OrderByComparator<ShoppingItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        } else {
            query.append(" ORDER BY ShoppingItem.itemId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingItemImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, ShoppingItemImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(categoryId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)shoppingItem)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingItem)list.get(1);
        }
        return null;
    }

    public void removeByG_C(long groupId, long categoryId) {
        for (ShoppingItem shoppingItem : this.findByG_C(groupId, categoryId, -1, -1, null)) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public int countByG_C(long groupId, long categoryId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_C;
        Object[] finderArgs = new Object[]{groupId, categoryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(categoryId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_C(long groupId, long categoryId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_C(groupId, categoryId);
        }
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingItem findByC_S(long companyId, String sku) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByC_S(companyId, sku);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", sku=");
            msg.append(sku);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByC_S(long companyId, String sku) {
        return this.fetchByC_S(companyId, sku, true);
    }

    public ShoppingItem fetchByC_S(long companyId, String sku, boolean retrieveFromCache) {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{companyId, sku};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_C_S, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingItem && (companyId != (shoppingItem = (ShoppingItem)result).getCompanyId() || !Objects.equals(sku, shoppingItem.getSku()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                bindSku = true;
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindSku) {
                    qPos.add(sku);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_S, finderArgs, (Object)list);
                } else {
                    ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                    result = shoppingItem2;
                    this.cacheResult(shoppingItem2);
                    if (shoppingItem2.getCompanyId() != companyId || shoppingItem2.getSku() == null || !shoppingItem2.getSku().equals(sku)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_S, finderArgs, (Object)shoppingItem2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_S, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByC_S(long companyId, String sku) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.findByC_S(companyId, sku);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByC_S(long companyId, String sku) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_S;
        Object[] finderArgs = new Object[]{companyId, sku};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                bindSku = true;
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (bindSku) {
                    qPos.add(sku);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItemPersistenceImpl() {
        block2: {
            this.setModelClass(ShoppingItem.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("fields", "fields_");
                dbColumnNames.put("featured", "featured_");
                dbColumnNames.put("sale", "sale_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(ShoppingItem shoppingItem) {
        this.entityCache.putResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Serializable)shoppingItem);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, new Object[]{shoppingItem.getSmallImageId()}, (Object)shoppingItem);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, new Object[]{shoppingItem.getMediumImageId()}, (Object)shoppingItem);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, new Object[]{shoppingItem.getLargeImageId()}, (Object)shoppingItem);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_S, new Object[]{shoppingItem.getCompanyId(), shoppingItem.getSku()}, (Object)shoppingItem);
        shoppingItem.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingItem> shoppingItems) {
        for (ShoppingItem shoppingItem : shoppingItems) {
            if (this.entityCache.getResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey())) == null) {
                this.cacheResult(shoppingItem);
                continue;
            }
            shoppingItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingItem shoppingItem) {
        this.entityCache.removeResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ShoppingItemModelImpl)shoppingItem, true);
    }

    public void clearCache(List<ShoppingItem> shoppingItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingItem shoppingItem : shoppingItems) {
            this.entityCache.removeResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
            this.clearUniqueFindersCache((ShoppingItemModelImpl)shoppingItem, true);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingItemModelImpl shoppingItemModelImpl) {
        Object[] args = new Object[]{shoppingItemModelImpl.getSmallImageId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_SMALLIMAGEID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, args, (Object)shoppingItemModelImpl, false);
        args = new Object[]{shoppingItemModelImpl.getMediumImageId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, args, (Object)shoppingItemModelImpl, false);
        args = new Object[]{shoppingItemModelImpl.getLargeImageId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_LARGEIMAGEID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, args, (Object)shoppingItemModelImpl, false);
        args = new Object[]{shoppingItemModelImpl.getCompanyId(), shoppingItemModelImpl.getSku()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_S, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_S, args, (Object)shoppingItemModelImpl, false);
    }

    protected void clearUniqueFindersCache(ShoppingItemModelImpl shoppingItemModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{shoppingItemModelImpl.getSmallImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SMALLIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, args);
        }
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_SMALLIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalSmallImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SMALLIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_SMALLIMAGEID, args);
        }
        if (clearCurrent) {
            args = new Object[]{shoppingItemModelImpl.getMediumImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, args);
        }
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MEDIUMIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalMediumImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, args);
        }
        if (clearCurrent) {
            args = new Object[]{shoppingItemModelImpl.getLargeImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_LARGEIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, args);
        }
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LARGEIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalLargeImageId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_LARGEIMAGEID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LARGEIMAGEID, args);
        }
        if (clearCurrent) {
            args = new Object[]{shoppingItemModelImpl.getCompanyId(), shoppingItemModelImpl.getSku()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_S, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_S, args);
        }
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_S.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalCompanyId(), shoppingItemModelImpl.getOriginalSku()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_S, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_S, args);
        }
    }

    public ShoppingItem create(long itemId) {
        ShoppingItemImpl shoppingItem = new ShoppingItemImpl();
        shoppingItem.setNew(true);
        shoppingItem.setPrimaryKey(itemId);
        shoppingItem.setCompanyId(this.companyProvider.getCompanyId());
        return shoppingItem;
    }

    public ShoppingItem remove(long itemId) throws NoSuchItemException {
        return this.remove(Long.valueOf(itemId));
    }

    public ShoppingItem remove(Serializable primaryKey) throws NoSuchItemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, primaryKey);
            if (shoppingItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingItem shoppingItem2 = (ShoppingItem)this.remove((BaseModel)shoppingItem);
            return shoppingItem2;
        }
        catch (NoSuchItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem removeImpl(ShoppingItem shoppingItem) {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingItem)) {
                shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, shoppingItem.getPrimaryKeyObj());
            }
            if (shoppingItem != null) {
                session.delete((Object)shoppingItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingItem != null) {
            this.clearCache(shoppingItem);
        }
        return shoppingItem;
    }

    public ShoppingItem updateImpl(ShoppingItem shoppingItem) {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        boolean isNew = shoppingItem.isNew();
        ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && shoppingItem.getCreateDate() == null) {
            if (serviceContext == null) {
                shoppingItem.setCreateDate(now);
            } else {
                shoppingItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!shoppingItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                shoppingItem.setModifiedDate(now);
            } else {
                shoppingItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (shoppingItem.isNew()) {
                session.save((Object)shoppingItem);
                shoppingItem.setNew(false);
            } else {
                shoppingItem = (ShoppingItem)session.merge((Object)shoppingItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ShoppingItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{shoppingItemModelImpl.getGroupId(), shoppingItemModelImpl.getCategoryId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_C, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{shoppingItemModelImpl.getOriginalGroupId(), shoppingItemModelImpl.getOriginalCategoryId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_C, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C, args);
            args = new Object[]{shoppingItemModelImpl.getGroupId(), shoppingItemModelImpl.getCategoryId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_C, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C, args);
        }
        this.entityCache.putResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Serializable)shoppingItem, false);
        this.clearUniqueFindersCache(shoppingItemModelImpl, false);
        this.cacheUniqueFindersCache(shoppingItemModelImpl);
        shoppingItem.resetOriginalValues();
        return shoppingItem;
    }

    protected ShoppingItem toUnwrappedModel(ShoppingItem shoppingItem) {
        if (shoppingItem instanceof ShoppingItemImpl) {
            return shoppingItem;
        }
        ShoppingItemImpl shoppingItemImpl = new ShoppingItemImpl();
        shoppingItemImpl.setNew(shoppingItem.isNew());
        shoppingItemImpl.setPrimaryKey(shoppingItem.getPrimaryKey());
        shoppingItemImpl.setItemId(shoppingItem.getItemId());
        shoppingItemImpl.setGroupId(shoppingItem.getGroupId());
        shoppingItemImpl.setCompanyId(shoppingItem.getCompanyId());
        shoppingItemImpl.setUserId(shoppingItem.getUserId());
        shoppingItemImpl.setUserName(shoppingItem.getUserName());
        shoppingItemImpl.setCreateDate(shoppingItem.getCreateDate());
        shoppingItemImpl.setModifiedDate(shoppingItem.getModifiedDate());
        shoppingItemImpl.setCategoryId(shoppingItem.getCategoryId());
        shoppingItemImpl.setSku(shoppingItem.getSku());
        shoppingItemImpl.setName(shoppingItem.getName());
        shoppingItemImpl.setDescription(shoppingItem.getDescription());
        shoppingItemImpl.setProperties(shoppingItem.getProperties());
        shoppingItemImpl.setFields(shoppingItem.isFields());
        shoppingItemImpl.setFieldsQuantities(shoppingItem.getFieldsQuantities());
        shoppingItemImpl.setMinQuantity(shoppingItem.getMinQuantity());
        shoppingItemImpl.setMaxQuantity(shoppingItem.getMaxQuantity());
        shoppingItemImpl.setPrice(shoppingItem.getPrice());
        shoppingItemImpl.setDiscount(shoppingItem.getDiscount());
        shoppingItemImpl.setTaxable(shoppingItem.isTaxable());
        shoppingItemImpl.setShipping(shoppingItem.getShipping());
        shoppingItemImpl.setUseShippingFormula(shoppingItem.isUseShippingFormula());
        shoppingItemImpl.setRequiresShipping(shoppingItem.isRequiresShipping());
        shoppingItemImpl.setStockQuantity(shoppingItem.getStockQuantity());
        shoppingItemImpl.setFeatured(shoppingItem.isFeatured());
        shoppingItemImpl.setSale(shoppingItem.isSale());
        shoppingItemImpl.setSmallImage(shoppingItem.isSmallImage());
        shoppingItemImpl.setSmallImageId(shoppingItem.getSmallImageId());
        shoppingItemImpl.setSmallImageURL(shoppingItem.getSmallImageURL());
        shoppingItemImpl.setMediumImage(shoppingItem.isMediumImage());
        shoppingItemImpl.setMediumImageId(shoppingItem.getMediumImageId());
        shoppingItemImpl.setMediumImageURL(shoppingItem.getMediumImageURL());
        shoppingItemImpl.setLargeImage(shoppingItem.isLargeImage());
        shoppingItemImpl.setLargeImageId(shoppingItem.getLargeImageId());
        shoppingItemImpl.setLargeImageURL(shoppingItem.getLargeImageURL());
        return shoppingItemImpl;
    }

    public ShoppingItem findByPrimaryKey(Serializable primaryKey) throws NoSuchItemException {
        ShoppingItem shoppingItem = this.fetchByPrimaryKey(primaryKey);
        if (shoppingItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingItem;
    }

    public ShoppingItem findByPrimaryKey(long itemId) throws NoSuchItemException {
        return this.findByPrimaryKey(Long.valueOf(itemId));
    }

    public ShoppingItem fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ShoppingItem shoppingItem = (ShoppingItem)serializable;
        if (shoppingItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, primaryKey);
                if (shoppingItem != null) {
                    this.cacheResult(shoppingItem);
                } else {
                    this.entityCache.putResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByPrimaryKey(long itemId) {
        return this.fetchByPrimaryKey(Long.valueOf(itemId));
    }

    public Map<Serializable, ShoppingItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingItem> map = new HashMap<Serializable, ShoppingItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingItem shoppingItem = this.fetchByPrimaryKey(primaryKey);
            if (shoppingItem != null) {
                map.put(primaryKey, shoppingItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (ShoppingItem)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_SHOPPINGITEM_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (ShoppingItem shoppingItem : q.list()) {
                map.put(shoppingItem.getPrimaryKeyObj(), shoppingItem);
                this.cacheResult(shoppingItem);
                uncachedPrimaryKeys.remove(shoppingItem.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<ShoppingItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingItem> findAll(int start, int end, OrderByComparator<ShoppingItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingItem> findAll(int start, int end, OrderByComparator<ShoppingItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_SHOPPINGITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingItem.itemId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingItem shoppingItem : this.findAll()) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGITEM);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(ShoppingItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

