/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.shopping.configuration.ShoppingGroupServiceOverriddenConfiguration;
import com.liferay.shopping.exception.NoSuchCartException;
import com.liferay.shopping.model.ShoppingCart;
import com.liferay.shopping.model.ShoppingCartItem;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingCoupon;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.ShoppingItemField;
import com.liferay.shopping.model.ShoppingItemPrice;
import com.liferay.shopping.model.ShoppingOrder;
import com.liferay.shopping.model.ShoppingOrderItem;
import com.liferay.shopping.model.impl.ShoppingCartImpl;
import com.liferay.shopping.service.ShoppingCartLocalServiceUtil;
import com.liferay.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.shopping.service.ShoppingOrderItemLocalServiceUtil;
import com.liferay.shopping.service.persistence.ShoppingItemPriceUtil;
import com.liferay.shopping.util.comparator.ItemMinQuantityComparator;
import com.liferay.shopping.util.comparator.ItemNameComparator;
import com.liferay.shopping.util.comparator.ItemPriceComparator;
import com.liferay.shopping.util.comparator.ItemSKUComparator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class ShoppingUtil {
    public static double calculateActualPrice(ShoppingItem item) {
        return item.getPrice() - ShoppingUtil.calculateDiscountPrice(item);
    }

    public static double calculateActualPrice(ShoppingItem item, int count) throws PortalException {
        return ShoppingUtil.calculatePrice(item, count) - ShoppingUtil.calculateDiscountPrice(item, count);
    }

    public static double calculateActualPrice(ShoppingItemPrice itemPrice) {
        return itemPrice.getPrice() - ShoppingUtil.calculateDiscountPrice(itemPrice);
    }

    public static double calculateActualSubtotal(List<ShoppingOrderItem> orderItems) {
        double subtotal = 0.0;
        for (ShoppingOrderItem orderItem : orderItems) {
            subtotal += orderItem.getPrice() * (double)orderItem.getQuantity();
        }
        return subtotal;
    }

    public static double calculateActualSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException {
        return ShoppingUtil.calculateSubtotal(items) - ShoppingUtil.calculateDiscountSubtotal(items);
    }

    public static double calculateAlternativeShipping(Map<ShoppingCartItem, Integer> items, int altShipping) throws PortalException {
        double shipping;
        double alternativeShipping = shipping = ShoppingUtil.calculateShipping(items);
        ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            ShoppingItem item = cartItem.getItem();
            if (shoppingGroupServiceOverriddenConfiguration != null) continue;
            ShoppingCategory category = item.getCategory();
            shoppingGroupServiceOverriddenConfiguration = ShoppingUtil._getShoppingGroupServiceOverriddenConfiguration(category.getGroupId());
            break;
        }
        if (shoppingGroupServiceOverriddenConfiguration != null && shoppingGroupServiceOverriddenConfiguration.useAlternativeShipping() && shipping > 0.0) {
            double altShippingDelta = 0.0;
            try {
                altShippingDelta = GetterUtil.getDouble((String)shoppingGroupServiceOverriddenConfiguration.getAlternativeShipping()[1][altShipping]);
            }
            catch (Exception e) {
                return alternativeShipping;
            }
            if (altShippingDelta > 0.0) {
                alternativeShipping = shipping * altShippingDelta;
            }
        }
        return alternativeShipping;
    }

    public static double calculateCouponDiscount(Map<ShoppingCartItem, Integer> items, ShoppingCoupon coupon) throws PortalException {
        return ShoppingUtil.calculateCouponDiscount(items, null, coupon);
    }

    /*
     * WARNING - void declaration
     */
    public static double calculateCouponDiscount(Map<ShoppingCartItem, Integer> items, String stateId, ShoppingCoupon coupon) throws PortalException {
        double discount = 0.0;
        if (coupon == null || !coupon.isActive() || !coupon.hasValidDateRange()) {
            return discount;
        }
        String[] categoryNames = StringUtil.split((String)coupon.getLimitCategories());
        HashSet<Long> categoryIds = new HashSet<Long>();
        for (String categoryName : categoryNames) {
            ShoppingCategory shoppingCategory = ShoppingCategoryLocalServiceUtil.getCategory((long)coupon.getGroupId(), (String)categoryName);
            ArrayList subcategoryIds = new ArrayList();
            ShoppingCategoryLocalServiceUtil.getSubcategoryIds(subcategoryIds, (long)shoppingCategory.getGroupId(), (long)shoppingCategory.getCategoryId());
            categoryIds.add(shoppingCategory.getCategoryId());
            categoryIds.addAll(subcategoryIds);
        }
        String[] skus = StringUtil.split((String)coupon.getLimitSkus());
        if (!categoryIds.isEmpty() || skus.length > 0) {
            void var11_16;
            HashSet<String> skusSet = new HashSet<String>();
            String[] stringArray = skus;
            int categoryName = stringArray.length;
            boolean bl = false;
            while (var11_16 < categoryName) {
                String sku = stringArray[var11_16];
                skusSet.add(sku);
                ++var11_16;
            }
            HashMap<ShoppingCartItem, Integer> newItems = new HashMap<ShoppingCartItem, Integer>();
            for (Map.Entry entry : items.entrySet()) {
                ShoppingCartItem cartItem = (ShoppingCartItem)entry.getKey();
                Integer count = (Integer)entry.getValue();
                ShoppingItem item = cartItem.getItem();
                if ((categoryIds.isEmpty() || !categoryIds.contains(item.getCategoryId())) && (skusSet.isEmpty() || !skusSet.contains(item.getSku()))) continue;
                newItems.put(cartItem, count);
            }
            items = newItems;
        }
        double actualSubtotal = ShoppingUtil.calculateActualSubtotal(items);
        if (coupon.getMinOrder() > 0.0 && coupon.getMinOrder() > actualSubtotal) {
            return discount;
        }
        String type = coupon.getDiscountType();
        if (type.equals("percentage")) {
            discount = actualSubtotal * coupon.getDiscount();
        } else if (type.equals("actual")) {
            discount = coupon.getDiscount();
        } else if (type.equals("free-shipping")) {
            discount = ShoppingUtil.calculateShipping(items);
        } else if (type.equals("tax-free") && stateId != null) {
            discount = ShoppingUtil.calculateTax(items, stateId);
        }
        return discount;
    }

    public static double calculateDiscountPercent(Map<ShoppingCartItem, Integer> items) throws PortalException {
        double discount = ShoppingUtil.calculateDiscountSubtotal(items) / ShoppingUtil.calculateSubtotal(items);
        if (Double.isNaN(discount) || Double.isInfinite(discount)) {
            discount = 0.0;
        }
        return discount;
    }

    public static double calculateDiscountPrice(ShoppingItem item) {
        return item.getPrice() * item.getDiscount();
    }

    public static double calculateDiscountPrice(ShoppingItem item, int count) throws PortalException {
        ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
        return itemPrice.getPrice() * itemPrice.getDiscount() * (double)count;
    }

    public static double calculateDiscountPrice(ShoppingItemPrice itemPrice) {
        return itemPrice.getPrice() * itemPrice.getDiscount();
    }

    public static double calculateDiscountSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException {
        double subtotal = 0.0;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            subtotal += ShoppingUtil.calculateDiscountPrice(item, count);
        }
        return subtotal;
    }

    public static double calculateInsurance(Map<ShoppingCartItem, Integer> items) throws PortalException {
        double insurance = 0.0;
        double subtotal = 0.0;
        ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (shoppingGroupServiceOverriddenConfiguration == null) {
                ShoppingCategory category = item.getCategory();
                shoppingGroupServiceOverriddenConfiguration = ShoppingUtil._getShoppingGroupServiceOverriddenConfiguration(category.getGroupId());
            }
            ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
            subtotal += ShoppingUtil.calculateActualPrice(itemPrice) * (double)count.intValue();
        }
        if (shoppingGroupServiceOverriddenConfiguration == null || subtotal == 0.0) {
            return insurance;
        }
        double insuranceRate = 0.0;
        double[] range = ShoppingGroupServiceOverriddenConfiguration.INSURANCE_RANGE;
        for (int i = 0; i < range.length - 1; ++i) {
            String[] insurances;
            if (!(subtotal > range[i]) || !(subtotal <= range[i + 1])) continue;
            int rangeId = i / 2;
            if (MathUtil.isOdd((int)i)) {
                rangeId = (i + 1) / 2;
            }
            if ((insurances = shoppingGroupServiceOverriddenConfiguration.getInsurance()).length < rangeId) continue;
            insuranceRate = GetterUtil.getDouble((String)insurances[rangeId]);
        }
        String formula = shoppingGroupServiceOverriddenConfiguration.getInsuranceFormula();
        if (formula.equals("flat")) {
            insurance += insuranceRate;
        } else if (formula.equals("percentage")) {
            insurance += subtotal * insuranceRate;
        }
        return insurance;
    }

    public static double calculatePrice(ShoppingItem item, int count) throws PortalException {
        ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
        return itemPrice.getPrice() * (double)count;
    }

    public static double calculateShipping(Map<ShoppingCartItem, Integer> items) throws PortalException {
        double shipping = 0.0;
        double subtotal = 0.0;
        ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (shoppingGroupServiceOverriddenConfiguration == null) {
                ShoppingCategory category = item.getCategory();
                shoppingGroupServiceOverriddenConfiguration = ShoppingUtil._getShoppingGroupServiceOverriddenConfiguration(category.getGroupId());
            }
            if (!item.isRequiresShipping()) continue;
            ShoppingItemPrice itemPrice = ShoppingUtil._getItemPrice(item, count);
            if (itemPrice.isUseShippingFormula()) {
                subtotal += ShoppingUtil.calculateActualPrice(itemPrice) * (double)count.intValue();
                continue;
            }
            shipping += itemPrice.getShipping() * (double)count.intValue();
        }
        if (shoppingGroupServiceOverriddenConfiguration == null || subtotal == 0.0) {
            return shipping;
        }
        double shippingRate = 0.0;
        double[] range = ShoppingGroupServiceOverriddenConfiguration.SHIPPING_RANGE;
        for (int i = 0; i < range.length - 1; ++i) {
            if (!(subtotal > range[i]) || !(subtotal <= range[i + 1])) continue;
            int rangeId = i / 2;
            if (MathUtil.isOdd((int)i)) {
                rangeId = (i + 1) / 2;
            }
            shippingRate = GetterUtil.getDouble((String)shoppingGroupServiceOverriddenConfiguration.getShipping()[rangeId]);
        }
        String formula = shoppingGroupServiceOverriddenConfiguration.getShippingFormula();
        if (formula.equals("flat")) {
            shipping += shippingRate;
        } else if (formula.equals("percentage")) {
            shipping += subtotal * shippingRate;
        }
        return shipping;
    }

    public static double calculateSubtotal(Map<ShoppingCartItem, Integer> items) throws PortalException {
        double subtotal = 0.0;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            subtotal += ShoppingUtil.calculatePrice(item, count);
        }
        return subtotal;
    }

    public static double calculateTax(Map<ShoppingCartItem, Integer> items, String stateId) throws PortalException {
        double tax = 0.0;
        ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration = null;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            ShoppingItem item = cartItem.getItem();
            if (shoppingGroupServiceOverriddenConfiguration != null) continue;
            ShoppingCategory category = item.getCategory();
            shoppingGroupServiceOverriddenConfiguration = ShoppingUtil._getShoppingGroupServiceOverriddenConfiguration(category.getGroupId());
            break;
        }
        if (shoppingGroupServiceOverriddenConfiguration == null) {
            return tax;
        }
        String taxState = shoppingGroupServiceOverriddenConfiguration.getTaxState();
        if (!taxState.equals(stateId)) {
            return tax;
        }
        double subtotal = 0.0;
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (!item.isTaxable()) continue;
            subtotal += ShoppingUtil.calculatePrice(item, count);
        }
        return shoppingGroupServiceOverriddenConfiguration.getTaxRate() * subtotal;
    }

    public static double calculateTotal(Map<ShoppingCartItem, Integer> items, String stateId, ShoppingCoupon coupon, int altShipping, boolean insure) throws PortalException {
        double couponDiscount;
        double total;
        double actualSubtotal = ShoppingUtil.calculateActualSubtotal(items);
        double tax = ShoppingUtil.calculateTax(items, stateId);
        double shipping = ShoppingUtil.calculateAlternativeShipping(items, altShipping);
        double insurance = 0.0;
        if (insure) {
            insurance = ShoppingUtil.calculateInsurance(items);
        }
        if ((total = actualSubtotal + tax + shipping + insurance - (couponDiscount = ShoppingUtil.calculateCouponDiscount(items, stateId, coupon))) < 0.0) {
            total = 0.0;
        }
        return total;
    }

    public static double calculateTotal(ShoppingOrder order) {
        List orderItems = ShoppingOrderItemLocalServiceUtil.getOrderItems((long)order.getOrderId());
        double total = ShoppingUtil.calculateActualSubtotal(orderItems) + order.getTax() + order.getShipping() + order.getInsurance() - order.getCouponDiscount();
        if (total < 0.0) {
            total = 0.0;
        }
        return total;
    }

    public static String getBreadcrumbs(long categoryId, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ShoppingCategory category = null;
        try {
            category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ShoppingUtil.getBreadcrumbs(category, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(ShoppingCategory category, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        PortletURL categoriesURL = renderResponse.createRenderURL();
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
            categoriesURL.setParameter("struts_action", "/shopping/select_category");
            categoriesURL.setWindowState(LiferayWindowState.POP_UP);
        } else {
            categoriesURL.setParameter("struts_action", "/shopping/view");
            categoriesURL.setParameter("tabs1", "categories");
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        String categoriesLink = StringBundler.concat((String[])new String[]{"<a href=\"", categoriesURL.toString(), "\">", LanguageUtil.get((HttpServletRequest)request, (String)"categories"), "</a>"});
        if (category == null) {
            return "<span class=\"first last\">" + categoriesLink + "</span>";
        }
        String breadcrumbs = "";
        if (category != null) {
            int i = 0;
            while (true) {
                category = category.toEscapedModel();
                PortletURL portletURL = renderResponse.createRenderURL();
                if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    portletURL.setParameter("struts_action", "/shopping/select_category");
                    portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
                    portletURL.setWindowState(LiferayWindowState.POP_UP);
                } else {
                    portletURL.setParameter("struts_action", "/shopping/view");
                    portletURL.setParameter("tabs1", "categories");
                    portletURL.setParameter("categoryId", String.valueOf(category.getCategoryId()));
                }
                String categoryLink = StringBundler.concat((String[])new String[]{"<a href=\"", portletURL.toString(), "\">", category.getName(), "</a>"});
                breadcrumbs = i == 0 ? "<span class=\"last\">" + categoryLink + "</span>" : categoryLink + " &raquo; " + breadcrumbs;
                if (category.isRoot()) break;
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)category.getParentCategoryId());
                ++i;
            }
        }
        breadcrumbs = StringBundler.concat((String[])new String[]{"<span class=\"first\">", categoriesLink, " &raquo; </span>", breadcrumbs});
        return breadcrumbs;
    }

    public static ShoppingCart getCart(PortletRequest portletRequest) throws PortalException {
        PortletSession portletSession = portletRequest.getPortletSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String sessionCartId = ShoppingCart.class.getName() + themeDisplay.getScopeGroupId();
        if (themeDisplay.isSignedIn()) {
            ShoppingCart cart = (ShoppingCart)portletSession.getAttribute(sessionCartId);
            if (cart != null) {
                portletSession.removeAttribute(sessionCartId);
            }
            if (cart != null && cart.getItemsSize() > 0) {
                cart = ShoppingCartLocalServiceUtil.updateCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
            } else {
                try {
                    cart = ShoppingCartLocalServiceUtil.getCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId());
                }
                catch (NoSuchCartException nsce) {
                    cart = ShoppingUtil.getCart(themeDisplay);
                    cart = ShoppingCartLocalServiceUtil.updateCart((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
                }
            }
            return cart;
        }
        ShoppingCart cart = (ShoppingCart)portletSession.getAttribute(sessionCartId);
        if (cart == null) {
            cart = ShoppingUtil.getCart(themeDisplay);
            portletSession.setAttribute(sessionCartId, (Object)cart);
        }
        return cart;
    }

    public static ShoppingCart getCart(ThemeDisplay themeDisplay) {
        ShoppingCartImpl cart = new ShoppingCartImpl();
        cart.setGroupId(themeDisplay.getScopeGroupId());
        cart.setCompanyId(themeDisplay.getCompanyId());
        cart.setUserId(themeDisplay.getUserId());
        cart.setItemIds("");
        cart.setCouponCodes("");
        cart.setAltShipping(0);
        cart.setInsure(false);
        return cart;
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        definitionTerms.put("[$ORDER_BILLING_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-order-billing-address"));
        definitionTerms.put("[$ORDER_CURRENCY$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-order-currency"));
        definitionTerms.put("[$ORDER_NUMBER$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-order-id"));
        definitionTerms.put("[$ORDER_SHIPPING_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-order-shipping-address"));
        definitionTerms.put("[$ORDER_TOTAL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-order-total"));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static int getFieldsQuantitiesPos(ShoppingItem item, ShoppingItemField[] itemFields, String[] fieldsArray) {
        HashSet<String> fieldsValues = new HashSet<String>();
        for (String fields : fieldsArray) {
            int pos = fields.indexOf("=");
            String fieldValue = fields.substring(pos + 1);
            fieldsValues.add(fieldValue.trim());
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> values = new ArrayList<String[]>();
        for (int i = 0; i < itemFields.length; ++i) {
            names.add(itemFields[i].getName());
            values.add(StringUtil.split((String)itemFields[i].getValues()));
        }
        int numOfRows = 1;
        for (String[] vArray : values) {
            numOfRows *= vArray.length;
        }
        int rowPos = 0;
        for (int i = 0; i < numOfRows; ++i) {
            boolean match = true;
            for (int j = 0; j < names.size(); ++j) {
                int numOfRepeats = 1;
                for (int k = j + 1; k < values.size(); ++k) {
                    String[] vArray = (String[])values.get(k);
                    numOfRepeats *= vArray.length;
                }
                String[] vArray = (String[])values.get(j);
                int arrayPos = 0;
                for (arrayPos = i / numOfRepeats; arrayPos >= vArray.length; arrayPos -= vArray.length) {
                }
                if (fieldsValues.contains(vArray[arrayPos].trim())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            rowPos = i;
            break;
        }
        return rowPos;
    }

    public static String getItemFields(String itemId) {
        int pos = itemId.indexOf(124);
        if (pos == -1) {
            return "";
        }
        return itemId.substring(pos + 1);
    }

    public static long getItemId(String itemId) {
        int pos = itemId.indexOf(124);
        if (pos != -1) {
            itemId = itemId.substring(0, pos);
        }
        return GetterUtil.getLong((String)itemId);
    }

    public static OrderByComparator<ShoppingItem> getItemOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ItemMinQuantityComparator orderByComparator = null;
        if (orderByCol.equals("min-qty")) {
            orderByComparator = new ItemMinQuantityComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new ItemNameComparator(orderByAsc);
        } else if (orderByCol.equals("price")) {
            orderByComparator = new ItemPriceComparator(orderByAsc);
        } else if (orderByCol.equals("sku")) {
            orderByComparator = new ItemSKUComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static int getMinQuantity(ShoppingItem item) throws PortalException {
        int minQuantity = item.getMinQuantity();
        List itemPrices = item.getItemPrices();
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (minQuantity <= itemPrice.getMinQuantity()) continue;
            minQuantity = itemPrice.getMinQuantity();
        }
        return minQuantity;
    }

    public static String getPayPalNotifyURL(ThemeDisplay themeDisplay) {
        return themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/shopping/notify";
    }

    public static String getPayPalRedirectURL(ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration, ShoppingOrder order, double total, String returnURL, String notifyURL) {
        String payPalEmailAddress = URLCodec.encodeURL((String)shoppingGroupServiceOverriddenConfiguration.getPayPalEmailAddress());
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(LocaleUtil.ENGLISH);
        doubleFormat.setMaximumFractionDigits(2);
        doubleFormat.setMinimumFractionDigits(2);
        String amount = doubleFormat.format(total);
        returnURL = URLCodec.encodeURL((String)returnURL);
        notifyURL = URLCodec.encodeURL((String)notifyURL);
        String firstName = URLCodec.encodeURL((String)order.getBillingFirstName());
        String lastName = URLCodec.encodeURL((String)order.getBillingLastName());
        String address1 = URLCodec.encodeURL((String)order.getBillingStreet());
        String city = URLCodec.encodeURL((String)order.getBillingCity());
        String state = URLCodec.encodeURL((String)order.getBillingState());
        String zip = URLCodec.encodeURL((String)order.getBillingZip());
        String currencyCode = shoppingGroupServiceOverriddenConfiguration.getCurrencyId();
        StringBundler sb = new StringBundler(29);
        sb.append("https://www.paypal.com/cgi-bin/webscr?cmd=_xclick&");
        sb.append("business=");
        sb.append(payPalEmailAddress);
        sb.append("&item_name=");
        sb.append(order.getNumber());
        sb.append("&item_number=");
        sb.append(order.getNumber());
        sb.append("&invoice=");
        sb.append(order.getNumber());
        sb.append("&amount=");
        sb.append(amount);
        sb.append("&return=");
        sb.append(returnURL);
        sb.append("&notify_url=");
        sb.append(notifyURL);
        sb.append("&first_name=");
        sb.append(firstName);
        sb.append("&last_name=");
        sb.append(lastName);
        sb.append("&address1=");
        sb.append(address1);
        sb.append("&city=");
        sb.append(city);
        sb.append("&state=");
        sb.append(state);
        sb.append("&zip=");
        sb.append(zip);
        sb.append("&no_note=1&currency_code=");
        sb.append(currencyCode);
        return sb.toString();
    }

    public static String getPayPalReturnURL(PortletURL portletURL, ShoppingOrder order) {
        portletURL.setParameter("struts_action", "/shopping/checkout");
        portletURL.setParameter("cmd", "view");
        portletURL.setParameter("orderId", String.valueOf(order.getOrderId()));
        return portletURL.toString();
    }

    public static String getPpPaymentStatus(ShoppingOrder order, HttpServletRequest request) {
        String ppPaymentStatus = order.getPpPaymentStatus();
        ppPaymentStatus = ppPaymentStatus.equals("LIFERAY_STATUS_CHECKOUT") ? "checkout" : StringUtil.toLowerCase((String)ppPaymentStatus);
        return LanguageUtil.get((HttpServletRequest)request, (String)HtmlUtil.escape((String)ppPaymentStatus));
    }

    public static String getPpPaymentStatus(String ppPaymentStatus) {
        if (ppPaymentStatus == null || ppPaymentStatus.length() < 2 || ppPaymentStatus.equals("checkout")) {
            return "LIFERAY_STATUS_CHECKOUT";
        }
        return Character.toUpperCase(ppPaymentStatus.charAt(0)) + ppPaymentStatus.substring(1);
    }

    public static boolean isInStock(ShoppingItem item) {
        if (item.isInfiniteStock()) {
            return true;
        }
        if (!item.isFields()) {
            return item.getStockQuantity() > 0;
        }
        String[] fieldsQuantities = item.getFieldsQuantitiesArray();
        for (int i = 0; i < fieldsQuantities.length; ++i) {
            if (GetterUtil.getInteger((String)fieldsQuantities[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isInStock(ShoppingItem item, ShoppingItemField[] itemFields, String[] fieldsArray, Integer orderedQuantity) {
        if (item.isInfiniteStock()) {
            return true;
        }
        if (!item.isFields()) {
            int stockQuantity = item.getStockQuantity();
            return stockQuantity > 0 && stockQuantity >= orderedQuantity;
        }
        String[] fieldsQuantities = item.getFieldsQuantitiesArray();
        int stockQuantity = 0;
        if (fieldsQuantities.length > 0) {
            int rowPos = ShoppingUtil.getFieldsQuantitiesPos(item, itemFields, fieldsArray);
            stockQuantity = GetterUtil.getInteger((String)fieldsQuantities[rowPos]);
        }
        try {
            if (stockQuantity > 0 && stockQuantity >= orderedQuantity) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean meetsMinOrder(ShoppingGroupServiceOverriddenConfiguration shoppingGroupServiceOverriddenConfiguration, Map<ShoppingCartItem, Integer> items) throws PortalException {
        return !(shoppingGroupServiceOverriddenConfiguration.getMinOrder() > 0.0) || !(ShoppingUtil.calculateSubtotal(items) < shoppingGroupServiceOverriddenConfiguration.getMinOrder());
    }

    private static ShoppingItemPrice _getItemPrice(ShoppingItem item, int count) throws PortalException {
        ShoppingItemPrice itemPrice = null;
        List itemPrices = item.getItemPrices();
        for (ShoppingItemPrice temp : itemPrices) {
            int minQty = temp.getMinQuantity();
            int maxQty = temp.getMaxQuantity();
            if (temp.getStatus() == 0) continue;
            if (count >= minQty && (count <= maxQty || maxQty == 0)) {
                return temp;
            }
            if (count <= maxQty || itemPrice != null && itemPrice.getMaxQuantity() >= maxQty) continue;
            itemPrice = temp;
        }
        if (itemPrice == null) {
            return ShoppingItemPriceUtil.create((long)0L);
        }
        return itemPrice;
    }

    private static ShoppingGroupServiceOverriddenConfiguration _getShoppingGroupServiceOverriddenConfiguration(long groupId) throws ConfigurationException {
        return (ShoppingGroupServiceOverriddenConfiguration)ConfigurationProviderUtil.getConfiguration(ShoppingGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.portlet.shopping"));
    }
}

