/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.shopping.service.ShoppingCartLocalService;
import com.liferay.shopping.service.ShoppingCategoryLocalService;
import com.liferay.shopping.service.ShoppingCouponLocalService;
import com.liferay.shopping.service.ShoppingOrderLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class GroupModelListener
extends BaseModelListener<Group> {
    private ShoppingCartLocalService _shoppingCartLocalService;
    private ShoppingCategoryLocalService _shoppingCategoryLocalService;
    private ShoppingCouponLocalService _shoppingCouponLocalService;
    private ShoppingOrderLocalService _shoppingOrderLocalService;

    public void onAfterRemove(Group group) throws ModelListenerException {
        try {
            this._shoppingCartLocalService.deleteGroupCarts(group.getGroupId());
            this._shoppingCategoryLocalService.deleteCategories(group.getGroupId());
            this._shoppingCouponLocalService.deleteCoupons(group.getGroupId());
            this._shoppingOrderLocalService.deleteOrders(group.getGroupId());
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setShoppingCartLocalService(ShoppingCartLocalService shoppingCartLocalService) {
        this._shoppingCartLocalService = shoppingCartLocalService;
    }

    @Reference(unbind="-")
    protected void setShoppingCategoryLocalService(ShoppingCategoryLocalService shoppingCategoryLocalService) {
        this._shoppingCategoryLocalService = shoppingCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setShoppingCouponLocalService(ShoppingCouponLocalService shoppingCouponLocalService) {
        this._shoppingCouponLocalService = shoppingCouponLocalService;
    }

    @Reference(unbind="-")
    protected void setShoppingOrderLocalService(ShoppingOrderLocalService shoppingOrderLocalService) {
        this._shoppingOrderLocalService = shoppingOrderLocalService;
    }
}

