/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.shopping.service.permission.ShoppingPermission;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"model.class.name=com.liferay.shopping.model.ShoppingCategory"}, service={ShoppingCategoryPermission.class})
public class ShoppingCategoryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (!ShoppingCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingCategory.class.getName(), categoryId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) throws PortalException {
        if (!ShoppingCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingCategory.class.getName(), category.getCategoryId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (categoryId == 0L) {
            return ShoppingPermission.contains(permissionChecker, groupId, actionId);
        }
        ShoppingCategory category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
        return ShoppingCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) throws PortalException {
        if (actionId.equals("ADD_CATEGORY")) {
            actionId = "ADD_SUBCATEGORY";
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            long categoryId = category.getCategoryId();
            while (categoryId != 0L) {
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (!ShoppingCategoryPermission._hasPermission(permissionChecker, category, actionId)) {
                    return false;
                }
                categoryId = category.getParentCategoryId();
            }
            return ShoppingPermission.contains(permissionChecker, category.getGroupId(), actionId);
        }
        return ShoppingCategoryPermission._hasPermission(permissionChecker, category, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        ShoppingCategoryPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, ShoppingCategory category, String actionId) {
        return permissionChecker.hasOwnerPermission(category.getCompanyId(), ShoppingCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) || permissionChecker.hasPermission(category.getGroupId(), ShoppingCategory.class.getName(), category.getCategoryId(), actionId);
    }
}

