/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchCartException;
import com.liferay.shopping.model.ShoppingCart;
import com.liferay.shopping.model.impl.ShoppingCartImpl;
import com.liferay.shopping.model.impl.ShoppingCartModelImpl;
import com.liferay.shopping.service.persistence.ShoppingCartPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class ShoppingCartPersistenceImpl
extends BasePersistenceImpl<ShoppingCart>
implements ShoppingCartPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingCartImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingCart.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "shoppingCart.userId = ?";
    private FinderPath _finderPathFetchByG_U;
    private FinderPath _finderPathCountByG_U;
    private static final String _FINDER_COLUMN_G_U_GROUPID_2 = "shoppingCart.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_USERID_2 = "shoppingCart.userId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGCART = "SELECT shoppingCart FROM ShoppingCart shoppingCart";
    private static final String _SQL_SELECT_SHOPPINGCART_WHERE_PKS_IN = "SELECT shoppingCart FROM ShoppingCart shoppingCart WHERE cartId IN (";
    private static final String _SQL_SELECT_SHOPPINGCART_WHERE = "SELECT shoppingCart FROM ShoppingCart shoppingCart WHERE ";
    private static final String _SQL_COUNT_SHOPPINGCART = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart";
    private static final String _SQL_COUNT_SHOPPINGCART_WHERE = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingCart.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingCart exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingCart exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingCartPersistenceImpl.class);

    public List<ShoppingCart> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByGroupId;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<ShoppingCart> list = null;
        if (retrieveFromCache && (list = (List<ShoppingCart>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (groupId == shoppingCart.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByGroupId_First(long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByGroupId_First(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByGroupId_First(long groupId, OrderByComparator<ShoppingCart> orderByComparator) {
        List<ShoppingCart> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByGroupId_Last(long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByGroupId_Last(long groupId, OrderByComparator<ShoppingCart> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCart> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByGroupId_PrevAndNext(long cartId, long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, true), shoppingCart, this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByGroupId_PrevAndNext(Session session, ShoppingCart shoppingCart, long groupId, OrderByComparator<ShoppingCart> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCart)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (ShoppingCart shoppingCart : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingCart> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUserId;
            finderArgs = new Object[]{userId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List<ShoppingCart> list = null;
        if (retrieveFromCache && (list = (List<ShoppingCart>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (userId == shoppingCart.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append("shoppingCart.userId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByUserId_First(long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByUserId_First(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByUserId_First(long userId, OrderByComparator<ShoppingCart> orderByComparator) {
        List<ShoppingCart> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByUserId_Last(long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByUserId_Last(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByUserId_Last(long userId, OrderByComparator<ShoppingCart> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCart> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByUserId_PrevAndNext(long cartId, long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, true), shoppingCart, this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByUserId_PrevAndNext(Session session, ShoppingCart shoppingCart, long userId, OrderByComparator<ShoppingCart> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        query.append("shoppingCart.userId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCart)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (ShoppingCart shoppingCart : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCart findByG_U(long groupId, long userId) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByG_U(groupId, userId);
        if (shoppingCart == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchCartException(msg.toString());
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByG_U(long groupId, long userId) {
        return this.fetchByG_U(groupId, userId, true);
    }

    public ShoppingCart fetchByG_U(long groupId, long userId, boolean retrieveFromCache) {
        ShoppingCart shoppingCart;
        Object[] finderArgs = new Object[]{groupId, userId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_U, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingCart && (groupId != (shoppingCart = (ShoppingCart)result).getGroupId() || userId != shoppingCart.getUserId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByG_U, finderArgs, (Object)list);
                } else {
                    ShoppingCart shoppingCart2 = (ShoppingCart)list.get(0);
                    result = shoppingCart2;
                    this.cacheResult(shoppingCart2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByG_U, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingCart)result;
    }

    public ShoppingCart removeByG_U(long groupId, long userId) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByG_U(groupId, userId);
        return (ShoppingCart)this.remove((BaseModel)shoppingCart);
    }

    public int countByG_U(long groupId, long userId) {
        FinderPath finderPath = this._finderPathCountByG_U;
        Object[] finderArgs = new Object[]{groupId, userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCartPersistenceImpl() {
        this.setModelClass(ShoppingCart.class);
    }

    public void cacheResult(ShoppingCart shoppingCart) {
        this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart);
        this.finderCache.putResult(this._finderPathFetchByG_U, new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()}, (Object)shoppingCart);
        shoppingCart.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingCart> shoppingCarts) {
        for (ShoppingCart shoppingCart : shoppingCarts) {
            if (this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey())) == null) {
                this.cacheResult(shoppingCart);
                continue;
            }
            shoppingCart.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingCartImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingCart shoppingCart) {
        this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ShoppingCartModelImpl)shoppingCart, true);
    }

    public void clearCache(List<ShoppingCart> shoppingCarts) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingCart shoppingCart : shoppingCarts) {
            this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
            this.clearUniqueFindersCache((ShoppingCartModelImpl)shoppingCart, true);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingCartModelImpl shoppingCartModelImpl) {
        Object[] args = new Object[]{shoppingCartModelImpl.getGroupId(), shoppingCartModelImpl.getUserId()};
        this.finderCache.putResult(this._finderPathCountByG_U, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_U, args, (Object)shoppingCartModelImpl, false);
    }

    protected void clearUniqueFindersCache(ShoppingCartModelImpl shoppingCartModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{shoppingCartModelImpl.getGroupId(), shoppingCartModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByG_U, args);
            this.finderCache.removeResult(this._finderPathFetchByG_U, args);
        }
        if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathFetchByG_U.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingCartModelImpl.getOriginalGroupId(), shoppingCartModelImpl.getOriginalUserId()};
            this.finderCache.removeResult(this._finderPathCountByG_U, args);
            this.finderCache.removeResult(this._finderPathFetchByG_U, args);
        }
    }

    public ShoppingCart create(long cartId) {
        ShoppingCartImpl shoppingCart = new ShoppingCartImpl();
        shoppingCart.setNew(true);
        shoppingCart.setPrimaryKey(cartId);
        shoppingCart.setCompanyId(this.companyProvider.getCompanyId());
        return shoppingCart;
    }

    public ShoppingCart remove(long cartId) throws NoSuchCartException {
        return this.remove(Long.valueOf(cartId));
    }

    public ShoppingCart remove(Serializable primaryKey) throws NoSuchCartException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
            if (shoppingCart == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingCart shoppingCart2 = (ShoppingCart)this.remove((BaseModel)shoppingCart);
            return shoppingCart2;
        }
        catch (NoSuchCartException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart removeImpl(ShoppingCart shoppingCart) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingCart)) {
                shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, shoppingCart.getPrimaryKeyObj());
            }
            if (shoppingCart != null) {
                session.delete((Object)shoppingCart);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingCart != null) {
            this.clearCache(shoppingCart);
        }
        return shoppingCart;
    }

    public ShoppingCart updateImpl(ShoppingCart shoppingCart) {
        boolean isNew = shoppingCart.isNew();
        if (!(shoppingCart instanceof ShoppingCartModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(shoppingCart.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)shoppingCart);
                throw new IllegalArgumentException("Implement ModelWrapper in shoppingCart proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ShoppingCart implementation " + shoppingCart.getClass());
        }
        ShoppingCartModelImpl shoppingCartModelImpl = (ShoppingCartModelImpl)shoppingCart;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && shoppingCart.getCreateDate() == null) {
            if (serviceContext == null) {
                shoppingCart.setCreateDate(now);
            } else {
                shoppingCart.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!shoppingCartModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                shoppingCart.setModifiedDate(now);
            } else {
                shoppingCart.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (shoppingCart.isNew()) {
                session.save((Object)shoppingCart);
                shoppingCart.setNew(false);
            } else {
                shoppingCart = (ShoppingCart)session.merge((Object)shoppingCart);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ShoppingCartModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{shoppingCartModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{shoppingCartModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{shoppingCartModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{shoppingCartModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
        }
        this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart, false);
        this.clearUniqueFindersCache(shoppingCartModelImpl, false);
        this.cacheUniqueFindersCache(shoppingCartModelImpl);
        shoppingCart.resetOriginalValues();
        return shoppingCart;
    }

    public ShoppingCart findByPrimaryKey(Serializable primaryKey) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByPrimaryKey(primaryKey);
        if (shoppingCart == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingCart;
    }

    public ShoppingCart findByPrimaryKey(long cartId) throws NoSuchCartException {
        return this.findByPrimaryKey(Long.valueOf(cartId));
    }

    public ShoppingCart fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ShoppingCart shoppingCart = (ShoppingCart)serializable;
        if (shoppingCart == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
                if (shoppingCart != null) {
                    this.cacheResult(shoppingCart);
                } else {
                    this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByPrimaryKey(long cartId) {
        return this.fetchByPrimaryKey(Long.valueOf(cartId));
    }

    public Map<Serializable, ShoppingCart> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingCart> map = new HashMap<Serializable, ShoppingCart>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingCart shoppingCart = this.fetchByPrimaryKey(primaryKey);
            if (shoppingCart != null) {
                map.put(primaryKey, shoppingCart);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (ShoppingCart)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_SHOPPINGCART_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (ShoppingCart shoppingCart : q.list()) {
                map.put(shoppingCart.getPrimaryKeyObj(), shoppingCart);
                this.cacheResult(shoppingCart);
                uncachedPrimaryKeys.remove(shoppingCart.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<ShoppingCart> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingCart> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingCart> findAll(int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findAll(int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_SHOPPINGCART);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGCART;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingCart.cartId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingCart shoppingCart : this.findAll()) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_SHOPPINGCART);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingCartModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathFetchByG_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_U", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByG_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_U", new String[]{Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(ShoppingCartImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

