/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingCategorySoap;
import com.liferay.shopping.service.ShoppingCategoryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

public class ShoppingCategoryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(ShoppingCategoryServiceSoap.class);

    public static ShoppingCategorySoap addCategory(long parentCategoryId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            ShoppingCategory returnValue = ShoppingCategoryServiceUtil.addCategory((long)parentCategoryId, (String)name, (String)description, (ServiceContext)serviceContext);
            return ShoppingCategorySoap.toSoapModel((ShoppingCategory)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteCategory(long categoryId) throws RemoteException {
        try {
            ShoppingCategoryServiceUtil.deleteCategory((long)categoryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingCategorySoap[] getCategories(long groupId) throws RemoteException {
        try {
            List returnValue = ShoppingCategoryServiceUtil.getCategories((long)groupId);
            return ShoppingCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingCategorySoap[] getCategories(long groupId, long parentCategoryId, int start, int end) throws RemoteException {
        try {
            List returnValue = ShoppingCategoryServiceUtil.getCategories((long)groupId, (long)parentCategoryId, (int)start, (int)end);
            return ShoppingCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCategoriesAndItemsCount(long groupId, long categoryId) throws RemoteException {
        try {
            int returnValue = ShoppingCategoryServiceUtil.getCategoriesAndItemsCount((long)groupId, (long)categoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCategoriesCount(long groupId, long parentCategoryId) throws RemoteException {
        try {
            int returnValue = ShoppingCategoryServiceUtil.getCategoriesCount((long)groupId, (long)parentCategoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingCategorySoap getCategory(long categoryId) throws RemoteException {
        try {
            ShoppingCategory returnValue = ShoppingCategoryServiceUtil.getCategory((long)categoryId);
            return ShoppingCategorySoap.toSoapModel((ShoppingCategory)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void getSubcategoryIds(Long[] categoryIds, long groupId, long categoryId) throws RemoteException {
        try {
            ShoppingCategoryServiceUtil.getSubcategoryIds((List)ListUtil.toList((Object[])categoryIds), (long)groupId, (long)categoryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingCategorySoap updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws RemoteException {
        try {
            ShoppingCategory returnValue = ShoppingCategoryServiceUtil.updateCategory((long)categoryId, (long)parentCategoryId, (String)name, (String)description, (boolean)mergeWithParentCategory, (ServiceContext)serviceContext);
            return ShoppingCategorySoap.toSoapModel((ShoppingCategory)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

