/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.shopping.exception.CartMinQuantityException;
import com.liferay.shopping.exception.CouponActiveException;
import com.liferay.shopping.exception.CouponEndDateException;
import com.liferay.shopping.exception.CouponStartDateException;
import com.liferay.shopping.exception.NoSuchCouponException;
import com.liferay.shopping.model.ShoppingCart;
import com.liferay.shopping.model.ShoppingCartItem;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingCoupon;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.impl.ShoppingCartItemImpl;
import com.liferay.shopping.service.base.ShoppingCartLocalServiceBaseImpl;
import com.liferay.shopping.util.ShoppingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ShoppingCartLocalServiceImpl
extends ShoppingCartLocalServiceBaseImpl {
    public void deleteGroupCarts(long groupId) {
        List carts = this.shoppingCartPersistence.findByGroupId(groupId);
        for (ShoppingCart cart : carts) {
            this.deleteShoppingCart(cart);
        }
    }

    public void deleteUserCarts(long userId) {
        List shoppingCarts = this.shoppingCartPersistence.findByUserId(userId);
        for (ShoppingCart shoppingCart : shoppingCarts) {
            this.deleteShoppingCart(shoppingCart);
        }
    }

    public ShoppingCart getCart(long userId, long groupId) throws PortalException {
        return this.shoppingCartPersistence.findByG_U(groupId, userId);
    }

    public Map<ShoppingCartItem, Integer> getItems(long groupId, String itemIds) {
        String[] itemIdsArray;
        TreeMap<ShoppingCartItem, Integer> items = new TreeMap<ShoppingCartItem, Integer>();
        for (String curItemId : itemIdsArray = StringUtil.split((String)itemIds)) {
            ShoppingCategory category;
            long itemId = ShoppingUtil.getItemId(curItemId);
            String fields = ShoppingUtil.getItemFields(curItemId);
            ShoppingItem item = this.shoppingItemPersistence.fetchByPrimaryKey(itemId);
            if (item == null || (category = item.getCategory()).getGroupId() != groupId) continue;
            ShoppingCartItemImpl cartItem = new ShoppingCartItemImpl(item, fields);
            Integer count = (Integer)items.get(cartItem);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            items.put(cartItem, count);
        }
        return items;
    }

    public ShoppingCart updateCart(long userId, long groupId, String itemIds, String couponCodes, int altShipping, boolean insure) throws PortalException {
        ArrayList<Long> badItemIds = new ArrayList<Long>();
        Map<ShoppingCartItem, Integer> items = this.getItems(groupId, itemIds);
        boolean minQtyMultiple = GetterUtil.getBoolean((String)PropsUtil.get((String)"shopping.cart.min.qty.multiple"));
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            int minQuantity = ShoppingUtil.getMinQuantity(item);
            if (minQuantity <= 0) continue;
            if (minQtyMultiple) {
                if (count % minQuantity <= 0) continue;
                badItemIds.add(item.getItemId());
                continue;
            }
            if (count >= minQuantity) continue;
            badItemIds.add(item.getItemId());
        }
        if (!badItemIds.isEmpty()) {
            throw new CartMinQuantityException(StringUtil.merge((Object[])badItemIds.toArray(new Long[0])));
        }
        int count = 0;
        String[] couponCodesArray = StringUtil.split((String)couponCodes);
        String[] stringArray = couponCodesArray;
        int cartItem = stringArray.length;
        if (count < cartItem) {
            String couponCode = stringArray[count];
            try {
                ShoppingCoupon coupon = this.shoppingCouponPersistence.findByCode(couponCode);
                if (coupon.getGroupId() != groupId) {
                    throw new NoSuchCouponException(couponCode);
                }
                if (!coupon.isActive()) {
                    throw new CouponActiveException(couponCode);
                }
                if (!coupon.hasValidStartDate()) {
                    throw new CouponStartDateException(couponCode);
                }
                if (!coupon.hasValidEndDate()) {
                    throw new CouponEndDateException(couponCode);
                }
            }
            catch (NoSuchCouponException nsce) {
                throw new NoSuchCouponException(couponCode, (Throwable)nsce);
            }
        }
        User user = this.userLocalService.getUser(userId);
        ShoppingCart cart = null;
        if (user.isDefaultUser()) {
            cart = this.shoppingCartPersistence.create(0L);
            cart.setGroupId(groupId);
            cart.setCompanyId(user.getCompanyId());
            cart.setUserId(userId);
            cart.setUserName(user.getFullName());
        } else {
            cart = this.shoppingCartPersistence.fetchByG_U(groupId, userId);
            if (cart == null) {
                long cartId = this.counterLocalService.increment();
                cart = this.shoppingCartPersistence.create(cartId);
                cart.setGroupId(groupId);
                cart.setCompanyId(user.getCompanyId());
                cart.setUserId(userId);
                cart.setUserName(user.getFullName());
            }
        }
        cart.setItemIds(this.checkItemIds(groupId, itemIds));
        cart.setCouponCodes(couponCodes);
        cart.setAltShipping(altShipping);
        cart.setInsure(insure);
        if (!user.isDefaultUser()) {
            this.shoppingCartPersistence.update((BaseModel)cart);
        }
        return cart;
    }

    protected String checkItemIds(long groupId, String itemIds) {
        String[] itemIdsArray;
        for (String curItemId : itemIdsArray = StringUtil.split((String)itemIds)) {
            long itemId = ShoppingUtil.getItemId(curItemId);
            ShoppingItem item = null;
            try {
                item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
                ShoppingCategory category = item.getCategory();
                if (category.getGroupId() != groupId) {
                    item = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (item != null) continue;
            itemIds = StringUtil.removeFromList((String)itemIds, (String)curItemId);
        }
        return itemIds;
    }
}

