/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.shopping.exception.CategoryNameException;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.service.base.ShoppingCategoryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@OSGiBeanProperties(property={"model.class.name=com.liferay.shopping.model.ShoppingItem"})
public class ShoppingCategoryLocalServiceImpl
extends ShoppingCategoryLocalServiceBaseImpl {
    public ShoppingCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        Date now = new Date();
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        ShoppingCategory category = this.shoppingCategoryPersistence.create(categoryId);
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(now);
        category.setModifiedDate(now);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.shoppingCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getModelPermissions());
        }
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, ModelPermissions modelPermissions) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, modelPermissions);
    }

    public void addCategoryResources(ShoppingCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), ShoppingCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(ShoppingCategory category, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), ShoppingCategory.class.getName(), category.getCategoryId(), modelPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException {
        List categories = this.shoppingCategoryPersistence.findByGroupId(groupId);
        for (ShoppingCategory category : categories) {
            this.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        this.deleteCategory(category);
    }

    public void deleteCategory(ShoppingCategory category) throws PortalException {
        List categories = this.shoppingCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (ShoppingCategory curCategory : categories) {
            this.deleteCategory(curCategory);
        }
        this.shoppingCategoryPersistence.remove((BaseModel)category);
        this.resourceLocalService.deleteResource(category.getCompanyId(), ShoppingCategory.class.getName(), 4, category.getCategoryId());
        this.shoppingItemLocalService.deleteItems(category.getGroupId(), category.getCategoryId());
    }

    public List<ShoppingCategory> getCategories(long groupId) {
        return this.shoppingCategoryPersistence.findByGroupId(groupId);
    }

    public List<ShoppingCategory> getCategories(long groupId, long parentCategoryId, int start, int end) {
        return this.shoppingCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) {
        return this.shoppingCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public ShoppingCategory getCategory(long categoryId) throws PortalException {
        return this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public ShoppingCategory getCategory(long groupId, String categoryName) {
        return this.shoppingCategoryPersistence.fetchByG_N(groupId, categoryName);
    }

    public List<ShoppingCategory> getParentCategories(long categoryId) throws PortalException {
        return this.getParentCategories(this.shoppingCategoryPersistence.findByPrimaryKey(categoryId));
    }

    public List<ShoppingCategory> getParentCategories(ShoppingCategory category) throws PortalException {
        ArrayList<ShoppingCategory> parentCategories = new ArrayList<ShoppingCategory>();
        ShoppingCategory tempCategory = category;
        while (true) {
            parentCategories.add(tempCategory);
            if (tempCategory.getParentCategoryId() == 0L) break;
            tempCategory = this.shoppingCategoryPersistence.findByPrimaryKey(tempCategory.getParentCategoryId());
        }
        Collections.reverse(parentCategories);
        return parentCategories;
    }

    public ShoppingCategory getParentCategory(ShoppingCategory category) throws PortalException {
        return this.shoppingCategoryPersistence.findByPrimaryKey(category.getParentCategoryId());
    }

    public void getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) {
        List categories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId);
        for (ShoppingCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
    }

    public ShoppingCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        ShoppingCategory category = this.shoppingCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        this.validate(name);
        category.setModifiedDate(new Date());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.shoppingCategoryPersistence.update((BaseModel)category);
        return category;
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) {
        ShoppingCategory parentCategory;
        if (parentCategoryId != 0L && ((parentCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(ShoppingCategory category, long parentCategoryId) {
        if (parentCategoryId == 0L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        ShoppingCategory parentCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(ShoppingCategory fromCategory, long toCategoryId) throws PortalException {
        List categories = this.shoppingCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (ShoppingCategory category : categories) {
            this.mergeCategories(category, toCategoryId);
        }
        List items = this.shoppingItemPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (ShoppingItem item : items) {
            item.setCategoryId(toCategoryId);
            this.shoppingItemPersistence.update((BaseModel)item);
        }
        this.deleteCategory(fromCategory);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.contains("\\\\") || name.contains("//")) {
            throw new CategoryNameException();
        }
    }
}

