/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.shopping.exception.DuplicateItemFieldNameException;
import com.liferay.shopping.exception.DuplicateItemSKUException;
import com.liferay.shopping.exception.ItemLargeImageNameException;
import com.liferay.shopping.exception.ItemLargeImageSizeException;
import com.liferay.shopping.exception.ItemMediumImageNameException;
import com.liferay.shopping.exception.ItemMediumImageSizeException;
import com.liferay.shopping.exception.ItemNameException;
import com.liferay.shopping.exception.ItemSKUException;
import com.liferay.shopping.exception.ItemSmallImageNameException;
import com.liferay.shopping.exception.ItemSmallImageSizeException;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.ShoppingItem;
import com.liferay.shopping.model.ShoppingItemField;
import com.liferay.shopping.model.ShoppingItemPrice;
import com.liferay.shopping.service.base.ShoppingItemLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ShoppingItemLocalServiceImpl
extends ShoppingItemLocalServiceBaseImpl {
    public ShoppingItem addItem(long userId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallImageFile, boolean mediumImage, String mediumImageURL, File mediumImageFile, boolean largeImage, String largeImageURL, File largeImageFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        sku = StringUtil.toUpperCase((String)StringUtil.trim((String)sku));
        byte[] smallImageBytes = null;
        byte[] mediumImageBytes = null;
        byte[] largeImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            mediumImageBytes = FileUtil.getBytes((File)mediumImageFile);
            largeImageBytes = FileUtil.getBytes((File)largeImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Date now = new Date();
        this.validate(user.getCompanyId(), 0L, sku, name, smallImage, smallImageURL, smallImageFile, smallImageBytes, mediumImage, mediumImageURL, mediumImageFile, mediumImageBytes, largeImage, largeImageURL, largeImageFile, largeImageBytes, itemFields);
        long itemId = this.counterLocalService.increment();
        ShoppingItem item = this.shoppingItemPersistence.create(itemId);
        item.setGroupId(groupId);
        item.setCompanyId(user.getCompanyId());
        item.setUserId(user.getUserId());
        item.setUserName(user.getFullName());
        item.setCreateDate(now);
        item.setModifiedDate(now);
        item.setCategoryId(categoryId);
        item.setSku(sku);
        item.setName(name);
        item.setDescription(description);
        item.setProperties(properties);
        item.setFields(!itemFields.isEmpty());
        item.setFieldsQuantities(fieldsQuantities);
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (itemPrice.getStatus() == 1) {
                item.setMinQuantity(itemPrice.getMinQuantity());
                item.setMaxQuantity(itemPrice.getMaxQuantity());
                item.setPrice(itemPrice.getPrice());
                item.setDiscount(itemPrice.getDiscount());
                item.setTaxable(itemPrice.isTaxable());
                item.setShipping(itemPrice.getShipping());
                item.setUseShippingFormula(itemPrice.isUseShippingFormula());
            }
            if (sale != null || !(itemPrice.getDiscount() > 0.0) || itemPrice.getStatus() != 1 && itemPrice.getStatus() != 2) continue;
            sale = Boolean.TRUE;
        }
        item.setRequiresShipping(requiresShipping);
        item.setStockQuantity(stockQuantity);
        item.setFeatured(featured);
        item.setSale(sale != null ? sale : false);
        item.setSmallImage(smallImage);
        item.setSmallImageId(this.counterLocalService.increment());
        item.setSmallImageURL(smallImageURL);
        item.setMediumImage(mediumImage);
        item.setMediumImageId(this.counterLocalService.increment());
        item.setMediumImageURL(mediumImageURL);
        item.setLargeImage(largeImage);
        item.setLargeImageId(this.counterLocalService.increment());
        item.setLargeImageURL(largeImageURL);
        this.shoppingItemPersistence.update((BaseModel)item);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addItemResources(item, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addItemResources(item, serviceContext.getModelPermissions());
        }
        this.saveImages(smallImage, item.getSmallImageId(), smallImageFile, smallImageBytes, mediumImage, item.getMediumImageId(), mediumImageFile, mediumImageBytes, largeImage, item.getLargeImageId(), largeImageFile, largeImageBytes);
        for (ShoppingItemField itemField : itemFields) {
            long itemFieldId = this.counterLocalService.increment();
            itemField.setItemFieldId(itemFieldId);
            itemField.setItemId(itemId);
            itemField.setName(this.checkItemField(itemField.getName()));
            itemField.setValues(this.checkItemField(itemField.getValues()));
            this.shoppingItemFieldPersistence.update((BaseModel)itemField);
        }
        if (itemPrices.size() > 1) {
            for (ShoppingItemPrice itemPrice : itemPrices) {
                long itemPriceId = this.counterLocalService.increment();
                itemPrice.setItemPriceId(itemPriceId);
                itemPrice.setItemId(itemId);
                this.shoppingItemPricePersistence.update((BaseModel)itemPrice);
            }
        }
        return item;
    }

    public void addItemResources(long itemId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.addItemResources(item, addGroupPermissions, addGuestPermissions);
    }

    public void addItemResources(long itemId, ModelPermissions modelPermissions) throws PortalException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.addItemResources(item, modelPermissions);
    }

    public void addItemResources(ShoppingItem item, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(item.getCompanyId(), item.getGroupId(), item.getUserId(), ShoppingItem.class.getName(), item.getItemId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addItemResources(ShoppingItem item, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(item.getCompanyId(), item.getGroupId(), item.getUserId(), ShoppingItem.class.getName(), item.getItemId(), modelPermissions);
    }

    public void deleteItem(long itemId) throws PortalException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        this.deleteItem(item);
    }

    public void deleteItem(ShoppingItem item) throws PortalException {
        this.shoppingItemPersistence.remove((BaseModel)item);
        this.resourceLocalService.deleteResource(item.getCompanyId(), ShoppingItem.class.getName(), 4, item.getItemId());
        this.imageLocalService.deleteImage(item.getSmallImageId());
        this.imageLocalService.deleteImage(item.getMediumImageId());
        this.imageLocalService.deleteImage(item.getLargeImageId());
        this.shoppingItemFieldPersistence.removeByItemId(item.getItemId());
        this.shoppingItemPricePersistence.removeByItemId(item.getItemId());
    }

    public void deleteItems(long groupId, long categoryId) throws PortalException {
        List items = this.shoppingItemPersistence.findByG_C(groupId, categoryId);
        for (ShoppingItem item : items) {
            this.deleteItem(item);
        }
    }

    public int getCategoriesItemsCount(long groupId, List<Long> categoryIds) {
        return this.shoppingItemFinder.countByG_C(groupId, categoryIds);
    }

    public List<ShoppingItem> getFeaturedItems(long groupId, long categoryId, int numOfItems) {
        List childCategories;
        List featuredItems = this.shoppingItemFinder.findByFeatured(groupId, new long[]{categoryId}, numOfItems);
        if (featuredItems.isEmpty() && !(childCategories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId)).isEmpty()) {
            long[] categoryIds = new long[childCategories.size()];
            for (int i = 0; i < childCategories.size(); ++i) {
                ShoppingCategory childCategory = (ShoppingCategory)childCategories.get(i);
                categoryIds[i] = childCategory.getCategoryId();
            }
            featuredItems = this.shoppingItemFinder.findByFeatured(groupId, categoryIds, numOfItems);
        }
        return featuredItems;
    }

    public ShoppingItem getItem(long itemId) throws PortalException {
        return this.shoppingItemPersistence.findByPrimaryKey(itemId);
    }

    public ShoppingItem getItem(long companyId, String sku) throws PortalException {
        return this.shoppingItemPersistence.findByC_S(companyId, sku);
    }

    public ShoppingItem getItemByLargeImageId(long largeImageId) throws PortalException {
        return this.shoppingItemPersistence.findByLargeImageId(largeImageId);
    }

    public ShoppingItem getItemByMediumImageId(long mediumImageId) throws PortalException {
        return this.shoppingItemPersistence.findByMediumImageId(mediumImageId);
    }

    public ShoppingItem getItemBySmallImageId(long smallImageId) throws PortalException {
        return this.shoppingItemPersistence.findBySmallImageId(smallImageId);
    }

    public List<ShoppingItem> getItems(long groupId, long categoryId) {
        return this.shoppingItemPersistence.findByG_C(groupId, categoryId);
    }

    public List<ShoppingItem> getItems(long groupId, long categoryId, int start, int end, OrderByComparator<ShoppingItem> obc) {
        return this.shoppingItemPersistence.findByG_C(groupId, categoryId, start, end, obc);
    }

    public int getItemsCount(long groupId, long categoryId) {
        return this.shoppingItemPersistence.countByG_C(groupId, categoryId);
    }

    public ShoppingItem[] getItemsPrevAndNext(long itemId, OrderByComparator<ShoppingItem> obc) throws PortalException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        return this.shoppingItemPersistence.findByG_C_PrevAndNext(item.getItemId(), item.getGroupId(), item.getCategoryId(), obc);
    }

    public List<ShoppingItem> getSaleItems(long groupId, long categoryId, int numOfItems) {
        List childCategories;
        List saleItems = this.shoppingItemFinder.findBySale(groupId, new long[]{categoryId}, numOfItems);
        if (saleItems.isEmpty() && !(childCategories = this.shoppingCategoryPersistence.findByG_P(groupId, categoryId)).isEmpty()) {
            long[] categoryIds = new long[childCategories.size()];
            for (int i = 0; i < childCategories.size(); ++i) {
                ShoppingCategory childCategory = (ShoppingCategory)childCategories.get(i);
                categoryIds[i] = childCategory.getCategoryId();
            }
            saleItems = this.shoppingItemFinder.findBySale(groupId, categoryIds, numOfItems);
        }
        return saleItems;
    }

    public List<ShoppingItem> search(long groupId, long[] categoryIds, String keywords, int start, int end) {
        return this.shoppingItemFinder.findByKeywords(groupId, categoryIds, keywords, start, end);
    }

    public List<ShoppingItem> search(long groupId, long[] categoryIds, String keywords, int start, int end, OrderByComparator<ShoppingItem> obc) {
        return this.shoppingItemFinder.findByKeywords(groupId, categoryIds, keywords, start, end, obc);
    }

    public int searchCount(long groupId, long[] categoryIds, String keywords) {
        return this.shoppingItemFinder.countByKeywords(groupId, categoryIds, keywords);
    }

    public int searchCount(long groupId, long[] categoryIds, String keywords, OrderByComparator<ShoppingItem> obc) {
        return this.shoppingItemFinder.countByKeywords(groupId, categoryIds, keywords, obc);
    }

    public ShoppingItem updateItem(long userId, long itemId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallImageFile, boolean mediumImage, String mediumImageURL, File mediumImageFile, boolean largeImage, String largeImageURL, File largeImageFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException {
        ShoppingItem item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
        User user = this.userLocalService.getUser(userId);
        categoryId = this.getCategory(item, categoryId);
        sku = StringUtil.toUpperCase((String)StringUtil.trim((String)sku));
        byte[] smallImageBytes = null;
        byte[] mediumImageBytes = null;
        byte[] largeImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
            mediumImageBytes = FileUtil.getBytes((File)mediumImageFile);
            largeImageBytes = FileUtil.getBytes((File)largeImageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.validate(user.getCompanyId(), itemId, sku, name, smallImage, smallImageURL, smallImageFile, smallImageBytes, mediumImage, mediumImageURL, mediumImageFile, mediumImageBytes, largeImage, largeImageURL, largeImageFile, largeImageBytes, itemFields);
        item.setModifiedDate(new Date());
        item.setCategoryId(categoryId);
        item.setSku(sku);
        item.setName(name);
        item.setDescription(description);
        item.setProperties(properties);
        item.setFields(!itemFields.isEmpty());
        item.setFieldsQuantities(fieldsQuantities);
        for (ShoppingItemPrice itemPrice : itemPrices) {
            if (itemPrice.getStatus() == 1) {
                item.setMinQuantity(itemPrice.getMinQuantity());
                item.setMaxQuantity(itemPrice.getMaxQuantity());
                item.setPrice(itemPrice.getPrice());
                item.setDiscount(itemPrice.getDiscount());
                item.setTaxable(itemPrice.isTaxable());
                item.setShipping(itemPrice.getShipping());
                item.setUseShippingFormula(itemPrice.isUseShippingFormula());
            }
            if (sale != null || !(itemPrice.getDiscount() > 0.0) || itemPrice.getStatus() != 1 && itemPrice.getStatus() != 2) continue;
            sale = Boolean.TRUE;
        }
        item.setRequiresShipping(requiresShipping);
        item.setStockQuantity(stockQuantity);
        item.setFeatured(featured);
        item.setSale(sale != null ? sale : false);
        item.setSmallImage(smallImage);
        item.setSmallImageURL(smallImageURL);
        item.setMediumImage(mediumImage);
        item.setMediumImageURL(mediumImageURL);
        item.setLargeImage(largeImage);
        item.setLargeImageURL(largeImageURL);
        this.shoppingItemPersistence.update((BaseModel)item);
        this.saveImages(smallImage, item.getSmallImageId(), smallImageFile, smallImageBytes, mediumImage, item.getMediumImageId(), mediumImageFile, mediumImageBytes, largeImage, item.getLargeImageId(), largeImageFile, largeImageBytes);
        this.shoppingItemFieldPersistence.removeByItemId(itemId);
        for (ShoppingItemField itemField : itemFields) {
            long itemFieldId = this.counterLocalService.increment();
            itemField.setItemFieldId(itemFieldId);
            itemField.setItemId(itemId);
            itemField.setName(this.checkItemField(itemField.getName()));
            itemField.setValues(this.checkItemField(itemField.getValues()));
            this.shoppingItemFieldPersistence.update((BaseModel)itemField);
        }
        this.shoppingItemPricePersistence.removeByItemId(itemId);
        if (itemPrices.size() > 1) {
            for (ShoppingItemPrice itemPrice : itemPrices) {
                long itemPriceId = this.counterLocalService.increment();
                itemPrice.setItemPriceId(itemPriceId);
                itemPrice.setItemId(itemId);
                this.shoppingItemPricePersistence.update((BaseModel)itemPrice);
            }
        }
        return item;
    }

    protected String checkItemField(String value) {
        return StringUtil.removeChars((String)value, (char[])new char[]{'&', '\'', '=', '|', '\"'});
    }

    protected long getCategory(ShoppingItem item, long categoryId) {
        ShoppingCategory newCategory;
        if (item.getCategoryId() != categoryId && categoryId != 0L && ((newCategory = this.shoppingCategoryPersistence.fetchByPrimaryKey(categoryId)) == null || item.getGroupId() != newCategory.getGroupId())) {
            categoryId = item.getCategoryId();
        }
        return categoryId;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes, boolean mediumImage, long mediumImageId, File mediumImageFile, byte[] mediumImageBytes, boolean largeImage, long largeImageId, File largeImageFile, byte[] largeImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
        if (mediumImage) {
            if (mediumImageFile != null && mediumImageBytes != null) {
                this.imageLocalService.updateImage(mediumImageId, mediumImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(mediumImageId);
        }
        if (largeImage) {
            if (largeImageFile != null && largeImageBytes != null) {
                this.imageLocalService.updateImage(largeImageId, largeImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(largeImageId);
        }
    }

    protected void validate(long companyId, long itemId, String sku, String name, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, boolean mediumImage, String mediumImageURL, File mediumImageFile, byte[] mediumImageBytes, boolean largeImage, String largeImageURL, File largeImageFile, byte[] largeImageBytes, List<ShoppingItemField> itemFields) throws PortalException {
        long largeImageMaxSize;
        if (Validator.isNull((String)sku)) {
            throw new ItemSKUException();
        }
        ShoppingItem item = this.shoppingItemPersistence.fetchByC_S(companyId, sku);
        if (item != null && item.getItemId() != itemId) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", sku=");
            sb.append(sku);
            sb.append("}");
            throw new DuplicateItemSKUException(sb.toString());
        }
        if (Validator.isNull((String)name)) {
            throw new ItemNameException();
        }
        if (!itemFields.isEmpty()) {
            ArrayList<String> itemFieldNames = new ArrayList<String>();
            ArrayList<String> duplicateItemFieldNames = new ArrayList<String>();
            StringBundler sb = new StringBundler(itemFields.size() * 2);
            for (ShoppingItemField itemField : itemFields) {
                if (itemFieldNames.contains(itemField.getName())) {
                    if (duplicateItemFieldNames.contains(itemField.getName())) continue;
                    duplicateItemFieldNames.add(itemField.getName());
                    sb.append(itemField.getName());
                    sb.append(", ");
                    continue;
                }
                itemFieldNames.add(itemField.getName());
            }
            if (!duplicateItemFieldNames.isEmpty()) {
                sb.setIndex(sb.index() - 1);
                throw new DuplicateItemFieldNameException(sb.toString());
            }
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray((String)"shopping.image.extensions", (String)",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallImageFile != null && smallImageBytes != null) {
            long smallImageMaxSize;
            String smallImageName = smallImageFile.getName();
            if (smallImageName != null) {
                boolean validSmallImageExtension = false;
                for (String imageExtension : imageExtensions) {
                    if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)smallImageName, (String)imageExtension)) continue;
                    validSmallImageExtension = true;
                    break;
                }
                if (!validSmallImageExtension) {
                    throw new ItemSmallImageNameException(smallImageName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong((String)"shopping.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
                throw new ItemSmallImageSizeException();
            }
        }
        if (mediumImage && Validator.isNull((String)mediumImageURL) && mediumImageFile != null && mediumImageBytes != null) {
            long mediumImageMaxSize;
            String mediumImageName = mediumImageFile.getName();
            if (mediumImageName != null) {
                boolean validMediumImageExtension = false;
                for (String imageExtension : imageExtensions) {
                    if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)mediumImageName, (String)imageExtension)) continue;
                    validMediumImageExtension = true;
                    break;
                }
                if (!validMediumImageExtension) {
                    throw new ItemMediumImageNameException(mediumImageName);
                }
            }
            if ((mediumImageMaxSize = PrefsPropsUtil.getLong((String)"shopping.image.medium.max.size")) > 0L && (mediumImageBytes == null || (long)mediumImageBytes.length > mediumImageMaxSize)) {
                throw new ItemMediumImageSizeException();
            }
        }
        if (!largeImage || Validator.isNotNull((String)largeImageURL) || largeImageFile == null || largeImageBytes == null) {
            return;
        }
        String largeImageName = largeImageFile.getName();
        if (largeImageName != null) {
            boolean validLargeImageExtension = false;
            for (String imageExtension : imageExtensions) {
                if (!"*".equals(imageExtension) && !StringUtil.endsWith((String)largeImageName, (String)imageExtension)) continue;
                validLargeImageExtension = true;
                break;
            }
            if (!validLargeImageExtension) {
                throw new ItemLargeImageNameException(largeImageName);
            }
        }
        if ((largeImageMaxSize = PrefsPropsUtil.getLong((String)"shopping.image.large.max.size")) > 0L && (largeImageBytes == null || (long)largeImageBytes.length > largeImageMaxSize)) {
            throw new ItemLargeImageSizeException();
        }
    }
}

