/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.shopping.model.ShoppingOrder;
import com.liferay.shopping.service.ShoppingOrderLocalServiceUtil;
import com.liferay.shopping.service.permission.ShoppingPermission;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"model.class.name=com.liferay.shopping.model.ShoppingOrder"}, service={ShoppingOrderPermission.class})
public class ShoppingOrderPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long orderId, String actionId) throws PortalException {
        if (!ShoppingOrderPermission.contains(permissionChecker, groupId, orderId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingOrder.class.getName(), orderId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, ShoppingOrder order, String actionId) throws PortalException {
        if (!ShoppingOrderPermission.contains(permissionChecker, groupId, order, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ShoppingOrder.class.getName(), order.getOrderId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long orderId, String actionId) throws PortalException {
        ShoppingOrder order = ShoppingOrderLocalServiceUtil.getOrder((long)orderId);
        return ShoppingOrderPermission.contains(permissionChecker, groupId, order, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, ShoppingOrder order, String actionId) {
        if (ShoppingPermission.contains(permissionChecker, groupId, "MANAGE_ORDERS")) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(order.getCompanyId(), ShoppingOrder.class.getName(), order.getOrderId(), order.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(order.getGroupId(), ShoppingOrder.class.getName(), order.getOrderId(), actionId);
    }
}

