/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchCartException;
import com.liferay.shopping.model.ShoppingCart;
import com.liferay.shopping.model.impl.ShoppingCartImpl;
import com.liferay.shopping.model.impl.ShoppingCartModelImpl;
import com.liferay.shopping.service.persistence.ShoppingCartPersistence;
import com.liferay.shopping.service.persistence.ShoppingCartUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShoppingCartPersistenceImpl
extends BasePersistenceImpl<ShoppingCart>
implements ShoppingCartPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingCartImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingCart.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "shoppingCart.userId = ?";
    private FinderPath _finderPathFetchByG_U;
    private FinderPath _finderPathCountByG_U;
    private static final String _FINDER_COLUMN_G_U_GROUPID_2 = "shoppingCart.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_USERID_2 = "shoppingCart.userId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGCART = "SELECT shoppingCart FROM ShoppingCart shoppingCart";
    private static final String _SQL_SELECT_SHOPPINGCART_WHERE_PKS_IN = "SELECT shoppingCart FROM ShoppingCart shoppingCart WHERE cartId IN (";
    private static final String _SQL_SELECT_SHOPPINGCART_WHERE = "SELECT shoppingCart FROM ShoppingCart shoppingCart WHERE ";
    private static final String _SQL_COUNT_SHOPPINGCART = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart";
    private static final String _SQL_COUNT_SHOPPINGCART_WHERE = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingCart.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingCart exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingCart exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingCartPersistenceImpl.class);

    public List<ShoppingCart> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (groupId == shoppingCart.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByGroupId_First(long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByGroupId_First(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchCartException(sb.toString());
    }

    public ShoppingCart fetchByGroupId_First(long groupId, OrderByComparator<ShoppingCart> orderByComparator) {
        List<ShoppingCart> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByGroupId_Last(long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchCartException(sb.toString());
    }

    public ShoppingCart fetchByGroupId_Last(long groupId, OrderByComparator<ShoppingCart> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCart> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByGroupId_PrevAndNext(long cartId, long groupId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, true), shoppingCart, this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByGroupId_PrevAndNext(Session session, ShoppingCart shoppingCart, long groupId, OrderByComparator<ShoppingCart> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCart)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (ShoppingCart shoppingCart : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingCart> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (userId == shoppingCart.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            sb.append("shoppingCart.userId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByUserId_First(long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByUserId_First(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchCartException(sb.toString());
    }

    public ShoppingCart fetchByUserId_First(long userId, OrderByComparator<ShoppingCart> orderByComparator) {
        List<ShoppingCart> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByUserId_Last(long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByUserId_Last(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchCartException(sb.toString());
    }

    public ShoppingCart fetchByUserId_Last(long userId, OrderByComparator<ShoppingCart> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCart> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByUserId_PrevAndNext(long cartId, long userId, OrderByComparator<ShoppingCart> orderByComparator) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, true), shoppingCart, this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByUserId_PrevAndNext(Session session, ShoppingCart shoppingCart, long userId, OrderByComparator<ShoppingCart> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        sb.append("shoppingCart.userId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCart)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (ShoppingCart shoppingCart : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            sb.append("shoppingCart.userId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCart findByG_U(long groupId, long userId) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByG_U(groupId, userId);
        if (shoppingCart == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", userId=");
            sb.append(userId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCartException(sb.toString());
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByG_U(long groupId, long userId) {
        return this.fetchByG_U(groupId, userId, true);
    }

    public ShoppingCart fetchByG_U(long groupId, long userId, boolean useFinderCache) {
        ShoppingCart shoppingCart;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, userId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_U, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingCart && (groupId != (shoppingCart = (ShoppingCart)result).getGroupId() || userId != shoppingCart.getUserId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            sb.append(_FINDER_COLUMN_G_U_GROUPID_2);
            sb.append("shoppingCart.userId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(userId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByG_U, finderArgs, (Object)list);
                    }
                } else {
                    ShoppingCart shoppingCart2 = (ShoppingCart)list.get(0);
                    result = shoppingCart2;
                    this.cacheResult(shoppingCart2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByG_U, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingCart)result;
    }

    public ShoppingCart removeByG_U(long groupId, long userId) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.findByG_U(groupId, userId);
        return (ShoppingCart)this.remove((BaseModel)shoppingCart);
    }

    public int countByG_U(long groupId, long userId) {
        FinderPath finderPath = this._finderPathCountByG_U;
        Object[] finderArgs = new Object[]{groupId, userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            sb.append(_FINDER_COLUMN_G_U_GROUPID_2);
            sb.append("shoppingCart.userId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCartPersistenceImpl() {
        this.setModelClass(ShoppingCart.class);
    }

    public void cacheResult(ShoppingCart shoppingCart) {
        this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart);
        this.finderCache.putResult(this._finderPathFetchByG_U, new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()}, (Object)shoppingCart);
        shoppingCart.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingCart> shoppingCarts) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && shoppingCarts.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ShoppingCart shoppingCart : shoppingCarts) {
            if (this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey())) == null) {
                this.cacheResult(shoppingCart);
                continue;
            }
            shoppingCart.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingCartImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingCart shoppingCart) {
        this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ShoppingCartModelImpl)shoppingCart, true);
    }

    public void clearCache(List<ShoppingCart> shoppingCarts) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingCart shoppingCart : shoppingCarts) {
            this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
            this.clearUniqueFindersCache((ShoppingCartModelImpl)shoppingCart, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingCartModelImpl shoppingCartModelImpl) {
        Object[] args = new Object[]{shoppingCartModelImpl.getGroupId(), shoppingCartModelImpl.getUserId()};
        this.finderCache.putResult(this._finderPathCountByG_U, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_U, args, (Object)shoppingCartModelImpl, false);
    }

    protected void clearUniqueFindersCache(ShoppingCartModelImpl shoppingCartModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{shoppingCartModelImpl.getGroupId(), shoppingCartModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByG_U, args);
            this.finderCache.removeResult(this._finderPathFetchByG_U, args);
        }
        if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathFetchByG_U.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingCartModelImpl.getOriginalGroupId(), shoppingCartModelImpl.getOriginalUserId()};
            this.finderCache.removeResult(this._finderPathCountByG_U, args);
            this.finderCache.removeResult(this._finderPathFetchByG_U, args);
        }
    }

    public ShoppingCart create(long cartId) {
        ShoppingCartImpl shoppingCart = new ShoppingCartImpl();
        shoppingCart.setNew(true);
        shoppingCart.setPrimaryKey(cartId);
        shoppingCart.setCompanyId(CompanyThreadLocal.getCompanyId());
        return shoppingCart;
    }

    public ShoppingCart remove(long cartId) throws NoSuchCartException {
        return this.remove(Long.valueOf(cartId));
    }

    public ShoppingCart remove(Serializable primaryKey) throws NoSuchCartException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
            if (shoppingCart == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingCart shoppingCart2 = (ShoppingCart)this.remove((BaseModel)shoppingCart);
            return shoppingCart2;
        }
        catch (NoSuchCartException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart removeImpl(ShoppingCart shoppingCart) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingCart)) {
                shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, shoppingCart.getPrimaryKeyObj());
            }
            if (shoppingCart != null) {
                session.delete((Object)shoppingCart);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingCart != null) {
            this.clearCache(shoppingCart);
        }
        return shoppingCart;
    }

    public ShoppingCart updateImpl(ShoppingCart shoppingCart) {
        boolean isNew = shoppingCart.isNew();
        if (!(shoppingCart instanceof ShoppingCartModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(shoppingCart.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)shoppingCart);
                throw new IllegalArgumentException("Implement ModelWrapper in shoppingCart proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ShoppingCart implementation " + shoppingCart.getClass());
        }
        ShoppingCartModelImpl shoppingCartModelImpl = (ShoppingCartModelImpl)shoppingCart;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && shoppingCart.getCreateDate() == null) {
            if (serviceContext == null) {
                shoppingCart.setCreateDate(date);
            } else {
                shoppingCart.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!shoppingCartModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                shoppingCart.setModifiedDate(date);
            } else {
                shoppingCart.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)shoppingCart);
                shoppingCart.setNew(false);
            } else {
                shoppingCart = (ShoppingCart)session.merge((Object)shoppingCart);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ShoppingCartModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{shoppingCartModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{shoppingCartModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{shoppingCartModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((shoppingCartModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{shoppingCartModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
        }
        this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart, false);
        this.clearUniqueFindersCache(shoppingCartModelImpl, false);
        this.cacheUniqueFindersCache(shoppingCartModelImpl);
        shoppingCart.resetOriginalValues();
        return shoppingCart;
    }

    public ShoppingCart findByPrimaryKey(Serializable primaryKey) throws NoSuchCartException {
        ShoppingCart shoppingCart = this.fetchByPrimaryKey(primaryKey);
        if (shoppingCart == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingCart;
    }

    public ShoppingCart findByPrimaryKey(long cartId) throws NoSuchCartException {
        return this.findByPrimaryKey(Long.valueOf(cartId));
    }

    public ShoppingCart fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ShoppingCart shoppingCart = (ShoppingCart)serializable;
        if (shoppingCart == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
                if (shoppingCart != null) {
                    this.cacheResult(shoppingCart);
                } else {
                    this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByPrimaryKey(long cartId) {
        return this.fetchByPrimaryKey(Long.valueOf(cartId));
    }

    public Map<Serializable, ShoppingCart> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingCart> map = new HashMap<Serializable, ShoppingCart>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingCart shoppingCart = this.fetchByPrimaryKey(primaryKey);
            if (shoppingCart != null) {
                map.put(primaryKey, shoppingCart);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (ShoppingCart)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_SHOPPINGCART_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (ShoppingCart shoppingCart : query.list()) {
                map.put(shoppingCart.getPrimaryKeyObj(), shoppingCart);
                this.cacheResult(shoppingCart);
                uncachedPrimaryKeys.remove(shoppingCart.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<ShoppingCart> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingCart> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingCart> findAll(int start, int end, OrderByComparator<ShoppingCart> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingCart> findAll(int start, int end, OrderByComparator<ShoppingCart> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_SHOPPINGCART);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGCART;
                sql = sql.concat(" ORDER BY shoppingCart.cartId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingCart shoppingCart : this.findAll()) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_SHOPPINGCART);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingCartModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByGroupId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByUserId = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathFetchByG_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_U", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByG_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_U", new String[]{Long.class.getName(), Long.class.getName()});
        this._setShoppingCartUtilPersistence(this);
    }

    public void destroy() {
        this._setShoppingCartUtilPersistence(null);
        this.entityCache.removeCache(ShoppingCartImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private void _setShoppingCartUtilPersistence(ShoppingCartPersistence shoppingCartPersistence) {
        try {
            Field field = ShoppingCartUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, shoppingCartPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

