/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shopping.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.shopping.exception.NoSuchCategoryException;
import com.liferay.shopping.model.ShoppingCategory;
import com.liferay.shopping.model.impl.ShoppingCategoryImpl;
import com.liferay.shopping.model.impl.ShoppingCategoryModelImpl;
import com.liferay.shopping.service.persistence.ShoppingCategoryPersistence;
import com.liferay.shopping.service.persistence.ShoppingCategoryUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ShoppingCategoryPersistenceImpl
extends BasePersistenceImpl<ShoppingCategory>
implements ShoppingCategoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingCategoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingCategory.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByG_P;
    private FinderPath _finderPathWithoutPaginationFindByG_P;
    private FinderPath _finderPathCountByG_P;
    private static final String _FINDER_COLUMN_G_P_GROUPID_2 = "shoppingCategory.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_P_PARENTCATEGORYID_2 = "shoppingCategory.parentCategoryId = ?";
    private FinderPath _finderPathFetchByG_N;
    private FinderPath _finderPathCountByG_N;
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "shoppingCategory.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "shoppingCategory.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(shoppingCategory.name IS NULL OR shoppingCategory.name = '')";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_SHOPPINGCATEGORY = "SELECT shoppingCategory FROM ShoppingCategory shoppingCategory";
    private static final String _SQL_SELECT_SHOPPINGCATEGORY_WHERE_PKS_IN = "SELECT shoppingCategory FROM ShoppingCategory shoppingCategory WHERE categoryId IN (";
    private static final String _SQL_SELECT_SHOPPINGCATEGORY_WHERE = "SELECT shoppingCategory FROM ShoppingCategory shoppingCategory WHERE ";
    private static final String _SQL_COUNT_SHOPPINGCATEGORY = "SELECT COUNT(shoppingCategory) FROM ShoppingCategory shoppingCategory";
    private static final String _SQL_COUNT_SHOPPINGCATEGORY_WHERE = "SELECT COUNT(shoppingCategory) FROM ShoppingCategory shoppingCategory WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "shoppingCategory.categoryId";
    private static final String _FILTER_SQL_SELECT_SHOPPINGCATEGORY_WHERE = "SELECT DISTINCT {shoppingCategory.*} FROM ShoppingCategory shoppingCategory WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingCategory.*} FROM (SELECT DISTINCT shoppingCategory.categoryId FROM ShoppingCategory shoppingCategory WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingCategory ON TEMP_TABLE.categoryId = ShoppingCategory.categoryId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGCATEGORY_WHERE = "SELECT COUNT(DISTINCT shoppingCategory.categoryId) AS COUNT_VALUE FROM ShoppingCategory shoppingCategory WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingCategory";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingCategory";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingCategory.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingCategory.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingCategory exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingCategory exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ShoppingCategoryPersistenceImpl.class);

    public List<ShoppingCategory> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingCategory> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingCategory> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<ShoppingCategory> findByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCategory shoppingCategory : list) {
                if (groupId == shoppingCategory.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCategory findByGroupId_First(long groupId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByGroupId_First(groupId, orderByComparator);
        if (shoppingCategory != null) {
            return shoppingCategory;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchCategoryException(sb.toString());
    }

    public ShoppingCategory fetchByGroupId_First(long groupId, OrderByComparator<ShoppingCategory> orderByComparator) {
        List<ShoppingCategory> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCategory findByGroupId_Last(long groupId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (shoppingCategory != null) {
            return shoppingCategory;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchCategoryException(sb.toString());
    }

    public ShoppingCategory fetchByGroupId_Last(long groupId, OrderByComparator<ShoppingCategory> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCategory> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCategory[] findByGroupId_PrevAndNext(long categoryId, long groupId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.findByPrimaryKey(categoryId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCategory[] array = new ShoppingCategoryImpl[]{this.getByGroupId_PrevAndNext(session, shoppingCategory, groupId, orderByComparator, true), shoppingCategory, this.getByGroupId_PrevAndNext(session, shoppingCategory, groupId, orderByComparator, false)};
            ShoppingCategory[] shoppingCategoryArray = array;
            return shoppingCategoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCategory getByGroupId_PrevAndNext(Session session, ShoppingCategory shoppingCategory, long groupId, OrderByComparator<ShoppingCategory> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCategory)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ShoppingCategory)list.get(1);
        }
        return null;
    }

    public List<ShoppingCategory> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingCategory> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    public List<ShoppingCategory> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        } else {
            sb.append(" ORDER BY ShoppingCategory.parentCategoryId ASC, ShoppingCategory.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, ShoppingCategoryImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, ShoppingCategoryImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingCategory[] filterFindByGroupId_PrevAndNext(long categoryId, long groupId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByGroupId_PrevAndNext(categoryId, groupId, orderByComparator);
        }
        ShoppingCategory shoppingCategory = this.findByPrimaryKey(categoryId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCategory[] array = new ShoppingCategoryImpl[]{this.filterGetByGroupId_PrevAndNext(session, shoppingCategory, groupId, orderByComparator, true), shoppingCategory, this.filterGetByGroupId_PrevAndNext(session, shoppingCategory, groupId, orderByComparator, false)};
            ShoppingCategory[] shoppingCategoryArray = array;
            return shoppingCategoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCategory filterGetByGroupId_PrevAndNext(Session session, ShoppingCategory shoppingCategory, long groupId, OrderByComparator<ShoppingCategory> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        } else {
            sb.append(" ORDER BY ShoppingCategory.parentCategoryId ASC, ShoppingCategory.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, ShoppingCategoryImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, ShoppingCategoryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCategory)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (ShoppingCategory)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (ShoppingCategory shoppingCategory : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCategory);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_SHOPPINGCATEGORY_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_SHOPPINGCATEGORY_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingCategory> findByG_P(long groupId, long parentCategoryId) {
        return this.findByG_P(groupId, parentCategoryId, -1, -1, null);
    }

    public List<ShoppingCategory> findByG_P(long groupId, long parentCategoryId, int start, int end) {
        return this.findByG_P(groupId, parentCategoryId, start, end, null);
    }

    public List<ShoppingCategory> findByG_P(long groupId, long parentCategoryId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator) {
        return this.findByG_P(groupId, parentCategoryId, start, end, orderByComparator, true);
    }

    public List<ShoppingCategory> findByG_P(long groupId, long parentCategoryId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_P;
                finderArgs = new Object[]{groupId, parentCategoryId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_P;
            finderArgs = new Object[]{groupId, parentCategoryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (ShoppingCategory shoppingCategory : list) {
                if (groupId == shoppingCategory.getGroupId() && parentCategoryId == shoppingCategory.getParentCategoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
            sb.append("shoppingCategory.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(parentCategoryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCategory findByG_P_First(long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByG_P_First(groupId, parentCategoryId, orderByComparator);
        if (shoppingCategory != null) {
            return shoppingCategory;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", parentCategoryId=");
        sb.append(parentCategoryId);
        sb.append("}");
        throw new NoSuchCategoryException(sb.toString());
    }

    public ShoppingCategory fetchByG_P_First(long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) {
        List<ShoppingCategory> list = this.findByG_P(groupId, parentCategoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCategory findByG_P_Last(long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByG_P_Last(groupId, parentCategoryId, orderByComparator);
        if (shoppingCategory != null) {
            return shoppingCategory;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", parentCategoryId=");
        sb.append(parentCategoryId);
        sb.append("}");
        throw new NoSuchCategoryException(sb.toString());
    }

    public ShoppingCategory fetchByG_P_Last(long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) {
        int count = this.countByG_P(groupId, parentCategoryId);
        if (count == 0) {
            return null;
        }
        List<ShoppingCategory> list = this.findByG_P(groupId, parentCategoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCategory[] findByG_P_PrevAndNext(long categoryId, long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.findByPrimaryKey(categoryId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCategory[] array = new ShoppingCategoryImpl[]{this.getByG_P_PrevAndNext(session, shoppingCategory, groupId, parentCategoryId, orderByComparator, true), shoppingCategory, this.getByG_P_PrevAndNext(session, shoppingCategory, groupId, parentCategoryId, orderByComparator, false)};
            ShoppingCategory[] shoppingCategoryArray = array;
            return shoppingCategoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCategory getByG_P_PrevAndNext(Session session, ShoppingCategory shoppingCategory, long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        sb.append("shoppingCategory.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(parentCategoryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCategory)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ShoppingCategory)list.get(1);
        }
        return null;
    }

    public List<ShoppingCategory> filterFindByG_P(long groupId, long parentCategoryId) {
        return this.filterFindByG_P(groupId, parentCategoryId, -1, -1, null);
    }

    public List<ShoppingCategory> filterFindByG_P(long groupId, long parentCategoryId, int start, int end) {
        return this.filterFindByG_P(groupId, parentCategoryId, start, end, null);
    }

    public List<ShoppingCategory> filterFindByG_P(long groupId, long parentCategoryId, int start, int end, OrderByComparator<ShoppingCategory> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_P(groupId, parentCategoryId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("shoppingCategory.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        } else {
            sb.append(" ORDER BY ShoppingCategory.parentCategoryId ASC, ShoppingCategory.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, ShoppingCategoryImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, ShoppingCategoryImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(parentCategoryId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingCategory[] filterFindByG_P_PrevAndNext(long categoryId, long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator) throws NoSuchCategoryException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_P_PrevAndNext(categoryId, groupId, parentCategoryId, orderByComparator);
        }
        ShoppingCategory shoppingCategory = this.findByPrimaryKey(categoryId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCategory[] array = new ShoppingCategoryImpl[]{this.filterGetByG_P_PrevAndNext(session, shoppingCategory, groupId, parentCategoryId, orderByComparator, true), shoppingCategory, this.filterGetByG_P_PrevAndNext(session, shoppingCategory, groupId, parentCategoryId, orderByComparator, false)};
            ShoppingCategory[] shoppingCategoryArray = array;
            return shoppingCategoryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCategory filterGetByG_P_PrevAndNext(Session session, ShoppingCategory shoppingCategory, long groupId, long parentCategoryId, OrderByComparator<ShoppingCategory> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("shoppingCategory.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_SHOPPINGCATEGORY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
        } else {
            sb.append(" ORDER BY ShoppingCategory.parentCategoryId ASC, ShoppingCategory.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, ShoppingCategoryImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, ShoppingCategoryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(groupId);
        queryPos.add(parentCategoryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)shoppingCategory)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (ShoppingCategory)list.get(1);
        }
        return null;
    }

    public void removeByG_P(long groupId, long parentCategoryId) {
        for (ShoppingCategory shoppingCategory : this.findByG_P(groupId, parentCategoryId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCategory);
        }
    }

    public int countByG_P(long groupId, long parentCategoryId) {
        FinderPath finderPath = this._finderPathCountByG_P;
        Object[] finderArgs = new Object[]{groupId, parentCategoryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_SHOPPINGCATEGORY_WHERE);
            sb.append("shoppingCategory.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(parentCategoryId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_P(long groupId, long parentCategoryId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_P(groupId, parentCategoryId);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_SHOPPINGCATEGORY_WHERE);
        sb.append("shoppingCategory.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_P_PARENTCATEGORYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)ShoppingCategory.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(parentCategoryId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingCategory findByG_N(long groupId, String name) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByG_N(groupId, name);
        if (shoppingCategory == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", name=");
            sb.append(name);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCategoryException(sb.toString());
        }
        return shoppingCategory;
    }

    public ShoppingCategory fetchByG_N(long groupId, String name) {
        return this.fetchByG_N(groupId, name, true);
    }

    public ShoppingCategory fetchByG_N(long groupId, String name, boolean useFinderCache) {
        ShoppingCategory shoppingCategory;
        name = Objects.toString(name, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, name};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_N, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof ShoppingCategory && (groupId != (shoppingCategory = (ShoppingCategory)result).getGroupId() || !Objects.equals(name, shoppingCategory.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE);
            sb.append("shoppingCategory.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByG_N, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{groupId, name};
                            }
                            _log.warn((Object)("ShoppingCategoryPersistenceImpl.fetchByG_N(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ShoppingCategory shoppingCategory2 = (ShoppingCategory)list.get(0);
                    result = shoppingCategory2;
                    this.cacheResult(shoppingCategory2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByG_N, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingCategory)result;
    }

    public ShoppingCategory removeByG_N(long groupId, String name) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.findByG_N(groupId, name);
        return (ShoppingCategory)this.remove((BaseModel)shoppingCategory);
    }

    public int countByG_N(long groupId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByG_N;
        Object[] finderArgs = new Object[]{groupId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_SHOPPINGCATEGORY_WHERE);
            sb.append("shoppingCategory.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                sb.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindName) {
                    queryPos.add(name);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCategoryPersistenceImpl() {
        this.setModelClass(ShoppingCategory.class);
    }

    public void cacheResult(ShoppingCategory shoppingCategory) {
        this.entityCache.putResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, (Serializable)Long.valueOf(shoppingCategory.getPrimaryKey()), (Serializable)shoppingCategory);
        this.finderCache.putResult(this._finderPathFetchByG_N, new Object[]{shoppingCategory.getGroupId(), shoppingCategory.getName()}, (Object)shoppingCategory);
        shoppingCategory.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingCategory> shoppingCategories) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && shoppingCategories.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ShoppingCategory shoppingCategory : shoppingCategories) {
            if (this.entityCache.getResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, (Serializable)Long.valueOf(shoppingCategory.getPrimaryKey())) == null) {
                this.cacheResult(shoppingCategory);
                continue;
            }
            shoppingCategory.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ShoppingCategoryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingCategory shoppingCategory) {
        this.entityCache.removeResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, (Serializable)Long.valueOf(shoppingCategory.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ShoppingCategoryModelImpl)shoppingCategory, true);
    }

    public void clearCache(List<ShoppingCategory> shoppingCategories) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingCategory shoppingCategory : shoppingCategories) {
            this.entityCache.removeResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, (Serializable)Long.valueOf(shoppingCategory.getPrimaryKey()));
            this.clearUniqueFindersCache((ShoppingCategoryModelImpl)shoppingCategory, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingCategoryModelImpl shoppingCategoryModelImpl) {
        Object[] args = new Object[]{shoppingCategoryModelImpl.getGroupId(), shoppingCategoryModelImpl.getName()};
        this.finderCache.putResult(this._finderPathCountByG_N, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_N, args, (Object)shoppingCategoryModelImpl, false);
    }

    protected void clearUniqueFindersCache(ShoppingCategoryModelImpl shoppingCategoryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{shoppingCategoryModelImpl.getGroupId(), shoppingCategoryModelImpl.getName()};
            this.finderCache.removeResult(this._finderPathCountByG_N, args);
            this.finderCache.removeResult(this._finderPathFetchByG_N, args);
        }
        if ((shoppingCategoryModelImpl.getColumnBitmask() & this._finderPathFetchByG_N.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingCategoryModelImpl.getOriginalGroupId(), shoppingCategoryModelImpl.getOriginalName()};
            this.finderCache.removeResult(this._finderPathCountByG_N, args);
            this.finderCache.removeResult(this._finderPathFetchByG_N, args);
        }
    }

    public ShoppingCategory create(long categoryId) {
        ShoppingCategoryImpl shoppingCategory = new ShoppingCategoryImpl();
        shoppingCategory.setNew(true);
        shoppingCategory.setPrimaryKey(categoryId);
        shoppingCategory.setCompanyId(CompanyThreadLocal.getCompanyId());
        return shoppingCategory;
    }

    public ShoppingCategory remove(long categoryId) throws NoSuchCategoryException {
        return this.remove(Long.valueOf(categoryId));
    }

    public ShoppingCategory remove(Serializable primaryKey) throws NoSuchCategoryException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCategory shoppingCategory = (ShoppingCategory)session.get(ShoppingCategoryImpl.class, primaryKey);
            if (shoppingCategory == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCategoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingCategory shoppingCategory2 = (ShoppingCategory)this.remove((BaseModel)shoppingCategory);
            return shoppingCategory2;
        }
        catch (NoSuchCategoryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCategory removeImpl(ShoppingCategory shoppingCategory) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)shoppingCategory)) {
                shoppingCategory = (ShoppingCategory)session.get(ShoppingCategoryImpl.class, shoppingCategory.getPrimaryKeyObj());
            }
            if (shoppingCategory != null) {
                session.delete((Object)shoppingCategory);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingCategory != null) {
            this.clearCache(shoppingCategory);
        }
        return shoppingCategory;
    }

    public ShoppingCategory updateImpl(ShoppingCategory shoppingCategory) {
        boolean isNew = shoppingCategory.isNew();
        if (!(shoppingCategory instanceof ShoppingCategoryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(shoppingCategory.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)shoppingCategory);
                throw new IllegalArgumentException("Implement ModelWrapper in shoppingCategory proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ShoppingCategory implementation " + shoppingCategory.getClass());
        }
        ShoppingCategoryModelImpl shoppingCategoryModelImpl = (ShoppingCategoryModelImpl)shoppingCategory;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && shoppingCategory.getCreateDate() == null) {
            if (serviceContext == null) {
                shoppingCategory.setCreateDate(date);
            } else {
                shoppingCategory.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!shoppingCategoryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                shoppingCategory.setModifiedDate(date);
            } else {
                shoppingCategory.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)shoppingCategory);
                shoppingCategory.setNew(false);
            } else {
                shoppingCategory = (ShoppingCategory)session.merge((Object)shoppingCategory);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ShoppingCategoryModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{shoppingCategoryModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByGroupId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{shoppingCategoryModelImpl.getGroupId(), shoppingCategoryModelImpl.getParentCategoryId()};
            this.finderCache.removeResult(this._finderPathCountByG_P, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_P, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((shoppingCategoryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCategoryModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{shoppingCategoryModelImpl.getGroupId()};
                this.finderCache.removeResult(this._finderPathCountByGroupId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((shoppingCategoryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_P.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCategoryModelImpl.getOriginalGroupId(), shoppingCategoryModelImpl.getOriginalParentCategoryId()};
                this.finderCache.removeResult(this._finderPathCountByG_P, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_P, args);
                args = new Object[]{shoppingCategoryModelImpl.getGroupId(), shoppingCategoryModelImpl.getParentCategoryId()};
                this.finderCache.removeResult(this._finderPathCountByG_P, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_P, args);
            }
        }
        this.entityCache.putResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, (Serializable)Long.valueOf(shoppingCategory.getPrimaryKey()), (Serializable)shoppingCategory, false);
        this.clearUniqueFindersCache(shoppingCategoryModelImpl, false);
        this.cacheUniqueFindersCache(shoppingCategoryModelImpl);
        shoppingCategory.resetOriginalValues();
        return shoppingCategory;
    }

    public ShoppingCategory findByPrimaryKey(Serializable primaryKey) throws NoSuchCategoryException {
        ShoppingCategory shoppingCategory = this.fetchByPrimaryKey(primaryKey);
        if (shoppingCategory == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCategoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingCategory;
    }

    public ShoppingCategory findByPrimaryKey(long categoryId) throws NoSuchCategoryException {
        return this.findByPrimaryKey(Long.valueOf(categoryId));
    }

    public ShoppingCategory fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        ShoppingCategory shoppingCategory = (ShoppingCategory)serializable;
        if (shoppingCategory == null) {
            Session session = null;
            try {
                session = this.openSession();
                shoppingCategory = (ShoppingCategory)session.get(ShoppingCategoryImpl.class, primaryKey);
                if (shoppingCategory != null) {
                    this.cacheResult(shoppingCategory);
                } else {
                    this.entityCache.putResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingCategory;
    }

    public ShoppingCategory fetchByPrimaryKey(long categoryId) {
        return this.fetchByPrimaryKey(Long.valueOf(categoryId));
    }

    public Map<Serializable, ShoppingCategory> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, ShoppingCategory> map = new HashMap<Serializable, ShoppingCategory>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            ShoppingCategory shoppingCategory = this.fetchByPrimaryKey(primaryKey);
            if (shoppingCategory != null) {
                map.put(primaryKey, shoppingCategory);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (ShoppingCategory)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_SHOPPINGCATEGORY_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (ShoppingCategory shoppingCategory : query.list()) {
                map.put(shoppingCategory.getPrimaryKeyObj(), shoppingCategory);
                this.cacheResult(shoppingCategory);
                uncachedPrimaryKeys.remove(shoppingCategory.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<ShoppingCategory> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingCategory> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ShoppingCategory> findAll(int start, int end, OrderByComparator<ShoppingCategory> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ShoppingCategory> findAll(int start, int end, OrderByComparator<ShoppingCategory> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_SHOPPINGCATEGORY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGCATEGORY;
                sql = sql.concat(" ORDER BY shoppingCategory.parentCategoryId ASC, shoppingCategory.name ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ShoppingCategory shoppingCategory : this.findAll()) {
            this.remove((BaseModel)shoppingCategory);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_SHOPPINGCATEGORY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ShoppingCategoryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 7L);
        this._finderPathCountByGroupId = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByG_P = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_P", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_P = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_P", new String[]{Long.class.getName(), Long.class.getName()}, 7L);
        this._finderPathCountByG_P = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_P", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathFetchByG_N = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, ShoppingCategoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()}, 3L);
        this._finderPathCountByG_N = new FinderPath(ShoppingCategoryModelImpl.ENTITY_CACHE_ENABLED, ShoppingCategoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
        this._setShoppingCategoryUtilPersistence(this);
    }

    public void destroy() {
        this._setShoppingCategoryUtilPersistence(null);
        this.entityCache.removeCache(ShoppingCategoryImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private void _setShoppingCategoryUtilPersistence(ShoppingCategoryPersistence shoppingCategoryPersistence) {
        try {
            Field field = ShoppingCategoryUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, shoppingCategoryPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

